/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.Util;

public abstract class TreeChild
extends TreeNode {
    public static final String PROP_PARENT_NODE = "parentNode";
    private TreeParentNode parentNode;

    protected TreeChild() {
    }

    protected TreeChild(TreeChild child) {
        super(child);
    }

    public final TreeDocumentRoot getOwnerDocument() {
        if (this instanceof TreeDocumentRoot) {
            return (TreeDocumentRoot)((Object)this);
        }
        if (this.getParentNode() == null) {
            return null;
        }
        return this.getParentNode().getOwnerDocument();
    }

    public final boolean isInContext() {
        return this.getParentNode() != null;
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.getParentNode().removeChild(this);
        }
    }

    public final TreeParentNode getParentNode() {
        return this.parentNode;
    }

    protected final void setParentNode(TreeParentNode newParentNode) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeChild::setParentNode [ " + this + " ] : newParentNode = " + newParentNode);
        }
        if (Util.equals(this.parentNode, newParentNode)) {
            return;
        }
        TreeParentNode oldParentNode = this.parentNode;
        this.parentNode = newParentNode;
        this.firePropertyChange(PROP_PARENT_NODE, oldParentNode, newParentNode);
    }

    public final TreeChild getPreviousSibling() {
        int index = this.index();
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        return (TreeChild)this.getParentNode().getChildNodes().get(index - 1);
    }

    public final TreeChild getNextSibling() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeChild [ " + this + " ] ::getNextSibling: parentNode = " + this.getParentNode());
        }
        int index = this.index();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    index : " + index);
        }
        if (index == -1) {
            return null;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    parentNode.childNodes.size : " + this.getParentNode().getChildNodes().size());
        }
        if (index + 1 == this.getParentNode().getChildNodes().size()) {
            return null;
        }
        return (TreeChild)this.getParentNode().getChildNodes().get(index + 1);
    }

    public final int index() {
        if (this.getParentNode() == null) {
            return -1;
        }
        return this.getParentNode().indexOf(this);
    }

    public final boolean isDescendantOf(TreeParentNode testParentNode) {
        for (TreeParentNode ancestor = this.getParentNode(); ancestor != null; ancestor = ancestor.getParentNode()) {
            if (ancestor != testParentNode) continue;
            return true;
        }
        return false;
    }
}

