/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

class J2eePlatformNode
extends AbstractNode
implements PropertyChangeListener,
InstanceListener {
    private static final Logger LOGGER = Logger.getLogger(J2eePlatformNode.class.getName());
    private static final String ARCHIVE_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif";
    private static final String DEFAULT_ICON = "org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif";
    private static final String BROKEN_PROJECT_BADGE = "org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif";
    private static final Icon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/common/project/ui/resources/jar.gif", (boolean)false);
    private static final Image brokenIcon = ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/j2eeServer.gif"), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/project/ui/resources/brokenProjectBadge.gif"), (int)8, (int)0);
    private final PropertyEvaluator evaluator;
    private final String platformPropName;
    private J2eePlatform platformCache;
    private final PropertyChangeListener platformListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayName".equals(evt.getPropertyName())) {
                J2eePlatformNode.this.fireNameChange((String)evt.getOldValue(), (String)evt.getNewValue());
                J2eePlatformNode.this.fireDisplayNameChange((String)evt.getOldValue(), (String)evt.getNewValue());
            }
            if ("classpath".equals(evt.getPropertyName())) {
                J2eePlatformNode.this.postAddNotify();
            }
        }
    };
    private PropertyChangeListener weakPlatformListener;

    private J2eePlatformNode(Project project, PropertyEvaluator evaluator, String platformPropName, ClassPathSupport cs) {
        super((Children)new PlatformContentChildren(project, cs));
        this.evaluator = evaluator;
        this.platformPropName = platformPropName;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        moduleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this, (Object)moduleProvider));
    }

    public static J2eePlatformNode create(Project project, PropertyEvaluator evaluator, String platformPropName, ClassPathSupport cs) {
        return new J2eePlatformNode(project, evaluator, platformPropName, cs);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return "";
    }

    public String getHtmlDisplayName() {
        if (this.getPlatform() != null) {
            return this.getPlatform().getDisplayName();
        }
        return NbBundle.getMessage(J2eePlatformNode.class, (String)"LBL_J2eeServerMissing");
    }

    public Image getIcon(int type) {
        Image result = null;
        if (this.getPlatform() != null) {
            result = this.getPlatform().getIcon();
        }
        return result != null ? result : brokenIcon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[0];
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.platformPropName.equals(evt.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    J2eePlatformNode.this.refresh();
                }
            });
        }
    }

    private void refresh() {
        if (this.platformCache != null) {
            this.platformCache.removePropertyChangeListener(this.weakPlatformListener);
        }
        this.platformCache = null;
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.postAddNotify();
    }

    public void instanceAdded(String serverInstanceID) {
        this.refresh();
    }

    public void instanceRemoved(String serverInstanceID) {
        this.refresh();
    }

    public void changeDefaultInstance(String oldServerInstanceID, String newServerInstanceID) {
    }

    private void postAddNotify() {
        LibrariesNode.rp.post(new Runnable(){

            @Override
            public void run() {
                ((PlatformContentChildren)J2eePlatformNode.this.getChildren()).addNotify();
            }
        });
    }

    private J2eePlatform getPlatform() {
        if (this.platformCache == null) {
            String j2eePlatformInstanceId = this.evaluator.getProperty(this.platformPropName);
            if (j2eePlatformInstanceId != null) {
                this.platformCache = Deployment.getDefault().getJ2eePlatform(j2eePlatformInstanceId);
            }
            if (this.platformCache != null) {
                this.weakPlatformListener = WeakListeners.propertyChange((PropertyChangeListener)this.platformListener, (Object)this.platformCache);
                this.platformCache.addPropertyChangeListener(this.weakPlatformListener);
                this.fireIconChange();
            }
        }
        return this.platformCache;
    }

    private static class PlatformContentChildren
    extends Children.Keys<SourceGroup> {
        private final J2eeModuleProvider j2eeModuleProvider;

        PlatformContentChildren(Project project, ClassPathSupport cs) {
            this.j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        }

        protected void addNotify() {
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        protected Node[] createNodes(SourceGroup sg) {
            return new Node[]{ProjectUISupport.createFilteredLibrariesNode((Node)PackageView.createPackageView((SourceGroup)sg), null, null, null, null, null, null)};
        }

        private List<SourceGroup> getKeys() {
            List<SourceGroup> result;
            J2eePlatform j2eePlatform = ((J2eePlatformNode)this.getNode()).getPlatform();
            if (j2eePlatform != null) {
                result = new ArrayList();
                if (this.j2eeModuleProvider != null) {
                    try {
                        File[] classpathEntries = j2eePlatform.getClasspathEntries(this.j2eeModuleProvider.getConfigSupport().getLibraries());
                        this.addToSourceGroups(classpathEntries, result);
                    }
                    catch (ConfigurationException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                } else {
                    File[] classpathEntries = j2eePlatform.getClasspathEntries();
                    this.addToSourceGroups(classpathEntries, result);
                }
            } else {
                result = Collections.emptyList();
            }
            return result;
        }

        private void addToSourceGroups(File[] classpathEntries, List<SourceGroup> sourceGroups) {
            for (int i = 0; i < classpathEntries.length; ++i) {
                FileObject archiveFile;
                FileObject file = FileUtil.toFileObject((File)classpathEntries[i]);
                if (file == null || (archiveFile = FileUtil.getArchiveRoot((FileObject)file)) == null) continue;
                sourceGroups.add(ProjectUISupport.createLibrariesSourceGroup((FileObject)archiveFile, (String)file.getNameExt(), (Icon)icon, (Icon)icon));
            }
        }
    }
}

