/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public final class SharabilityUtility {
    public static final String DEFAULT_LIBRARIES_FILENAME = "nblibraries.properties";

    private SharabilityUtility() {
    }

    public static String getLibraryLocation(String librariesDir) {
        String librariesDefinition = librariesDir;
        if (librariesDefinition != null) {
            if (!librariesDefinition.endsWith(File.separator)) {
                librariesDefinition = librariesDefinition + File.separatorChar;
            }
            librariesDefinition = librariesDefinition + DEFAULT_LIBRARIES_FILENAME;
        }
        return librariesDefinition;
    }

    public static Library findSharedServerLibrary(File location, String libraryName) throws IOException {
        Parameters.notNull((CharSequence)"location", (Object)location);
        FileObject libraries = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)location));
        if (libraries == null) {
            return null;
        }
        LibraryManager manager = LibraryManager.forLocation((URL)URLMapper.findURL((FileObject)libraries, (int)1));
        Library lib = manager.getLibrary(libraryName);
        if (lib != null && lib.getType().equals("serverlibrary")) {
            return lib;
        }
        return null;
    }

    public static Library createLibrary(File location, String libraryName, String serverInstanceId) throws IOException {
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceId);
        if (platform == null) {
            throw new IOException("Server instance does not exist");
        }
        return platform.createLibrary(location, libraryName);
    }

    public static Library findOrCreateLibrary(File location, String serverInstanceId) throws IOException {
        Library lib;
        String prefix;
        Library[] existing = SharabilityUtility.getLibraries(location, serverInstanceId);
        if (existing.length > 0) {
            return existing[0];
        }
        LibraryManager manager = LibraryManager.forLocation((URL)location.toURI().toURL());
        Deployment deployment = Deployment.getDefault();
        String name = prefix = PropertyUtils.getUsablePropertyName((String)deployment.getServerDisplayName(deployment.getServerID(serverInstanceId)));
        int i = 1;
        while ((lib = manager.getLibrary(name)) != null) {
            name = prefix + "-" + i;
            ++i;
        }
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceId);
        if (platform == null) {
            throw new IOException("Server instance does not exist");
        }
        return platform.createLibrary(location, name);
    }

    public static Library[] getLibraries(File location, String serverInstanceId) throws IOException {
        if (serverInstanceId == null) {
            return new Library[0];
        }
        Deployment deployment = Deployment.getDefault();
        String name = deployment.getServerDisplayName(deployment.getServerID(serverInstanceId));
        if (name == null) {
            return new Library[0];
        }
        name = PropertyUtils.getUsablePropertyName((String)name);
        FileObject libraries = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)location));
        if (libraries == null) {
            return new Library[0];
        }
        LibraryManager manager = LibraryManager.forLocation((URL)URLMapper.findURL((FileObject)libraries, (int)1));
        ArrayList<Library> ret = new ArrayList<Library>();
        for (Library lib : manager.getLibraries()) {
            String suffix;
            if (!lib.getType().equals("serverlibrary") || !lib.getName().startsWith(name) || !"".equals(suffix = lib.getName().substring(name.length())) && !suffix.matches("-\\d+")) continue;
            ret.add(lib);
        }
        return ret.toArray(new Library[ret.size()]);
    }

    public static String[] getServerInstances(File location, Library library) {
        if (library == null) {
            return new String[0];
        }
        String name = library.getName();
        Deployment deployment = Deployment.getDefault();
        ArrayList<String> instances = new ArrayList<String>();
        for (String id : deployment.getServerInstanceIDs()) {
            String suffix;
            String propertyId = PropertyUtils.getUsablePropertyName((String)deployment.getServerDisplayName(deployment.getServerID(id)));
            if (!name.startsWith(propertyId) || !"".equals(suffix = name.substring(propertyId.length())) && !suffix.matches("-\\d+")) continue;
            instances.add(id);
        }
        return instances.toArray(new String[instances.size()]);
    }

    public static void switchServerLibrary(String instanceId, String oldServInstID, List<ClassPathSupport.Item> javaClasspathList, UpdateHelper updateHelper) throws IOException {
        if (instanceId != null && !instanceId.equals(oldServInstID) && updateHelper.getAntProjectHelper().getLibrariesLocation() != null) {
            AntProjectHelper helper = updateHelper.getAntProjectHelper();
            File location = helper.resolveFile(helper.getLibrariesLocation());
            HashSet<String> names = new HashSet<String>();
            for (Library foundLib : SharabilityUtility.getLibraries(location, oldServInstID)) {
                names.add(foundLib.getName());
            }
            boolean containLibs = false;
            int i = 0;
            int position = 0;
            Iterator<ClassPathSupport.Item> it = javaClasspathList.iterator();
            while (it.hasNext()) {
                ClassPathSupport.Item item = it.next();
                if (item.getType() == 1 && !item.isBroken() && item.getLibrary().getType().equals("serverlibrary") && names.contains(item.getLibrary().getName())) {
                    it.remove();
                    containLibs = true;
                    position = i;
                }
                ++i;
            }
            if (containLibs) {
                Library lib = SharabilityUtility.findOrCreateLibrary(location, instanceId);
                boolean add = true;
                for (ClassPathSupport.Item item : javaClasspathList) {
                    if (item.getType() != 1 || item.isBroken() || !item.getLibrary().getType().equals("serverlibrary") || !item.getLibrary().getName().equals(lib.getName())) continue;
                    add = false;
                    break;
                }
                if (add) {
                    javaClasspathList.add(position, ClassPathSupport.Item.create((Library)lib, null));
                }
            }
        }
    }

    public static boolean isLibrarySwitchIntended(String instanceId, String oldServInstID, List<ClassPathSupport.Item> javaClasspathList, UpdateHelper updateHelper) throws IOException {
        boolean containLibs = false;
        if (instanceId != null && !instanceId.equals(oldServInstID) && updateHelper.getAntProjectHelper().getLibrariesLocation() != null) {
            AntProjectHelper helper = updateHelper.getAntProjectHelper();
            File location = helper.resolveFile(helper.getLibrariesLocation());
            HashSet<String> names = new HashSet<String>();
            for (Library foundLib : SharabilityUtility.getLibraries(location, oldServInstID)) {
                names.add(foundLib.getName());
            }
            for (ClassPathSupport.Item item : javaClasspathList) {
                if (item.getType() != 1 || item.isBroken() || !item.getLibrary().getType().equals("serverlibrary") || !names.contains(item.getLibrary().getName())) continue;
                containLibs = true;
                break;
            }
        }
        return containLibs;
    }

    public static void makeSureProjectHasCopyLibsLibrary(AntProjectHelper helper, final ReferenceHelper refHelper) {
        if (!helper.isSharableProject() || refHelper.getProjectLibraryManager() == null) {
            return;
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Library lib = refHelper.getProjectLibraryManager().getLibrary("CopyLibs");
                if (lib == null) {
                    try {
                        refHelper.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    boolean version61;
                    List roots = lib.getContent("classpath");
                    boolean bl = version61 = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()])).findResource("org/netbeans/modules/java/j2seproject/copylibstask/CopyFiles.class") == null;
                    if (!version61) {
                        return;
                    }
                    try {
                        refHelper.getProjectLibraryManager().removeLibrary(lib);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        FileObject parent = null;
                        for (URL u : roots) {
                            FileObject fo;
                            URL u2 = FileUtil.getArchiveFile((URL)u);
                            if (u2 != null) {
                                u = u2;
                            }
                            if ((fo = URLMapper.findFileObject((URL)u)) == null) continue;
                            if (parent == null) {
                                parent = fo.getParent();
                            }
                            fo.delete();
                        }
                        if (parent != null && parent.getChildren().length == 0 && parent.getNameExt().equals("CopyLibs")) {
                            parent.delete();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        refHelper.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }
}

