/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SceneLayerTableAdapter
implements TableModel,
SceneListener,
PropertyChangeListener {
    public static final boolean DEBUG = false;
    private static final int COLS = 7;
    public static final int COL_INDEX_LAYER_TYPE = 0;
    public static final int COL_INDEX_LAYER_INDEX = 1;
    public static final int COL_INDEX_LAYER_VISIBILITY_INDICATOR = 2;
    public static final int COL_INDEX_LAYER_LOCK_INDICATOR = 3;
    public static final int COL_INDEX_LAYER_NAME = 4;
    public static final int COL_INDEX_LAYER_POS_X = 5;
    public static final int COL_INDEX_LAYER_POS_Y = 6;
    private Scene scene;
    private ArrayList listeners = new ArrayList();

    public SceneLayerTableAdapter(Scene scene) {
        this.scene = scene;
        this.scene.addSceneListener(this);
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.scene.getLayerCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return false;
        }
        if (columnIndex == 0) {
            return false;
        }
        return columnIndex != 5 && columnIndex != 6 || !this.scene.isLayerLocked(this.scene.getLayerAt(rowIndex));
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Layer.class;
        }
        if (columnIndex == 1) {
            return Integer.class;
        }
        if (columnIndex == 2) {
            return Boolean.class;
        }
        if (columnIndex == 3) {
            return Boolean.class;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        if (columnIndex == 5) {
            return Integer.class;
        }
        if (columnIndex == 6) {
            return Integer.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.scene.getLayerCount() || columnIndex < 0 || columnIndex >= 7) {
            return null;
        }
        Layer layer = this.scene.getLayerAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                return layer;
            }
            case 1: {
                return new Integer(this.scene.indexOf(layer));
            }
            case 2: {
                return new Boolean(this.scene.isLayerVisible(layer));
            }
            case 3: {
                return new Boolean(this.scene.isLayerLocked(layer));
            }
            case 4: {
                return layer.getName();
            }
            case 5: {
                return new Integer(this.scene.getLayerPosition((Layer)layer).x);
            }
            case 6: {
                return new Integer(this.scene.getLayerPosition((Layer)layer).y);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.scene.getLayerCount() || columnIndex < 0 || columnIndex >= 7) {
            throw new IllegalArgumentException("Arguments rowIndex = " + rowIndex + ", columnIndex = " + columnIndex + " are illegal for table of " + this.scene.getLayerCount() + " rows and " + 7 + " columns.");
        }
        Layer layer = this.scene.getLayerAt(rowIndex);
        switch (columnIndex) {
            case 1: {
                Integer indexVal = (Integer)aValue;
                int newIndex = indexVal;
                this.scene.move(layer, newIndex);
                break;
            }
            case 2: {
                boolean visible = (Boolean)aValue;
                this.scene.setLayerVisible(layer, visible);
                break;
            }
            case 3: {
                boolean locked = (Boolean)aValue;
                this.scene.setLayerLocked(layer, locked);
                break;
            }
            case 4: {
                String name = (String)aValue;
                if (name.equals(layer.getName())) {
                    return;
                }
                if (!this.scene.getGameDesign().isComponentNameAvailable(name)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SceneLayerTableAdapter.class, (String)"SceneLayerTableAdapter.noRenameDialog.txt", (Object)name), 0));
                    break;
                }
                layer.setName(name);
                break;
            }
            case 5: {
                Integer xPos = (Integer)aValue;
                this.scene.setLayerPositionX(layer, xPos == null ? 0 : xPos, false);
                break;
            }
            case 6: {
                Integer yPos = (Integer)aValue;
                this.scene.setLayerPositionY(layer, yPos == null ? 0 : yPos, false);
            }
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Z";
            }
            case 2: {
                return "View";
            }
            case 3: {
                return "Lock";
            }
            case 4: {
                return "Name";
            }
            case 5: {
                return "X";
            }
            case 6: {
                return "Y";
            }
        }
        return "???";
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTableChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Layer) {
            Layer layer = (Layer)evt.getSource();
            int index = this.scene.indexOf(layer);
            TableModelEvent e = new TableModelEvent(this, index, index, -1, 0);
            this.fireTableChanged(e);
        }
    }

    @Override
    public void layerAdded(Scene sourceScene, Layer layer, int index) {
        TableModelEvent e = new TableModelEvent(this, index, index, -1, 1);
        layer.addPropertyChangeListener(this);
        this.fireTableChanged(e);
    }

    @Override
    public void layerRemoved(Scene sourceScene, Layer layer, Scene.LayerInfo info, int index) {
        TableModelEvent e = new TableModelEvent(this, index, index, -1, -1);
        layer.removePropertyChangeListener(this);
        this.fireTableChanged(e);
    }

    public void layerModified(Scene sourceScene, Layer layer) {
        int index = sourceScene.indexOf(layer);
        TableModelEvent e = new TableModelEvent(this, index, index, -1, 0);
        this.fireTableChanged(e);
    }

    @Override
    public void layerMoved(Scene sourceScene, Layer layer, int indexOld, int indexNew) {
        this.layerRemoved(sourceScene, layer, null, indexOld);
        this.layerAdded(sourceScene, layer, indexNew);
    }

    @Override
    public void layerLockChanged(Scene sourceScene, Layer layer, boolean locked) {
        this.layerModified(sourceScene, layer);
    }

    @Override
    public void layerPositionChanged(Scene sourceScene, Layer layer, Point oldPosition, Point newPosition, boolean inTransition) {
        this.layerModified(sourceScene, layer);
    }

    @Override
    public void layerVisibilityChanged(Scene sourceScene, Layer layer, boolean visible) {
        this.layerModified(sourceScene, layer);
    }
}

