/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.RenameTiledLayerDialog;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditor;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerNavigator;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerPreviewPanel;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Position;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class TiledLayer
extends Layer
implements ImageResourceListener {
    private TiledLayerPreviewPanel preview;
    private TiledLayerNavigator navigator;
    public static final boolean DEBUG = false;
    EventListenerList listenerList = new EventListenerList();
    private JComponent editor;
    private int[][] grid;

    TiledLayer(GlobalRepository gameDesign, String name, ImageResource imageResource, int rows, int columns, int tileWidth, int tileHeight) {
        super(gameDesign, name, imageResource, tileWidth, tileHeight);
        this.getImageResource().addImageResourceListener(this);
        this.grid = new int[rows][columns];
    }

    TiledLayer(GlobalRepository gameDesign, String name, ImageResource imageResource, int[][] grid, int tileWidth, int tileHeight) {
        super(gameDesign, name, imageResource, tileWidth, tileHeight);
        this.getImageResource().addImageResourceListener(this);
        this.grid = grid;
    }

    TiledLayer(GlobalRepository gameDesign, String name, TiledLayer tiledLayer) {
        super(gameDesign, name, tiledLayer.getImageResource(), tiledLayer.getTileWidth(), tiledLayer.getTileHeight());
        this.getImageResource().addImageResourceListener(this);
        this.grid = new int[tiledLayer.grid.length][];
        for (int i = 0; i < this.grid.length; ++i) {
            int[] copyRow = new int[tiledLayer.grid[i].length];
            System.arraycopy(tiledLayer.grid[i], 0, copyRow, 0, tiledLayer.grid[i].length);
            this.grid[i] = copyRow;
        }
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.getImageResource(), this.getTileWidth(), this.getTileHeight(), false);
    }

    public void addTiledLayerListener(TiledLayerListener l) {
        this.listenerList.add(TiledLayerListener.class, l);
    }

    public void removeTiledLayerListener(TiledLayerListener l) {
        this.listenerList.remove(TiledLayerListener.class, l);
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new TiledLayerEditor(this)) : this.editor;
    }

    public int getRowCount() {
        return this.grid.length;
    }

    public int getColumnCount() {
        if (this.grid.length > 0) {
            return this.grid[0].length;
        }
        return 0;
    }

    public int getTileIndexAt(Position position) {
        return this.getTileIndexAt(position.getRow(), position.getCol());
    }

    public int getTileIndexAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.grid.length || columnIndex >= this.grid[0].length) {
            return 0;
        }
        return this.grid[rowIndex][columnIndex];
    }

    public Tile getTileAt(Position position) {
        return this.getTileAt(position.getRow(), position.getCol());
    }

    public Tile getTileAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return this.getImageResource().getTile(0, this.getTileWidth(), this.getTileHeight(), false);
        }
        Tile tile = null;
        int tileIndex = this.grid[rowIndex][columnIndex];
        tile = this.getImageResource().getTile(tileIndex, this.getTileWidth(), this.getTileHeight(), false);
        return tile;
    }

    public void setTileAtPositions(int tileIndex, Set positions) {
        Position[] copy;
        for (Position pos : copy = positions.toArray(new Position[positions.size()])) {
            this.updateIndexGrid(tileIndex, pos.getRow(), pos.getCol());
        }
        this.fireTilesChanged(positions);
    }

    private void fireTilesChanged(Set positions) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).tilesChanged(this, positions);
        }
    }

    private void fireTilesChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).tilesStructureChanged(this);
        }
    }

    private Set getAnimatedTiles() {
        HashSet<Tile> set = new HashSet<Tile>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                Tile tile = this.getImageResource().getTile(this.grid[i][j], this.getTileWidth(), this.getTileHeight(), false);
                if (!(tile instanceof AnimatedTile)) continue;
                set.add(tile);
            }
        }
        return set;
    }

    public void setTileAt(int tileIndex, Position position) {
        this.setTileAt(tileIndex, position.getRow(), position.getCol());
    }

    public void setTileAt(int tileIndex, int rowIndex, int columnIndex) {
        if (this.updateIndexGrid(tileIndex, rowIndex, columnIndex)) {
            this.fireTileChanged(rowIndex, columnIndex);
        }
    }

    private void fireTileChanged(int rowIndex, int columnIndex) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).tileChanged(this, rowIndex, columnIndex);
        }
    }

    private boolean updateIndexGrid(int tileIndex, int rowIndex, int columnIndex) {
        while (rowIndex < 0) {
            this.insertRows(0, 1);
            ++rowIndex;
        }
        while (columnIndex < 0) {
            this.insertColumns(0, 1);
            ++columnIndex;
        }
        boolean changed = false;
        if (rowIndex >= this.getRowCount() || columnIndex >= this.getColumnCount()) {
            this.growLayerToSize(rowIndex, columnIndex);
            changed = true;
        }
        if (this.grid[rowIndex][columnIndex] == tileIndex && !changed) {
            return false;
        }
        this.grid[rowIndex][columnIndex] = tileIndex;
        return true;
    }

    public void growLayerToSize(int rows, int cols) {
        int newRowCount;
        int origRows = this.getRowCount();
        int origCols = this.getColumnCount();
        if (rows >= this.getRowCount()) {
            newRowCount = rows + 1;
            int[][] newRows = new int[newRowCount][];
            System.arraycopy(this.grid, 0, newRows, 0, this.grid.length);
            for (int row = this.grid.length; row < newRowCount; ++row) {
                newRows[row] = new int[this.getColumnCount()];
            }
            this.grid = newRows;
        }
        if (cols >= this.getColumnCount()) {
            int newColCount = cols + 1;
            for (int row = 0; row < this.getRowCount(); ++row) {
                int[] oldRow = this.grid[row];
                int[] newRow = new int[newColCount];
                System.arraycopy(oldRow, 0, newRow, 0, oldRow.length);
                this.grid[row] = newRow;
            }
        }
        newRowCount = this.getRowCount();
        int newColCount = this.getColumnCount();
        if (origRows < newRowCount) {
            this.fireRowsInserted(origRows - 1, newRowCount - origRows);
        }
        if (origCols < newColCount) {
            this.fireColumnsInserted(origCols - 1, newColCount - origCols);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        boolean layerEmpty = true;
        int[][] nArray = this.grid;
        synchronized (this.grid) {
            for (int r = 0; r < this.grid.length; ++r) {
                for (int c = 0; c < this.grid[r].length; ++c) {
                    if (this.grid[r][c] == 0) continue;
                    left = Math.min(left, c);
                    right = Math.max(right, c);
                    top = Math.min(top, r);
                    bottom = Math.max(bottom, r);
                    layerEmpty = false;
                }
            }
            if (layerEmpty) {
                left = 0;
                right = 0;
                top = 0;
                bottom = 0;
            }
            this.deleteColumns(right + 1, this.grid[0].length - right - 1);
            this.deleteRows(bottom + 1, this.grid.length - bottom - 1);
            this.deleteColumns(0, left);
            this.deleteRows(0, top);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    private void fireRowsInserted(int index, int count) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).rowsInserted(this, index, count);
        }
    }

    private void fireRowsRemoved(int index, int count) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).rowsRemoved(this, index, count);
        }
    }

    private void fireColumnsInserted(int index, int count) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).columnsInserted(this, index, count);
        }
    }

    private void fireColumnsRemoved(int index, int count) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)listeners[i + 1]).columnsRemoved(this, index, count);
        }
    }

    public void insertRows(int insRowIndex, int count) {
        int[][] newGrid = new int[this.grid.length + count][];
        int insertIndex = insRowIndex;
        if (insertIndex > this.grid.length) {
            insertIndex = this.grid.length;
        }
        if (this.grid.length != 0) {
            int rowIndex = 0;
            int newIndex = 0;
            while (newIndex < newGrid.length) {
                if (newIndex < insertIndex) {
                    newGrid[newIndex] = this.grid[rowIndex];
                } else if (newIndex == insertIndex) {
                    for (int i = 0; i < count; ++i) {
                        newGrid[newIndex] = new int[this.grid[0].length];
                        ++newIndex;
                    }
                    if (rowIndex < this.grid.length) {
                        newGrid[newIndex] = this.grid[rowIndex];
                    }
                } else {
                    newGrid[newIndex] = this.grid[rowIndex];
                }
                ++newIndex;
                ++rowIndex;
            }
        } else {
            newGrid[0] = new int[0];
        }
        this.grid = newGrid;
        this.fireRowsInserted(insRowIndex, count);
    }

    public void deleteRows(int rowIndex, int count) {
        int endIndex = rowIndex + count - 1;
        int[][] newGrid = new int[this.grid.length - count][];
        int index = 0;
        for (int r = 0; r < this.grid.length; ++r) {
            if (r >= rowIndex && r <= endIndex) continue;
            newGrid[index] = this.grid[r];
            ++index;
        }
        this.grid = newGrid;
        this.fireRowsRemoved(rowIndex, count);
    }

    public void insertColumns(int colIndex, int count) {
        for (int r = 0; r < this.grid.length; ++r) {
            int[] row = this.grid[r];
            int[] newRow = new int[row.length + count];
            int insertIndex = colIndex;
            if (insertIndex > row.length) {
                insertIndex = row.length;
            }
            if (row.length > 0) {
                System.arraycopy(row, 0, newRow, 0, insertIndex);
                System.arraycopy(row, insertIndex, newRow, insertIndex + count, row.length - insertIndex);
            }
            this.grid[r] = newRow;
        }
        this.fireColumnsInserted(colIndex, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteColumns(int colIndex, int count) {
        int endIndex = colIndex + count;
        int[][] nArray = this.grid;
        synchronized (this.grid) {
            for (int r = 0; r < this.grid.length; ++r) {
                int[] newRow = new int[this.grid[r].length - count];
                System.arraycopy(this.grid[r], 0, newRow, 0, colIndex);
                System.arraycopy(this.grid[r], endIndex, newRow, colIndex, this.grid[r].length - endIndex);
                this.grid[r] = newRow;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.fireColumnsRemoved(colIndex, count);
            return;
        }
    }

    @Override
    public int getHeight() {
        return this.grid.length * this.getTileHeight();
    }

    @Override
    public int getWidth() {
        if (this.grid.length != 0) {
            return this.grid[0].length * this.getTileWidth();
        }
        return 0;
    }

    @Override
    public List<Action> getActions() {
        List<Action> superActions = super.getActions();
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(superActions);
        actions.add(new RenameAction());
        return actions;
    }

    @Override
    public String getDisplayableTypeName() {
        return NbBundle.getMessage(TiledLayer.class, (String)"TiledLayer.text");
    }

    public int[][] getTiles() {
        return TiledLayer.cloneTiles(this.grid);
    }

    public void setTiles(int[][] newGrid) {
        this.grid = TiledLayer.cloneTiles(newGrid);
        this.fireTilesChanged();
    }

    public static int[][] cloneTiles(int[][] grid) {
        int[][] clone = new int[grid.length][];
        for (int r = 0; r < grid.length; ++r) {
            clone[r] = new int[grid[r].length];
            System.arraycopy(grid[r], 0, clone[r], 0, grid[r].length);
        }
        return clone;
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
    }

    @Override
    public JComponent getPreview() {
        if (this.preview == null) {
            this.preview = new TiledLayerPreviewPanel(this, true);
            return this.preview;
        }
        return this.preview;
    }

    @Override
    public JComponent getNavigator() {
        if (this.navigator == null) {
            this.navigator = new TiledLayerNavigator(this);
            return this.navigator;
        }
        return this.navigator;
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle rect = g.getClipBounds();
        int tileWidth = super.getTileWidth();
        int tileHeight = super.getTileHeight();
        int minRow = rect.y / tileHeight;
        int maxRow = (rect.y + rect.height) / tileHeight + 1;
        int minCol = rect.x / tileWidth;
        int maxCol = (rect.x + rect.width) / tileWidth + 1;
        for (int r = minRow; r < this.getRowCount() && r < maxRow; ++r) {
            for (int c = minCol; c < this.getColumnCount() && c < maxCol; ++c) {
                this.getImageResource().paint(this.grid[r][c], g, c * tileWidth, r * tileHeight, tileWidth, tileHeight, false);
            }
        }
    }

    @Override
    public void animatedTileAdded(ImageResource source, AnimatedTile tile) {
    }

    @Override
    public void animatedTileRemoved(ImageResource source, AnimatedTile tile) {
        HashSet<Position> changes = new HashSet<Position>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                if (tile.getIndex() != this.grid[i][j]) continue;
                this.grid[i][j] = 0;
                changes.add(new Position(i, j));
            }
        }
        if (!changes.isEmpty()) {
            this.fireTilesChanged(changes);
        }
    }

    @Override
    public void sequenceAdded(ImageResource source, Sequence sequence) {
    }

    @Override
    public void sequenceRemoved(ImageResource source, Sequence sequence) {
    }

    public class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayer.class, (String)"TiledLayer.RenameAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameTiledLayerDialog dialog = new RenameTiledLayerDialog(TiledLayer.this);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(TiledLayer.class, (String)"TiledLayer.RenameAction.text"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }
}

