/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static final Component component = new Component(){};
    private static final GraphicsConfiguration gc;

    public static BufferedImage loadImage(URL imageURL) throws IllegalArgumentException {
        try {
            BufferedImage im = ImageIO.read(imageURL);
            if (im == null) {
                return null;
            }
            int transparency = im.getColorModel().getTransparency();
            BufferedImage copy = gc.createCompatibleImage(im.getWidth(), im.getHeight(), transparency);
            Graphics2D g2d = copy.createGraphics();
            g2d.drawImage((Image)im, 0, 0, null);
            g2d.dispose();
            return copy;
        }
        catch (IOException e) {
            System.err.println("Load Image error for " + imageURL + ":\n" + e);
            e.printStackTrace();
            return null;
        }
    }

    public static Image getScaledImage(Image image, int maxWidth, int maxHeight) {
        Image scaledImage = image;
        if (maxWidth != 0 && maxHeight != 0) {
            float previewRatio = (float)maxHeight / (float)maxWidth;
            float imgRatio = (float)image.getHeight(null) / (float)image.getWidth(null);
            scaledImage = previewRatio > imgRatio ? image.getScaledInstance(maxWidth, -1, 20) : image.getScaledInstance(-1, maxHeight, 20);
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(scaledImage, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            mediaTracker.removeImage(scaledImage, 0);
            e.printStackTrace();
        }
        mediaTracker.removeImage(scaledImage, 0);
        return scaledImage;
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
    }
}

