/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.vmd.game.dialog.AbstractImagePreviewComponent;
import org.netbeans.modules.vmd.game.model.ImageUtils;
import org.netbeans.modules.vmd.game.model.Position;

public class FullImageGridPreview
extends AbstractImagePreviewComponent {
    private static final boolean DEBUG = false;
    private URL imageURL;
    private BufferedImage originalImage;
    private int cellHeight;
    private int cellWidth;
    private int gridWidth = 3;

    @Override
    public void setTileWidth(int width) {
        this.cellWidth = width;
        this.repaint();
    }

    @Override
    public void setTileHeight(int height) {
        this.cellHeight = height;
        this.repaint();
    }

    @Override
    public void setImageURL(URL imageURL) throws MalformedURLException, IllegalArgumentException {
        this.imageURL = imageURL;
        if (imageURL == null) {
            return;
        }
        BufferedImage image = ImageUtils.loadImage(imageURL);
        if (image == null) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufImg = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
        Graphics2D graphics = (Graphics2D)bufImg.getGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        this.originalImage = bufImg;
        this.cellWidth = this.originalImage.getWidth(this);
        this.cellHeight = this.originalImage.getHeight(this);
        this.repaint();
    }

    @Override
    public URL getImageURL() {
        return this.imageURL;
    }

    @Override
    public Image getImage() {
        return this.originalImage;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.imageURL == null) {
            return super.getPreferredSize();
        }
        int cols = this.originalImage.getWidth() / this.cellWidth;
        int rows = this.originalImage.getHeight() / this.cellHeight;
        int width = this.gridWidth + (this.cellWidth + this.gridWidth) * cols;
        int height = this.gridWidth + (this.cellHeight + this.gridWidth) * rows;
        return new Dimension(width, height);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.originalImage == null) {
            return;
        }
        g2d.clearRect(0, 0, this.getWidth(), this.getWidth());
        this.paintGridLines(g2d);
        this.paintCells(g2d);
    }

    void paintCells(Graphics2D g) {
        Rectangle rect = g.getClipBounds();
        Position topLeft = this.getCellAtPoint(rect.getLocation());
        Position bottomRight = this.getCellAtCoordinates(rect.getLocation().x + rect.width, rect.getLocation().y + rect.height);
        for (int row = topLeft.getRow(); row <= bottomRight.getRow(); ++row) {
            for (int col = topLeft.getCol(); col <= bottomRight.getCol(); ++col) {
                Position cell = new Position(row, col);
                this.paintCellContents(g, cell);
            }
        }
    }

    private void paintCellContents(Graphics2D g, Position cell) {
        Rectangle rect = this.getCellArea(cell);
        int dx = rect.x;
        int dy = rect.y;
        int sx = cell.getCol() * this.cellWidth;
        int sy = cell.getRow() * this.cellHeight;
        g.drawImage(this.originalImage, dx, dy, dx + this.cellWidth, dy + this.cellHeight, sx, sy, sx + this.cellWidth, sy + this.cellHeight, null);
    }

    private Position getCellAtPoint(Point p) {
        return this.getCellAtCoordinates(p.x, p.y);
    }

    private Position getCellAtCoordinates(int x, int y) {
        int row = (y - this.gridWidth) / (this.cellHeight + this.gridWidth);
        int col = (x - this.gridWidth) / (this.cellWidth + this.gridWidth);
        if (x < 0) {
            --col;
        }
        if (y < 0) {
            --row;
        }
        return new Position(row, col);
    }

    private Rectangle getCellArea(Position cell) {
        return this.getCellArea(cell.getRow(), cell.getCol());
    }

    private Rectangle getCellArea(int row, int col) {
        Rectangle cellArea = new Rectangle((this.cellWidth + this.gridWidth) * col + this.gridWidth, (this.cellHeight + this.gridWidth) * row + this.gridWidth, this.cellWidth, this.cellHeight);
        return cellArea;
    }

    private void paintGridLines(Graphics2D g) {
        int vertical;
        int horizontal;
        for (horizontal = 0; horizontal < this.getPreferredSize().height; horizontal += this.cellHeight + this.gridWidth) {
            g.setColor(Color.WHITE);
            g.fillRect(0, horizontal, this.getPreferredSize().width, this.gridWidth);
        }
        for (vertical = 0; vertical < this.getPreferredSize().width; vertical += this.cellWidth + this.gridWidth) {
            g.setColor(Color.WHITE);
            g.fillRect(vertical, 0, this.gridWidth, this.getPreferredSize().height);
        }
        for (horizontal = 0; horizontal < this.getPreferredSize().height; horizontal += this.cellHeight + this.gridWidth) {
            g.setColor(Color.BLACK);
            g.drawLine(1, horizontal + 1, this.getPreferredSize().width - 2, horizontal + 1);
        }
        for (vertical = 0; vertical < this.getPreferredSize().width; vertical += this.cellWidth + this.gridWidth) {
            g.setColor(Color.BLACK);
            g.drawLine(vertical + 1, 1, vertical + 1, this.getPreferredSize().height - 2);
        }
    }

    @Override
    public int getTileWidth() {
        return this.cellWidth;
    }

    @Override
    public int getTileHeight() {
        return this.cellHeight;
    }
}

