/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JToolBar;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.game.GameController;
import org.netbeans.modules.vmd.game.dialog.NewSceneDialog;
import org.netbeans.modules.vmd.game.dialog.NewSimpleTiledLayerDialog;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.EditorManagerListener;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.adapter.GlobalRepositoryComboBoxModel;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class GameEditorView
implements DataEditorView,
EditorManagerListener {
    private static final long serialVersionUID = 3317521472849153199L;
    public static final transient boolean DEBUG = false;
    private DataObjectContext context;
    private transient GameController controller;
    private transient GlobalRepository gameDesign;
    private transient JComponent toolBarRepresentation;
    private transient JComboBox comboGlobal;
    private transient boolean firstTime = false;

    public GameEditorView(DataObjectContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.controller = new GameController(this.context, this);
        if (this.controller.getGameDesign() != null) {
            this.controller.getGameDesign().getMainView().addEditorManagerListener(this);
        }
    }

    public void setGameDesign(GlobalRepository gameDesign) {
        if (this.gameDesign == gameDesign) {
            return;
        }
        if (this.gameDesign != null) {
            this.gameDesign.getMainView().removeEditorManagerListener(this);
        }
        this.gameDesign = gameDesign;
        if (this.gameDesign != null) {
            if (this.comboGlobal == null) {
                this.comboGlobal = new JComboBox();
            }
            GlobalRepositoryComboBoxModel model = new GlobalRepositoryComboBoxModel();
            model.setGameDesign(gameDesign);
            this.comboGlobal.setModel(model);
        }
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return false;
    }

    public Collection<String> getTags() {
        return Collections.singleton("DO_NOT_OPEN_PROPERTIES_WINDOW");
    }

    public String preferredID() {
        return "vmd-midp-game";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.DisplayName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GameEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.controller.getVisualRepresentation();
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolBarRepresentation == null) {
            JToolBar tool = new JToolBar();
            tool.setFloatable(false);
            tool.setRollover(true);
            tool.addSeparator();
            if (this.comboGlobal == null) {
                this.comboGlobal = new JComboBox();
            }
            this.comboGlobal.setMaximumRowCount(16);
            this.comboGlobal.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer retValue = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof GlobalRepository) {
                        retValue.setFont(retValue.getFont().deriveFont(1));
                    } else if (value instanceof String) {
                        retValue.setFont(retValue.getFont().deriveFont(1));
                        retValue.setText("  " + retValue.getText());
                    } else {
                        retValue.setText("    " + retValue.getText());
                    }
                    return retValue;
                }
            });
            this.comboGlobal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object item = GameEditorView.this.comboGlobal.getSelectedItem();
                    if (GameEditorView.this.gameDesign == null) {
                        return;
                    }
                    if (item instanceof Editable) {
                        GameEditorView.this.gameDesign.getMainView().requestEditing((Editable)item);
                    } else if (item instanceof String) {
                        GameEditorView.this.gameDesign.getMainView().requestEditing(GameEditorView.this.gameDesign);
                    }
                }
            });
            if (this.gameDesign != null) {
                this.comboGlobal.setSelectedItem(this.gameDesign.getMainView().getCurrentEditable());
            }
            tool.add(this.comboGlobal);
            tool.addSeparator();
            JButton buttonCreateScene = new JButton(new ImageIcon(this.getClass().getResource("res/new_scene_16.png")));
            buttonCreateScene.setToolTipText(NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateScene.tooltip"));
            buttonCreateScene.setBorderPainted(false);
            buttonCreateScene.setRolloverEnabled(true);
            buttonCreateScene.setSize(14, 14);
            buttonCreateScene.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewSceneDialog dialog = new NewSceneDialog(GameEditorView.this.gameDesign);
                    DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(NewSceneDialog.class, (String)"NewSceneDialog.title.text"));
                    dd.setButtonListener((ActionListener)dialog);
                    dd.setValid(false);
                    dialog.setDialogDescriptor(dd);
                    Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                    d.setVisible(true);
                }
            });
            JButton buttonCreateTiledLayer = new JButton(new ImageIcon(this.getClass().getResource("res/new_tiled_layer_16.png")));
            buttonCreateTiledLayer.setToolTipText(NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateTiledLayer.tooltip"));
            buttonCreateTiledLayer.setBorderPainted(false);
            buttonCreateTiledLayer.setRolloverEnabled(true);
            buttonCreateTiledLayer.setSize(14, 14);
            buttonCreateTiledLayer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TiledLayerDialog nld = new TiledLayerDialog(GameEditorView.this.gameDesign);
                    DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(NewSimpleTiledLayerDialog.class, (String)"NewSimpleTiledLayerDialog.title.text"));
                    dd.setButtonListener((ActionListener)nld);
                    dd.setValid(false);
                    nld.setDialogDescriptor(dd);
                    Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                    d.setVisible(true);
                }
            });
            JButton buttonCreateSprite = new JButton(new ImageIcon(this.getClass().getResource("res/new_sprite_16.png")));
            buttonCreateSprite.setToolTipText(NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateSprite.tooltip"));
            buttonCreateSprite.setBorderPainted(false);
            buttonCreateSprite.setRolloverEnabled(true);
            buttonCreateSprite.setSize(14, 14);
            buttonCreateSprite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpriteDialog nld = new SpriteDialog(GameEditorView.this.gameDesign);
                    DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(GameEditorView.class, (String)"GameEditorView.buttonCreateSprite.txt"));
                    dd.setButtonListener((ActionListener)nld);
                    dd.setValid(false);
                    nld.setDialogDescriptor(dd);
                    Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                    d.setVisible(true);
                }
            });
            tool.add(buttonCreateScene);
            tool.add(buttonCreateTiledLayer);
            tool.add(buttonCreateSprite);
            this.toolBarRepresentation = tool;
        }
        return this.toolBarRepresentation;
    }

    public UndoRedo getUndoRedo() {
        if (this.firstTime) {
            IOSupport.getDocumentSerializer((DataObject)this.context.getDataObject()).getUndoRedoManager().setLimit(100);
        }
        return null;
    }

    public void discardAllEdits() {
        IOSupport.getDocumentSerializer((DataObject)this.context.getDataObject()).getUndoRedoManager().discardAllEdits();
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return 500;
    }

    @Override
    public void editing(Editable e) {
        if (this.comboGlobal != null) {
            this.comboGlobal.setSelectedItem(e);
            this.comboGlobal.repaint();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.context);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }
}

