/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.spi.AstNodeVisitor;

public class AstNodeUtils {
    private static final String INDENT = "   ";

    public static String dumpTree(AstNode node) {
        return AstNodeUtils.dumpTree(node, (CharSequence)null);
    }

    public static String dumpTree(AstNode node, CharSequence source) {
        StringBuffer buf = new StringBuffer();
        AstNodeUtils.dumpTree(node, buf, source);
        System.out.println(buf.toString());
        return buf.toString();
    }

    public static void dumpTree(AstNode node, StringBuffer buf) {
        AstNodeUtils.dumpTree(node, buf, null);
    }

    public static void dumpTree(AstNode node, StringBuffer buf, CharSequence source) {
        AstNodeUtils.dump(node, "", buf, source);
    }

    private static void dump(AstNode node, String prefix, StringBuffer buf, CharSequence source) {
        buf.append(prefix);
        buf.append(node.toString());
        if (source != null && node.startOffset() != -1 && node.endOffset() != -1) {
            buf.append(" (");
            buf.append(source.subSequence(node.startOffset(), node.endOffset()));
            buf.append(")");
        }
        buf.append('\n');
        for (AstNode child : node.children()) {
            AstNodeUtils.dump(child, prefix + INDENT, buf, source);
        }
    }

    public static AstNode getRoot(AstNode node) {
        while (node.parent() != null) {
            node = node.parent();
        }
        return node;
    }

    public static List<AstNode> getAncestors(AstNode node, AstNode.NodeFilter filter) {
        ArrayList<AstNode> matching = new ArrayList<AstNode>();
        AstNode n = node;
        do {
            if (!filter.accepts(n)) continue;
            matching.add(n);
        } while ((n = n.parent()) != null);
        return matching;
    }

    public static List<AstNode> getChildrenRecursivelly(AstNode node, AstNode.NodeFilter filter, boolean recurseOnlyMatching) {
        ArrayList<AstNode> matching = new ArrayList<AstNode>();
        AstNodeUtils.getChildrenRecursivelly(matching, node, filter, recurseOnlyMatching);
        return matching;
    }

    private static void getChildrenRecursivelly(List<AstNode> found, AstNode node, AstNode.NodeFilter filter, boolean recurseOnlyMatching) {
        for (AstNode child : node.children()) {
            if (filter.accepts(child)) {
                found.add(child);
                AstNodeUtils.getChildrenRecursivelly(found, child, filter, recurseOnlyMatching);
                continue;
            }
            if (recurseOnlyMatching) continue;
            AstNodeUtils.getChildrenRecursivelly(found, child, filter, recurseOnlyMatching);
        }
    }

    public static AstNode findNode(AstNode node, int offset, boolean forward, boolean physicalNodeOnly) {
        if (physicalNodeOnly) {
            return AstNodeUtils.findNodeByPhysicalRange(node, offset, forward);
        }
        return AstNodeUtils.findNodeByLogicalRange(node, offset, forward);
    }

    private static AstNode findNodeByPhysicalRange(AstNode node, int offset, boolean forward) {
        for (AstNode child : node.children()) {
            if (AstNodeUtils.matchesNodeRange(child, offset, forward, true)) {
                return child;
            }
            if (node.startOffset() > offset) {
                return null;
            }
            AstNode candidate = AstNodeUtils.findNodeByPhysicalRange(child, offset, forward);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private static AstNode findNodeByLogicalRange(AstNode node, int offset, boolean forward) {
        for (AstNode child : node.children()) {
            AstNode n;
            if (child.isVirtual() && (n = AstNodeUtils.findNodeByLogicalRange(child, offset, forward)) != null) {
                return n;
            }
            if (!AstNodeUtils.matchesNodeRange(child, offset, forward, false)) continue;
            return AstNodeUtils.findNodeByLogicalRange(child, offset, forward);
        }
        return node.isVirtual() ? null : node;
    }

    private static boolean matchesNodeRange(AstNode node, int offset, boolean forward, boolean physicalNodeRangeOnly) {
        int to;
        int from = physicalNodeRangeOnly || node.logicalStartOffset() == -1 ? node.startOffset() : node.logicalStartOffset();
        int n = to = physicalNodeRangeOnly || node.logicalEndOffset() == -1 ? node.endOffset() : node.logicalEndOffset();
        return forward ? offset >= from && offset < to : offset > from && offset <= to;
    }

    public static AstNode getTagNode(AstNode node, int astOffset) {
        if (node.type() == AstNode.NodeType.OPEN_TAG) {
            if (astOffset >= node.startOffset() && astOffset < node.endOffset()) {
                return node;
            }
            AstNode match = node.getMatchingTag();
            if (match != null && match.type() == AstNode.NodeType.ENDTAG && astOffset >= match.startOffset() && astOffset < match.endOffset()) {
                return match;
            }
            return null;
        }
        return node;
    }

    public static AstNode query(AstNode base, String path) {
        return AstNodeUtils.query(base, path, false);
    }

    public static AstNode query(AstNode base, String path, boolean caseInsensitive) {
        StringTokenizer st = new StringTokenizer(path, "/");
        AstNode found = base;
        while (st.hasMoreTokens()) {
            String nodeName;
            String token = st.nextToken();
            int indexDelim = token.indexOf(124);
            String string = nodeName = indexDelim >= 0 ? token.substring(0, indexDelim) : token;
            if (caseInsensitive) {
                nodeName = nodeName.toLowerCase(Locale.ENGLISH);
            }
            String sindex = indexDelim >= 0 ? token.substring(indexDelim + 1, token.length()) : "0";
            int index = Integer.parseInt(sindex);
            int count = 0;
            AstNode foundLocal = null;
            for (AstNode child : found.children()) {
                String childName = child.name();
                if (child.type() != AstNode.NodeType.OPEN_TAG || !(caseInsensitive ? (childName = childName.toLowerCase(Locale.ENGLISH)) : childName).equals(nodeName) || count++ != index) continue;
                foundLocal = child;
                break;
            }
            if (foundLocal != null) {
                found = foundLocal;
                if (st.hasMoreTokens()) continue;
                assert (found.name().equals(nodeName));
                return found;
            }
            return null;
        }
        return null;
    }

    public static Collection<AstNode> getPossibleEndTagElements(AstNode leaf) {
        LinkedList<AstNode> possible = new LinkedList<AstNode>();
        while (leaf.type() != AstNode.NodeType.ROOT) {
            if (!(leaf.getDTDElement() != null && AstNodeUtils.hasForbiddenEndTag(leaf) || leaf.type() != AstNode.NodeType.OPEN_TAG)) {
                possible.add(leaf);
                if (leaf.needsToHaveMatchingTag() && leaf.getMatchingTag() == null) break;
            }
            leaf = leaf.parent();
            assert (leaf != null);
        }
        return possible;
    }

    public static Collection<DTD.Element> getPossibleOpenTagElements(AstNode node) {
        return AstNodeUtils.getPossibleOpenTagElements(node.getRootNode(), node.endOffset());
    }

    public static Collection<DTD.Element> getPossibleOpenTagElements(AstNode root, int astPosition) {
        HashSet<DTD.Element> elements = new HashSet<DTD.Element>();
        assert (root.type() == AstNode.NodeType.ROOT);
        AstNode leafNodeForPosition = AstNodeUtils.findNode(root, astPosition, false, false);
        if (leafNodeForPosition == null) {
            leafNodeForPosition = root;
        }
        if (leafNodeForPosition.logicalEndOffset == astPosition && leafNodeForPosition.parent() != null) {
            leafNodeForPosition = leafNodeForPosition.parent();
        }
        while (leafNodeForPosition.getDTDElement() == null && leafNodeForPosition.type() != AstNode.NodeType.ROOT) {
            leafNodeForPosition = leafNodeForPosition.parent();
        }
        assert (leafNodeForPosition != null);
        if (leafNodeForPosition == root) {
            return root.getAllPossibleElements();
        }
        if (leafNodeForPosition.startOffset() <= astPosition && leafNodeForPosition.endOffset() > astPosition) {
            return Collections.EMPTY_LIST;
        }
        assert (leafNodeForPosition.type() == AstNode.NodeType.OPEN_TAG);
        DTD.ContentModel contentModel = leafNodeForPosition.getDTDElement().getContentModel();
        DTD.Content content = contentModel.getContent();
        ArrayList<DTD.Element> childrenBefore = new ArrayList<DTD.Element>();
        for (AstNode sibling : leafNodeForPosition.children()) {
            DTD.Content subcontent;
            if (sibling.startOffset() >= astPosition) break;
            if (sibling.type() != AstNode.NodeType.OPEN_TAG || (subcontent = content.reduce(sibling.getDTDElement().getName())) == null || content == subcontent) continue;
            content = subcontent;
            childrenBefore.add(sibling.getDTDElement());
        }
        if (!leafNodeForPosition.needsToHaveMatchingTag() && leafNodeForPosition.parent().type() != AstNode.NodeType.ROOT) {
            Collection<DTD.Element> elementsBeforeLeaf = AstNodeUtils.getPossibleOpenTagElements(root, leafNodeForPosition.startOffset());
            elementsBeforeLeaf.removeAll(childrenBefore);
            elements.addAll(elementsBeforeLeaf);
        }
        AstNodeUtils.addAllPossibleElements(elements, content.getPossibleElements());
        ArrayList<AstNode> path = new ArrayList<AstNode>();
        AstNode node = leafNodeForPosition;
        while (node.type() != AstNode.NodeType.ROOT) {
            path.add(0, node);
            node = node.parent();
        }
        for (AstNode node2 : path) {
            DTD.ContentModel cModel = node2.getDTDElement().getContentModel();
            elements.addAll(cModel.getIncludes());
            elements.removeAll(cModel.getExcludes());
        }
        return elements;
    }

    private static void addAllPossibleElements(Set<DTD.Element> result, Collection<DTD.Element> elements) {
        for (DTD.Element element : elements) {
            result.add(element);
            if (!element.hasOptionalStart()) continue;
            AstNodeUtils.addAllPossibleElements(result, element.getContentModel().getContent().getPossibleElements());
        }
    }

    public static boolean hasForbiddenEndTag(AstNode node) {
        return node.getDTDElement() != null ? node.getDTDElement().isEmpty() : false;
    }

    public static void visitChildren(AstNode node, AstNodeVisitor visitor, AstNode.NodeType nodeType) {
        for (AstNode n : node.children()) {
            if (nodeType == null || n.type() == nodeType) {
                visitor.visit(n);
            }
            AstNodeUtils.visitChildren(n, visitor, nodeType);
        }
    }

    public static void visitChildren(AstNode node, AstNodeVisitor visitor) {
        AstNodeUtils.visitChildren(node, visitor, null);
    }

    public static void visitAncestors(AstNode node, AstNodeVisitor visitor) {
        AstNode parent = node.parent();
        if (parent != null) {
            visitor.visit(parent);
            AstNodeUtils.visitAncestors(parent, visitor);
        }
    }

    public static AstNode getClosestNodeBackward(AstNode context, int offset, AstNode.NodeFilter filter) {
        for (AstNode child : context.children(filter)) {
            if (child.startOffset >= offset) {
                return context;
            }
            context = AstNodeUtils.getClosestNodeBackward(child, offset, filter);
        }
        return context;
    }
}

