/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.dataprovider;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.perfan.dataprovider.SSStackDataProvider;
import org.netbeans.modules.dlight.perfan.impl.SunStudioDCConfigurationAccessor;
import org.netbeans.modules.dlight.spi.support.TableDataProvider;

final class SunStudioDataProvider
extends SSStackDataProvider
implements TableDataProvider,
FunctionsListDataProvider {
    private static final String cpuTableName = SunStudioDCConfigurationAccessor.getDefault().getCPUTableName();

    SunStudioDataProvider() {
    }

    public List<DataRow> queryData(DataTableMetadata tableMetadata) {
        List columns = tableMetadata.getColumns();
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (DataTableMetadata.Column c : columns) {
            columnNames.add(c.getColumnName());
        }
        List<FunctionCallTreeTableNode> nodes = super.getTableView(columns, null, Integer.MAX_VALUE);
        for (FunctionCallTreeTableNode node : nodes) {
            FunctionCallWithMetric call = node.getDeligator();
            ArrayList<Object> data = new ArrayList<Object>(columns.size());
            for (DataTableMetadata.Column c : columns) {
                if (c.getColumnName().equals("name")) {
                    data.add(call.getFunction().getName());
                    continue;
                }
                data.add(call.getMetricValue(c.getColumnName()));
            }
            result.add(new DataRow(columnNames, data));
        }
        return result;
    }

    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata metadata, FunctionDatatableDescription functionDecsr, List<DataTableMetadata.Column> metricsColumn) {
        ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
        if (!metricsColumn.contains(SunStudioDCConfiguration.c_name)) {
            List<DataTableMetadata.Column> oldMetrics = metricsColumn;
            metricsColumn = new ArrayList<DataTableMetadata.Column>();
            metricsColumn.addAll(oldMetrics);
            metricsColumn.add(SunStudioDCConfiguration.c_name);
        }
        if (metadata.getName().equals(cpuTableName)) {
            return super.getHotSpotFunctions(metricsColumn, metricsColumn, Integer.MAX_VALUE);
        }
        List<FunctionCallTreeTableNode> nodes = super.getTableView(metricsColumn, null, Integer.MAX_VALUE);
        for (FunctionCallTreeTableNode node : nodes) {
            FunctionCallWithMetric call = node.getDeligator();
            result.add(call);
        }
        return result;
    }

    public List<FunctionCallWithMetric> getDetailedFunctionsList(DataTableMetadata metadata, FunctionDatatableDescription functionDescription, List<DataTableMetadata.Column> metricsColumn) {
        ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
        if (!metricsColumn.contains(SunStudioDCConfiguration.c_name)) {
            List<DataTableMetadata.Column> oldMetrics = metricsColumn;
            metricsColumn = new ArrayList<DataTableMetadata.Column>();
            metricsColumn.addAll(oldMetrics);
            metricsColumn.add(SunStudioDCConfiguration.c_name);
        }
        List<FunctionCallTreeTableNode> nodes = super.getTableView(metricsColumn, null, Integer.MAX_VALUE);
        for (FunctionCallTreeTableNode node : nodes) {
            FunctionCallWithMetric call = node.getDeligator();
            result.add(call);
        }
        return result;
    }

    public boolean hasTheSameDetails(DataTableMetadata metadata, FunctionDatatableDescription functionDescription, List<DataTableMetadata.Column> metricsColumn) {
        return !metadata.getName().equals(cpuTableName);
    }
}

