/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.model.services;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.openide.util.Lookup;

public abstract class CsmReferenceStorage {
    private static final CsmReferenceStorage DEFAULT = new Default();

    protected CsmReferenceStorage() {
    }

    public static CsmReferenceStorage getDefault() {
        return DEFAULT;
    }

    public abstract boolean put(CsmReference var1, CsmObject var2);

    public abstract CsmReference get(CsmOffsetable var1);

    private static final class Default
    extends CsmReferenceStorage {
        private final Lookup.Result<CsmReferenceStorage> res = Lookup.getDefault().lookupResult(CsmReferenceStorage.class);
        private static final boolean FIX_SERVICE = true;
        private CsmReferenceStorage fixedStorage;

        Default() {
        }

        private CsmReferenceStorage getService() {
            CsmReferenceStorage service = this.fixedStorage;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    CsmReferenceStorage selector;
                    service = selector = (CsmReferenceStorage)i$.next();
                }
                if (service != null) {
                    this.fixedStorage = service;
                }
            }
            return service;
        }

        @Override
        public boolean put(CsmReference ref, CsmObject referencedObject) {
            CsmReferenceStorage storage = this.getService();
            if (storage != null) {
                return storage.put(ref, referencedObject);
            }
            return false;
        }

        @Override
        public CsmReference get(CsmOffsetable ref) {
            CsmReferenceStorage storage = this.getService();
            if (storage != null) {
                return storage.get(ref);
            }
            return null;
        }
    }
}

