/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.xml.cookies;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.parsers.SAXEntityParser;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.netbeans.spi.xml.cookies.ShareableInputSource;
import org.netbeans.spi.xml.cookies.Util;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class SharedXMLSupport {
    private static final Logger LOG = Logger.getLogger(SharedXMLSupport.class.getName());
    private CookieObserver console;
    private final InputSource inputSource;
    private final int mode;
    private Locator locator;
    private int fatalErrors;
    private int errors;
    private boolean bogusSchemaRequest;
    private boolean reportBogusSchemaRequest = Boolean.getBoolean("netbeans.xml.reportBogusSchemaLocation");

    public SharedXMLSupport(InputSource inputSource) {
        this(inputSource, 3);
    }

    public SharedXMLSupport(InputSource inputSource, int mode) {
        if (inputSource == null) {
            throw new NullPointerException();
        }
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException();
        }
        this.inputSource = inputSource;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkXML(CookieObserver l) {
        try {
            this.console = l;
            this.parse(false);
            boolean bl = this.fatalErrors == 0;
            return bl;
        }
        finally {
            this.console = null;
            this.locator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateXML(CookieObserver l) {
        try {
            this.console = l;
            if (this.mode != 3) {
                this.sendMessage(Util.THIS.getString("MSG_not_a_doc"));
                boolean bl = false;
                return bl;
            }
            this.parse(true);
            boolean bl = this.errors == 0 && this.fatalErrors == 0;
            return bl;
        }
        finally {
            this.console = null;
            this.locator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(boolean validate) {
        this.fatalErrors = 0;
        this.errors = 0;
        String checkedFile = this.inputSource.getSystemId();
        this.sendMessage(Util.THIS.getString("MSG_checking", checkedFile));
        Handler handler = new Handler();
        InputSource input = null;
        try {
            XMLReader parser = this.createParser(validate);
            if (parser == null) {
                ++this.fatalErrors;
                this.console.receive(new CookieMessage(Util.THIS.getString("MSG_cannot_create_parser"), 3));
                return;
            }
            if (validate) {
                input = ShareableInputSource.create(this.createInputSource());
                String[] schemaLocations = this.getSchemaLocations(input);
                try {
                    ((ShareableInputSource)input).reset();
                }
                catch (IOException e) {
                    input = this.createInputSource();
                }
                if (schemaLocations != null && schemaLocations.length > 0) {
                    boolean first = true;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < schemaLocations.length; ++i) {
                        sb.append(first ? schemaLocations[i] : " " + schemaLocations[i]);
                        first = false;
                    }
                    parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", sb.toString());
                }
            } else {
                input = this.createInputSource();
            }
            parser.setErrorHandler(handler);
            parser.setContentHandler(handler);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(checkedFile + ":" + this.parserDescription(parser));
            }
            if (this.mode == 1) {
                new SAXEntityParser(parser, true).parse(input);
            } else if (this.mode == 2) {
                new SAXEntityParser(parser, false).parse(input);
            } else {
                parser.parse(input);
            }
        }
        catch (SAXException ex) {
        }
        catch (FileStateInvalidException ex) {
            handler.fatalError(new SAXParseException(ex.getLocalizedMessage(), this.locator, (Exception)((Object)ex)));
        }
        catch (IOException ex) {
            handler.fatalError(new SAXParseException(ex.getLocalizedMessage(), this.locator, ex));
        }
        catch (RuntimeException ex) {
            handler.runtimeError(ex);
        }
        finally {
            if (input instanceof ShareableInputSource) {
                try {
                    ((ShareableInputSource)input).closeAll();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected EntityResolver createEntityResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        return catalog == null ? null : catalog.getEntityResolver();
    }

    protected InputSource createInputSource() throws IOException {
        return this.inputSource;
    }

    protected XMLReader createParser(boolean validate) {
        EntityResolver res;
        XMLReader ret = null;
        String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
        String XERCES_PROPERTY_PREFIX = "http://apache.org/xml/properties/";
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(validate);
        if (validate) {
            try {
                factory.setFeature("http://apache.org/xml/features/validation/schema", validate);
            }
            catch (Exception ex) {
                this.sendMessage(Util.THIS.getString("MSG_parser_no_schema"));
            }
        }
        try {
            SAXParser parser = factory.newSAXParser();
            ret = parser.getXMLReader();
        }
        catch (Exception ex) {
            this.sendMessage(Util.THIS.getString("MSG_parser_err_1"));
            return null;
        }
        if (ret != null && (res = this.createEntityResolver()) != null) {
            ret.setEntityResolver(new VerboseEntityResolver(res));
        }
        return ret;
    }

    private String parserDescription(XMLReader parser) {
        Class<?> klass = parser.getClass();
        try {
            ProtectionDomain domain = klass.getProtectionDomain();
            CodeSource source = domain.getCodeSource();
            if (source == null && (klass.getClassLoader() == null || klass.getClassLoader().equals(Object.class.getClassLoader()))) {
                return Util.THIS.getString("MSG_platform_parser");
            }
            if (source == null) {
                return Util.THIS.getString("MSG_unknown_parser", klass.getName());
            }
            URL location = source.getLocation();
            return Util.THIS.getString("MSG_parser_plug", location.toExternalForm());
        }
        catch (SecurityException ex) {
            return Util.THIS.getString("MSG_unknown_parser", klass.getName());
        }
    }

    private void sendMessage(String message) {
        if (this.console != null) {
            this.console.receive(new CookieMessage(message));
        }
    }

    private String[] getSchemaLocations(InputSource is) {
        EntityResolver res = this.createEntityResolver();
        if (res == null) {
            return null;
        }
        NsHandler nsHandler = this.getNamespaces(is);
        String[] namespaces = nsHandler.getNamespaces();
        ArrayList<String> loc = new ArrayList<String>();
        for (int i = 0; i < namespaces.length; ++i) {
            String ns = namespaces[i];
            if (nsHandler.mapping.containsKey(ns)) {
                loc.add(ns + " " + nsHandler.mapping.get(ns));
                continue;
            }
            try {
                Source src = ((URIResolver)((Object)res)).resolve(ns, null);
                if (src == null) continue;
                loc.add(ns + " " + src.getSystemId());
                continue;
            }
            catch (Exception x) {
                LOG.log(Level.INFO, "Could not load schema for " + ns, x);
            }
        }
        String[] schemaLocations = new String[loc.size()];
        loc.toArray(schemaLocations);
        return schemaLocations;
    }

    private NsHandler getNamespaces(InputSource is) {
        NsHandler handler = new NsHandler();
        try {
            EntityResolver resolver;
            XMLReader xmlReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xmlReader.setContentHandler(handler);
            UserCatalog userCatalog = UserCatalog.getDefault();
            if (userCatalog != null && (resolver = userCatalog.getEntityResolver()) != null) {
                xmlReader.setEntityResolver(resolver);
            }
            xmlReader.parse(is);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        catch (SAXException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        return handler;
    }

    private static class NsHandler
    extends DefaultHandler {
        Set namespaces = new HashSet();
        private Map mapping = new HashMap();

        NsHandler() {
        }

        public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
            StringTokenizer tokenizer;
            String locations;
            if (atts.getLength() > 0 && (locations = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")) != null && (tokenizer = new StringTokenizer(locations)).countTokens() % 2 == 0) {
                while (tokenizer.hasMoreElements()) {
                    String nsURI = tokenizer.nextToken();
                    String nsLocation = tokenizer.nextToken();
                    this.mapping.put(nsURI, nsLocation);
                }
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
                return;
            }
            this.namespaces.add(uri);
        }

        String[] getNamespaces() {
            String[] ns = new String[this.namespaces.size()];
            this.namespaces.toArray(ns);
            return ns;
        }
    }

    private class VerboseEntityResolver
    implements EntityResolver {
        private final EntityResolver peer;

        public VerboseEntityResolver(EntityResolver res) {
            if (res == null) {
                throw new NullPointerException();
            }
            this.peer = res;
        }

        public InputSource resolveEntity(String pid, String sid) throws SAXException, IOException {
            InputSource result = this.peer.resolveEntity(pid, sid);
            if (result == null) {
                String warning;
                SharedXMLSupport.this.bogusSchemaRequest = pid == null && sid == null;
                if (SharedXMLSupport.this.bogusSchemaRequest) {
                    return null;
                }
                String pidLabel = pid != null ? pid : Util.THIS.getString("MSG_no_pid");
                try {
                    String file = new URL(sid).getFile();
                    warning = file != null ? Util.THIS.getString("MSG_resolver_1", pidLabel, sid) : Util.THIS.getString("MSG_resolver_2", pidLabel, sid);
                }
                catch (MalformedURLException ex) {
                    warning = Util.THIS.getString("MSG_resolver_3", pidLabel, sid);
                }
                SharedXMLSupport.this.sendMessage(warning);
            }
            return result;
        }
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public void warning(SAXParseException ex) {
            String msg = ex.getLocalizedMessage();
            if (SharedXMLSupport.this.bogusSchemaRequest) {
                SharedXMLSupport.this.bogusSchemaRequest = false;
                if (msg != null && msg.indexOf("schema_reference.4") != -1) {
                    if (SharedXMLSupport.this.reportBogusSchemaRequest) {
                        SharedXMLSupport.this.reportBogusSchemaRequest = false;
                    } else {
                        return;
                    }
                }
            }
            CookieMessage message = new CookieMessage(msg, 1, new DefaultXMLProcessorDetail(ex));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(message);
            }
        }

        public void error(SAXParseException ex) throws SAXException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Just diagnostic exception", ex);
            }
            if (SharedXMLSupport.this.errors++ == this.getMaxErrorCount()) {
                String msg = Util.THIS.getString("MSG_too_many_errs");
                SharedXMLSupport.this.sendMessage(msg);
                throw ex;
            }
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 2, new DefaultXMLProcessorDetail(ex));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(message);
            }
        }

        private void runtimeError(RuntimeException ex) {
            Util.THIS.debug("Parser runtime exception", ex);
            String msg = Util.THIS.getString("EX_parser_ierr", ex.getMessage());
            this.fatalError(new SAXParseException(msg, SharedXMLSupport.this.locator, ex));
        }

        public void fatalError(SAXParseException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Just diagnostic exception", ex);
            }
            SharedXMLSupport.this.fatalErrors++;
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 3, new DefaultXMLProcessorDetail(ex));
            if (SharedXMLSupport.this.console != null) {
                SharedXMLSupport.this.console.receive(message);
            }
        }

        public void setDocumentLocator(Locator locator) {
            SharedXMLSupport.this.locator = locator;
        }

        private int getMaxErrorCount() {
            return 20;
        }
    }
}

