/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.ui.PopupUtil;
import org.openide.util.ImageUtilities;

public class OverridesPopup
extends JPanel
implements FocusListener {
    private JList list;
    private JScrollPane scrollPane;
    private final List<Item> elements;
    private final CsmOffsetableDeclaration mainDeclaration;
    private final boolean gotoDefinitions;

    public OverridesPopup(String caption, Collection<? extends CsmOffsetableDeclaration> baseDeclarations, Collection<? extends CsmOffsetableDeclaration> descendantDeclarations, Collection<? extends CsmOffsetableDeclaration> baseTemplates, Collection<? extends CsmOffsetableDeclaration> templateSpecializations) {
        this(caption, null, baseDeclarations, descendantDeclarations, baseTemplates, templateSpecializations, false);
    }

    public OverridesPopup(String caption, CsmOffsetableDeclaration mainDeclaration, Collection<? extends CsmOffsetableDeclaration> baseDeclarations, Collection<? extends CsmOffsetableDeclaration> descendantDeclarations, Collection<? extends CsmOffsetableDeclaration> baseTemplates, Collection<? extends CsmOffsetableDeclaration> templateSpecializations, boolean gotoDefinitions) {
        super(new BorderLayout());
        this.mainDeclaration = mainDeclaration;
        this.gotoDefinitions = gotoDefinitions;
        this.elements = new ArrayList<Item>();
        if (caption != null) {
            JLabel title = new JLabel(caption);
            title.setHorizontalAlignment(0);
            title.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.add((Component)title, "North");
        }
        this.list = new JList();
        this.scrollPane = new JScrollPane(this.list);
        this.add((Component)this.scrollPane, "Center");
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : baseDeclarations) {
            this.elements.add(new Item(csmOffsetableDeclaration, Kind.BASE));
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : baseTemplates) {
            this.elements.add(new Item(csmOffsetableDeclaration, Kind.BASE_TEMPLATE));
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : descendantDeclarations) {
            this.elements.add(new Item(csmOffsetableDeclaration, Kind.DESC));
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : templateSpecializations) {
            this.elements.add(new Item(csmOffsetableDeclaration, Kind.SPECIALIZATION));
        }
        Collections.sort(this.elements);
        DefaultListModel<Item> model = new DefaultListModel<Item>();
        if (this.mainDeclaration != null) {
            model.addElement(new Item(this.mainDeclaration, Kind.MAIN));
        }
        for (Item element : this.elements) {
            model.addElement(element);
        }
        this.list.setModel(model);
        this.list.setSelectedIndex(0);
        this.list.setCellRenderer(new RendererImpl());
        if (model.getSize() < 10) {
            this.list.setVisibleRowCount(model.getSize());
        }
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10 && evt.getModifiers() == 0) {
                    OverridesPopup.this.openSelected();
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 1) {
                    OverridesPopup.this.openSelected();
                }
            }
        });
        this.list.setCursor(Cursor.getPredefinedCursor(12));
        this.addFocusListener(this);
    }

    private void openSelected() {
        Item el = (Item)this.list.getSelectedValue();
        if (el != null) {
            CsmFunctionDefinition definition;
            CsmOffsetableDeclaration decl = el.declaration;
            if (this.gotoDefinitions && CsmKindUtilities.isFunctionDeclaration((CsmObject)decl) && (definition = ((CsmFunction)decl).getDefinition()) != null) {
                decl = definition;
            }
            CsmUtilities.openSource((CsmObject)decl);
        }
        PopupUtil.hidePopup();
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.list.requestFocus();
        this.list.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    private static class RendererImpl
    extends DefaultListCellRenderer {
        private RendererImpl() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Item) {
                return new RenderComponent((Item)value, isSelected, cellHasFocus, list);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class RenderComponent
    extends JLabel {
        private final Item item;
        private final boolean selected;
        private final boolean hasFocus;
        private final JList list;

        public RenderComponent(Item item, boolean selected, boolean hasFocus, JList list) {
            super(item.getDisplayName(), item.getIcon(), 2);
            this.item = item;
            this.selected = selected;
            this.list = list;
            this.hasFocus = hasFocus;
            this.setOpaque(true);
            if (selected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(true);
            this.setFont(list.getFont());
            Border border = null;
            border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                if (selected) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            }
            Border outer = item.kind == Kind.MAIN ? BorderFactory.createEmptyBorder(0, 6, 3, 6) : BorderFactory.createEmptyBorder(0, 6, 0, 6);
            border = BorderFactory.createCompoundBorder(border, outer);
            this.setBorder(border);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.item.kind == Kind.MAIN) {
                g.setColor(Color.gray);
                int h = this.getHeight();
                g.drawLine(0, h -= 2, this.getWidth(), h);
            }
        }
    }

    private static class Item
    implements Comparable<Item> {
        public final CsmOffsetableDeclaration declaration;
        public final Kind kind;

        public Item(CsmOffsetableDeclaration decl, Kind direction) {
            this.declaration = decl;
            this.kind = direction;
        }

        public String getDisplayName() {
            return ((Object)this.declaration.getQualifiedName()).toString();
        }

        private Image getBadge() {
            switch (this.kind) {
                case BASE: {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/modelutil/resources/overrides-badge.png");
                }
                case DESC: {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/modelutil/resources/is-overridden-badge.png");
                }
                case BASE_TEMPLATE: {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/modelutil/resources/base-template-badge.png");
                }
                case SPECIALIZATION: {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/modelutil/resources/specialization-badge.png");
                }
            }
            return null;
        }

        public Icon getIcon() {
            ImageIcon icon = CsmImageLoader.getIcon((CsmObject)this.declaration);
            Image badge = this.getBadge();
            if (badge == null) {
                BufferedImage img = new BufferedImage(8, 8, 2);
                Graphics2D g2d = img.createGraphics();
                Color transparent = new Color(0, 0, 0, 0);
                g2d.setColor(transparent);
                g2d.setComposite(AlphaComposite.Src);
                g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight()));
                badge = img;
            }
            return ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)icon.getImage(), (Image)badge, (int)16, (int)0));
        }

        public String toString() {
            return ((Object)this.declaration.getQualifiedName()).toString();
        }

        @Override
        public int compareTo(Item o) {
            if (o == null) {
                return -1;
            }
            if (o.kind == this.kind) {
                return ((Object)this.declaration.getQualifiedName()).toString().compareTo(((Object)o.declaration.getQualifiedName()).toString());
            }
            return this.kind == Kind.BASE ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (!(this.declaration == other.declaration || this.declaration != null && this.declaration.getQualifiedName().equals(other.declaration.getQualifiedName()))) {
                return false;
            }
            return this.kind == other.kind || this.kind != null && this.kind.equals((Object)other.kind);
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.declaration != null ? this.declaration.getQualifiedName().hashCode() : 0);
            hash = 97 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }
    }

    private static enum Kind {
        BASE,
        DESC,
        MAIN,
        BASE_TEMPLATE,
        SPECIALIZATION,
        MAIN_TEMPLATE;

    }
}

