/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MITList
extends MIValue
implements Iterable<MITListItem> {
    private final ArrayList<MITListItem> list = new ArrayList();
    private final boolean isList;
    private final boolean topLevel;
    private boolean sawResults;
    private boolean sawValues;

    MITList(boolean isList, boolean topLevel) {
        this.isList = isList;
        this.topLevel = topLevel;
    }

    @Override
    public String toString() {
        String s = new String();
        if (!this.topLevel) {
            s = s + (this.isList() ? "[" : "{");
        }
        for (int vx = 0; vx < this.list.size(); ++vx) {
            MITListItem item = this.list.get(vx);
            s = s + item.toString();
            if (vx + 1 >= this.list.size()) continue;
            s = s + ",";
        }
        if (!this.topLevel) {
            s = s + (this.isList() ? "]" : "}");
        }
        return s;
    }

    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isTList() {
        return true;
    }

    @Override
    public Iterator<MITListItem> iterator() {
        return this.list.iterator();
    }

    @Override
    public MITList asTList() {
        return this;
    }

    @Override
    public MITList asTuple() {
        return this;
    }

    @Override
    public MITList asList() {
        return this;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isValueList() {
        return this.sawValues;
    }

    public boolean isResultList() {
        return this.sawResults;
    }

    public MITListItem get(int x) {
        return this.list.get(x);
    }

    void add(MIResult result) {
        assert (!this.sawValues) : "Adding results to a value list";
        this.sawResults = true;
        this.list.add(result);
    }

    void add(MIValue value) {
        assert (!this.sawResults) : "Adding values to a result list";
        this.sawValues = true;
        this.list.add(value);
    }

    public MIValue valueOf(String variable) {
        assert (this.sawResults) : "Getting value from a result list";
        for (int vx = 0; vx < this.list.size(); ++vx) {
            MIResult result = (MIResult)this.list.get(vx);
            if (!result.matches(variable)) continue;
            return result.value();
        }
        return null;
    }
}

