/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanPanelVisual;
import org.openide.WizardDescriptor;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ManagedBeanPanel
implements WizardDescriptor.Panel,
WizardDescriptor.FinishablePanel,
ChangeListener {
    private TemplateWizard wizard;
    private ManagedBeanPanelVisual component;
    private String managedBeanClass;
    private Project project;
    private final Set listeners = new HashSet(1);

    public ManagedBeanPanel(Project project, TemplateWizard wizard) {
        this.project = project;
        this.wizard = wizard;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public Component getComponent() {
        if (this.component == null) {
            ManagedBeanPanelVisual gui = new ManagedBeanPanelVisual(this.project);
            gui.addChangeListener(this);
            this.component = gui;
        }
        return this.component;
    }

    public void updateManagedBeanName(WizardDescriptor.Panel panel) {
        String targetName = null;
        Component gui = panel.getComponent();
        try {
            Method getTargetName = gui.getClass().getMethod("getTargetName", null);
            targetName = (String)getTargetName.invoke((Object)gui, (Object[])null);
        }
        catch (Exception ex) {
            return;
        }
        if (targetName == null || targetName.trim().equals("")) {
            return;
        }
        if (this.managedBeanClass != null && targetName.equals(this.managedBeanClass.substring(0, 1).toUpperCase() + this.managedBeanClass.substring(1))) {
            return;
        }
        this.managedBeanClass = targetName.substring(0, 1).toLowerCase() + targetName.substring(1);
        this.getComponent();
        String name = this.component.getManagedBeanName();
        if (name == null || !name.equals(this.managedBeanClass)) {
            this.component.setManagedBeanName(this.managedBeanClass);
        }
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ManagedBeanPanel.class);
    }

    public boolean isValid() {
        this.getComponent();
        if (this.component.valid((WizardDescriptor)this.wizard)) {
            if (!Util.isValidServerInstance((Project)this.project)) {
                this.wizard.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ManagedBeanPanel.class, (String)"WARN_MissingTargetServer"));
            }
            return true;
        }
        return false;
    }

    public boolean isAddBeanToConfig() {
        if (this.component == null) {
            return false;
        }
        return this.component.isAddBeanToConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
        this.wizard = (TemplateWizard)settings;
        this.component.read((WizardDescriptor)this.wizard);
        Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
        if (substitute != null) {
            this.wizard.putProperty("NewProjectWizard_Title", substitute);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor d = (WizardDescriptor)settings;
        this.component.store(d);
        d.putProperty("NewProjectWizard_Title", null);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        this.isValid();
    }
}

