/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.components.JsfComponentDescriptor;
import org.netbeans.modules.web.jsf.api.components.JsfComponents;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JSFConfigurationPanelVisual
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(JSFConfigurationPanelVisual.class.getName());
    private static final String JSF_SERVLET_NAME = "Faces Servlet";
    private String jsfServletName = null;
    private JSFConfigurationPanel panel;
    private boolean customizer;
    private final List<LibraryItem> jsfLibraries = new ArrayList<LibraryItem>();
    private final Map<JSFVersion, List<JsfComponentDescriptor>> componentsMap = new HashMap<JSFVersion, List<JsfComponentDescriptor>>();
    private JSFVersion currentJSFVersion = null;
    private final Set<ServerLibraryItem> serverJsfLibraries = new TreeSet<ServerLibraryItem>();
    private volatile boolean libsInitialized;
    private volatile boolean jsfComponentsInitialized;
    private String serverInstanceID;
    private final List<String> preferredLanguages = new ArrayList<String>();
    private String currentServerInstanceID;
    private final List<String> excludeLibs = Arrays.asList("javaee-web-api-6.0", "javaee-api-6.0", "jsp-compilation");
    private boolean isWebLogicServer = false;
    private ButtonGroup buttonGroup1;
    private JComboBox cbJsfComponents;
    private JComboBox cbLibraries;
    private JCheckBox cbPackageJars;
    private JComboBox cbPreferredLang;
    private JPanel componentsPanel;
    private JPanel confPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton jbBrowse;
    private JTabbedPane jsfTabbedPane;
    private JTextField jtFolder;
    private JTextField jtNewLibraryName;
    private JLabel lDirectory;
    private JLabel lURLPattern;
    private JLabel lVersion;
    private JPanel libPanel;
    private JRadioButton rbNewLibrary;
    private JRadioButton rbRegisteredLibrary;
    private JRadioButton rbServerLibrary;
    private JComboBox serverLibraries;
    private JTextField tURLPattern;
    private static final char[] INVALID_PATTERN_CHARS = new char[]{'%', '+'};
    private static final Pattern VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");

    public JSFConfigurationPanelVisual(JSFConfigurationPanel panel, boolean customizer) {
        this.panel = panel;
        this.customizer = customizer;
        this.initComponents();
        this.tURLPattern.getDocument().addDocumentListener(this);
        this.cbPackageJars.setVisible(false);
        this.cbJsfComponents.setModel(new DefaultComboBoxModel<ComponentsLibraryItem>(new ComponentsLibraryItem[]{new ComponentsLibraryItem(null)}));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initLibraries();
        this.initJsfComponentsLibraries();
        if (this.customizer) {
            this.enableComponents(false);
        } else {
            this.updateLibrary();
        }
    }

    void initLibraries() {
        long time = System.currentTimeMillis();
        if (this.libsInitialized) {
            return;
        }
        this.initServerLibraries(false);
        final Vector registeredItems = new Vector();
        this.jsfLibraries.clear();
        Runnable libraryFinder = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    long time = System.currentTimeMillis();
                    for (Library library : LibraryManager.getDefault().getLibraries()) {
                        if (!"j2se".equals(library.getType())) continue;
                        if (library.getName().startsWith("facelets-") && !library.getName().endsWith("el-api") && !library.getName().endsWith("jsf-ri") && !library.getName().endsWith("myfaces")) {
                            String displayName = library.getDisplayName();
                            registeredItems.add(displayName);
                            JSFConfigurationPanelVisual.this.jsfLibraries.add(new LibraryItem(library, JSFVersion.JSF_1_2));
                        }
                        List content = library.getContent("classpath");
                        try {
                            if (!Util.containsClass((List)content, (String)"javax.faces.FacesException") || JSFConfigurationPanelVisual.this.excludeLibs.contains(library.getName())) continue;
                            registeredItems.add(library.getDisplayName());
                            boolean isJSF12 = Util.containsClass((List)content, (String)"javax.faces.application.StateManagerWrapper");
                            boolean isJSF20 = Util.containsClass((List)content, (String)"javax.faces.application.ProjectStage");
                            if (isJSF12 && !isJSF20) {
                                JSFConfigurationPanelVisual.this.jsfLibraries.add(new LibraryItem(library, JSFVersion.JSF_1_2));
                                continue;
                            }
                            if (isJSF20) {
                                JSFConfigurationPanelVisual.this.jsfLibraries.add(new LibraryItem(library, JSFVersion.JSF_2_0));
                                continue;
                            }
                            JSFConfigurationPanelVisual.this.jsfLibraries.add(new LibraryItem(library, JSFVersion.JSF_1_1));
                        }
                        catch (IOException exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                        }
                    }
                    ExtenderController.Properties properties = JSFConfigurationPanelVisual.this.panel.getController().getProperties();
                    Boolean isMaven = (Boolean)properties.getProperty("maven");
                    if (isMaven != null && isMaven.booleanValue()) {
                        JSFConfigurationPanelVisual.this.removeUserDefinedLibraries(registeredItems);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JSFConfigurationPanelVisual.this.setRegisteredLibraryModel(registeredItems);
                            JSFConfigurationPanelVisual.this.updatePreferredLanguages();
                            JSFConfigurationPanelVisual.this.updateJsfComponents();
                        }
                    });
                    LOG.finest("Time spent in initLibraries in Runnable = " + (System.currentTimeMillis() - time) + " ms");
                }
            }
        };
        RequestProcessor.getDefault().post(libraryFinder);
        this.libsInitialized = true;
        LOG.finest("Time spent in " + this.getClass().getName() + " initLibraries = " + (System.currentTimeMillis() - time) + " ms");
    }

    private void initJsfComponentsLibraries() {
        if (this.jsfComponentsInitialized) {
            return;
        }
        for (JsfComponentDescriptor jsfComponentDescriptor : JsfComponents.findJsfComponents()) {
            List<JsfComponentDescriptor> list = this.componentsMap.get((Object)jsfComponentDescriptor.getJsfVersion());
            if (list == null) {
                list = new ArrayList<JsfComponentDescriptor>();
            }
            list.add(jsfComponentDescriptor);
            this.componentsMap.put(jsfComponentDescriptor.getJsfVersion(), list);
        }
        this.jsfComponentsInitialized = true;
        if (this.currentJSFVersion != null) {
            this.updateJsfComponentsModel(this.currentJSFVersion);
        }
    }

    private void removeUserDefinedLibraries(Vector<String> registeredItems) {
        for (LibraryItem item : this.jsfLibraries) {
            if (!item.getLibrary().getContent("maven-pom").isEmpty()) continue;
            registeredItems.remove(item.getLibrary().getDisplayName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServerLibraries(boolean updateUI) {
        this.serverJsfLibraries.clear();
        JSFConfigurationPanelVisual jSFConfigurationPanelVisual = this;
        synchronized (jSFConfigurationPanelVisual) {
            if (JSFConfigurationPanelVisual.isServerRegistered(this.serverInstanceID)) {
                try {
                    ServerInstance.LibraryManager libManager = Deployment.getDefault().getServerInstance(this.serverInstanceID).getLibraryManager();
                    if (libManager != null) {
                        HashSet libs = new HashSet();
                        libs.addAll(libManager.getDeployedLibraries());
                        libs.addAll(libManager.getDeployableLibraries());
                        for (ServerLibrary lib : libs) {
                            if (!"JavaServer Faces".equals(lib.getSpecificationTitle())) continue;
                            if (Version.fromJsr277NotationWithFallback((String)"2.0").equals((Object)lib.getSpecificationVersion())) {
                                this.serverJsfLibraries.add(new ServerLibraryItem(lib, JSFVersion.JSF_2_0));
                                continue;
                            }
                            if (Version.fromJsr277NotationWithFallback((String)"1.2").equals((Object)lib.getSpecificationVersion())) {
                                this.serverJsfLibraries.add(new ServerLibraryItem(lib, JSFVersion.JSF_1_2));
                                continue;
                            }
                            if (Version.fromJsr277NotationWithFallback((String)"1.1").equals((Object)lib.getSpecificationVersion())) {
                                this.serverJsfLibraries.add(new ServerLibraryItem(lib, JSFVersion.JSF_1_1));
                                continue;
                            }
                            LOG.log(Level.INFO, "Unknown JSF version {0}", lib.getSpecificationVersion());
                        }
                    }
                }
                catch (InstanceRemovedException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
            if (this.serverJsfLibraries.isEmpty()) {
                J2eePlatform platform = null;
                try {
                    if (JSFConfigurationPanelVisual.isServerRegistered(this.serverInstanceID)) {
                        platform = Deployment.getDefault().getServerInstance(this.serverInstanceID).getJ2eePlatform();
                    }
                }
                catch (InstanceRemovedException ex) {
                    platform = null;
                    LOG.log(Level.INFO, NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"SERVER_INSTANCE_REMOVED"), ex);
                }
                File[] cp = platform != null ? platform.getClasspathEntries() : new File[]{};
                try {
                    boolean isJSF = Util.containsClass(Arrays.asList(cp), (String)"javax.faces.FacesException");
                    boolean isJSF12 = Util.containsClass(Arrays.asList(cp), (String)"javax.faces.application.StateManagerWrapper");
                    boolean isJSF20 = Util.containsClass(Arrays.asList(cp), (String)"javax.faces.application.ProjectStage");
                    JSFVersion jsfVersion = null;
                    if (isJSF20) {
                        jsfVersion = JSFVersion.JSF_2_0;
                    } else if (isJSF12) {
                        jsfVersion = JSFVersion.JSF_1_2;
                    } else if (isJSF) {
                        jsfVersion = JSFVersion.JSF_1_1;
                    }
                    if (jsfVersion != null) {
                        this.serverJsfLibraries.add(new ServerLibraryItem(null, jsfVersion));
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.setServerLibraryModel(this.serverJsfLibraries);
            if (updateUI) {
                this.updatePreferredLanguages();
            }
        }
    }

    private static boolean isServerRegistered(String serverInstanceID) {
        return serverInstanceID != null && !"".equals(serverInstanceID) && !"DEV-NULL".equals(serverInstanceID);
    }

    private void setRegisteredLibraryModel(Vector<String> items) {
        long time = System.currentTimeMillis();
        this.cbLibraries.setModel(new DefaultComboBoxModel<String>(items));
        if (items.size() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
            this.cbLibraries.setEnabled(false);
            this.rbNewLibrary.setSelected(true);
            this.panel.setLibrary(null);
        } else if (items.size() != 0 && this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.USED) {
            if (!this.customizer) {
                this.rbRegisteredLibrary.setEnabled(true);
                this.cbLibraries.setEnabled(true);
            }
            this.rbRegisteredLibrary.setSelected(true);
            if (this.jsfLibraries.size() > 0) {
                this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
                this.setJsfVersion(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion());
            }
        }
        this.repaint();
        LOG.finest("Time spent in " + this.getClass().getName() + " setLibraryModel = " + (System.currentTimeMillis() - time) + " ms");
    }

    private void setServerLibraryModel(Collection<ServerLibraryItem> items) {
        this.serverLibraries.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        if (items.isEmpty()) {
            this.rbServerLibrary.setEnabled(false);
            this.serverLibraries.setEnabled(false);
            this.rbRegisteredLibrary.setSelected(true);
            this.panel.setServerLibrary(null);
        } else if (!items.isEmpty() && this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.SERVER) {
            ServerLibraryItem item;
            if (!this.customizer) {
                this.rbServerLibrary.setEnabled(true);
                this.serverLibraries.setEnabled(true);
            }
            this.rbServerLibrary.setSelected(true);
            if (!this.serverJsfLibraries.isEmpty() && (item = (ServerLibraryItem)this.serverLibraries.getSelectedItem()) != null) {
                this.panel.setServerLibrary(item.getLibrary());
                this.setJsfVersion(item.getVersion());
            }
        }
        this.repaint();
    }

    private void updatePreferredLanguages() {
        ServerLibraryItem item;
        boolean faceletsPresent = false;
        Library jsfLibrary = null;
        if (this.panel.getLibraryType() == null) {
            return;
        }
        if (this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.USED) {
            if (!this.libsInitialized) {
                this.initLibraries();
            }
            jsfLibrary = this.panel.getLibrary();
        } else if (this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.NEW) {
            if (this.panel.getNewLibraryName() != null) {
                jsfLibrary = LibraryManager.getDefault().getLibrary(this.panel.getNewLibraryName());
            }
        } else if (this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.SERVER && (item = (ServerLibraryItem)this.serverLibraries.getSelectedItem()) != null && item.getVersion() == JSFVersion.JSF_2_0) {
            faceletsPresent = true;
        }
        if (jsfLibrary != null) {
            if (this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion() == JSFVersion.JSF_2_0) {
                faceletsPresent = true;
            } else {
                List content = jsfLibrary.getContent("classpath");
                try {
                    faceletsPresent = Util.containsClass((List)content, (String)"com.sun.facelets.Facelet") || Util.containsClass((List)content, (String)"com.sun.faces.facelets.Facelet");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.preferredLanguages.clear();
        this.preferredLanguages.add(JSFConfigurationPanel.PreferredLanguage.JSP.getName());
        if (faceletsPresent) {
            if (!this.customizer) {
                this.panel.setEnableFacelets(true);
            }
            if (this.panel.isEnableFacelets()) {
                this.preferredLanguages.add(0, JSFConfigurationPanel.PreferredLanguage.Facelets.getName());
            } else {
                this.preferredLanguages.add(JSFConfigurationPanel.PreferredLanguage.Facelets.getName());
            }
        } else {
            this.panel.setEnableFacelets(false);
        }
        this.cbPreferredLang.setModel(new DefaultComboBoxModel<Object>(this.preferredLanguages.toArray()));
        this.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jsfTabbedPane = new JTabbedPane();
        this.libPanel = new JPanel();
        this.rbServerLibrary = new JRadioButton();
        this.rbRegisteredLibrary = new JRadioButton();
        this.cbLibraries = new JComboBox();
        this.rbNewLibrary = new JRadioButton();
        this.lDirectory = new JLabel();
        this.jtFolder = new JTextField();
        this.jbBrowse = new JButton();
        this.lVersion = new JLabel();
        this.jtNewLibraryName = new JTextField();
        this.serverLibraries = new JComboBox();
        this.cbPackageJars = new JCheckBox();
        this.confPanel = new JPanel();
        this.lURLPattern = new JLabel();
        this.tURLPattern = new JTextField();
        this.cbPreferredLang = new JComboBox();
        this.jLabel1 = new JLabel();
        this.componentsPanel = new JPanel();
        this.cbJsfComponents = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setLayout(new CardLayout());
        this.jsfTabbedPane.setMinimumSize(new Dimension(106, 62));
        this.jsfTabbedPane.setPreferredSize(new Dimension(483, 210));
        this.libPanel.setAlignmentX(0.2f);
        this.libPanel.setAlignmentY(0.2f);
        this.buttonGroup1.add(this.rbServerLibrary);
        this.rbServerLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbNoAppend").charAt(0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.rbServerLibrary.setText(bundle.getString("LBL_Any_Library"));
        this.rbServerLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFConfigurationPanelVisual.this.rbServerLibraryItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rbRegisteredLibrary);
        this.rbRegisteredLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbRegLibs").charAt(0));
        this.rbRegisteredLibrary.setSelected(true);
        this.rbRegisteredLibrary.setText(bundle.getString("LBL_REGISTERED_LIBRARIES"));
        this.rbRegisteredLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFConfigurationPanelVisual.this.rbRegisteredLibraryItemStateChanged(evt);
            }
        });
        this.cbLibraries.setModel(new DefaultComboBoxModel<String>(new String[]{"Search Libraries..."}));
        this.cbLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.cbLibrariesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbNewLibrary);
        this.rbNewLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbCrNewLib").charAt(0));
        this.rbNewLibrary.setText(bundle.getString("LBL_CREATE_NEW_LIBRARY"));
        this.rbNewLibrary.setToolTipText(bundle.getString("MSG_CreatingLibraries"));
        this.rbNewLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFConfigurationPanelVisual.this.rbNewLibraryItemStateChanged(evt);
            }
        });
        this.lDirectory.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lJSFDir").charAt(0));
        this.lDirectory.setLabelFor(this.jtFolder);
        this.lDirectory.setText(bundle.getString("LBL_INSTALL_DIR"));
        this.lDirectory.setToolTipText(bundle.getString("HINT_JSF_Directory"));
        this.jtFolder.setToolTipText(bundle.getString("HINT_JSF_Directory"));
        this.jtFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSFConfigurationPanelVisual.this.jtFolderKeyPressed(evt);
            }
        });
        this.jbBrowse.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Browse").charAt(0));
        this.jbBrowse.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_Browse"));
        this.jbBrowse.setToolTipText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"HINT_JSF_BROWSE_BTN"));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.jbBrowseActionPerformed(evt);
            }
        });
        this.lVersion.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lJSFVer").charAt(0));
        this.lVersion.setLabelFor(this.jtNewLibraryName);
        this.lVersion.setText(bundle.getString("LBL_VERSION"));
        this.lVersion.setToolTipText(bundle.getString("HINT_Version"));
        this.jtNewLibraryName.setToolTipText(bundle.getString("HINT_Version"));
        this.jtNewLibraryName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JSFConfigurationPanelVisual.this.jtNewLibraryNameKeyReleased(evt);
            }
        });
        this.serverLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.serverLibrariesActionPerformed(evt);
            }
        });
        this.cbPackageJars.setSelected(true);
        this.cbPackageJars.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Package_JARs"));
        GroupLayout libPanelLayout = new GroupLayout((Container)this.libPanel);
        this.libPanel.setLayout((LayoutManager)libPanelLayout);
        libPanelLayout.setHorizontalGroup((GroupLayout.Group)libPanelLayout.createParallelGroup(1).add((GroupLayout.Group)libPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)libPanelLayout.createParallelGroup(1).add(2, (Component)this.rbNewLibrary, -1, 471, Short.MAX_VALUE).add((GroupLayout.Group)libPanelLayout.createSequentialGroup().add(22, 22, 22).add((GroupLayout.Group)libPanelLayout.createParallelGroup(1).add((Component)this.cbPackageJars).add((Component)this.lVersion).add((Component)this.lDirectory)).addPreferredGap(0, 206, Short.MAX_VALUE)).add((GroupLayout.Group)libPanelLayout.createSequentialGroup().add((GroupLayout.Group)libPanelLayout.createParallelGroup(2, false).add(1, (Component)this.rbServerLibrary, -1, -1, Short.MAX_VALUE).add(1, (Component)this.rbRegisteredLibrary, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)libPanelLayout.createParallelGroup(1).add((Component)this.cbLibraries, 0, 290, Short.MAX_VALUE).add(2, (GroupLayout.Group)libPanelLayout.createSequentialGroup().add((GroupLayout.Group)libPanelLayout.createParallelGroup(2).add((Component)this.jtNewLibraryName, -1, 206, Short.MAX_VALUE).add((Component)this.jtFolder, -1, 206, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jbBrowse)).add((Component)this.serverLibraries, 0, 290, Short.MAX_VALUE)))).addContainerGap()));
        libPanelLayout.setVerticalGroup((GroupLayout.Group)libPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)libPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)libPanelLayout.createParallelGroup(3).add((Component)this.rbServerLibrary).add((Component)this.serverLibraries, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)libPanelLayout.createParallelGroup(3).add((Component)this.rbRegisteredLibrary).add((Component)this.cbLibraries, -2, -1, -2)).addPreferredGap(0).add((Component)this.rbNewLibrary).add((GroupLayout.Group)libPanelLayout.createParallelGroup(3).add((Component)this.jbBrowse).add((Component)this.jtFolder, -2, -1, -2).add((Component)this.lDirectory)).add((GroupLayout.Group)libPanelLayout.createParallelGroup(3).add((Component)this.jtNewLibraryName, -2, -1, -2).add((Component)this.lVersion)).addPreferredGap(0).add((Component)this.cbPackageJars).addContainerGap(-1, Short.MAX_VALUE)));
        this.cbPackageJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_PackageJarToWar"));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Libraries"), this.libPanel);
        this.lURLPattern.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lURLPattern").charAt(0));
        this.lURLPattern.setLabelFor(this.tURLPattern);
        this.lURLPattern.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_URL_Pattern"));
        this.tURLPattern.setText(this.panel.getFacesMapping());
        this.cbPreferredLang.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbPreferredLang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.cbPreferredLangActionPerformed(evt);
            }
        });
        this.jLabel1.setLabelFor(this.cbPreferredLang);
        this.jLabel1.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_PREFERRED_LANGUAGE"));
        GroupLayout confPanelLayout = new GroupLayout((Container)this.confPanel);
        this.confPanel.setLayout((LayoutManager)confPanelLayout);
        confPanelLayout.setHorizontalGroup((GroupLayout.Group)confPanelLayout.createParallelGroup(1).add((GroupLayout.Group)confPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)confPanelLayout.createParallelGroup(1).add((GroupLayout.Group)confPanelLayout.createSequentialGroup().add((Component)this.lURLPattern).addPreferredGap(0).add((Component)this.tURLPattern, -1, 278, Short.MAX_VALUE)).add((GroupLayout.Group)confPanelLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.cbPreferredLang, -2, -1, -2))).addContainerGap()));
        confPanelLayout.setVerticalGroup((GroupLayout.Group)confPanelLayout.createParallelGroup(1).add((GroupLayout.Group)confPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)confPanelLayout.createParallelGroup(3).add((Component)this.lURLPattern).add((Component)this.tURLPattern, -2, -1, -2)).add(33, 33, 33).add((GroupLayout.Group)confPanelLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cbPreferredLang, -2, -1, -2)).add(98, 98, 98)));
        this.tURLPattern.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_Mapping"));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Configuration"), this.confPanel);
        this.cbJsfComponents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.cbJsfComponentsActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.cbJsfComponents);
        this.jLabel2.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_JSF_Components"));
        this.jLabel3.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_JSF_Components_Desc"));
        GroupLayout componentsPanelLayout = new GroupLayout((Container)this.componentsPanel);
        this.componentsPanel.setLayout((LayoutManager)componentsPanelLayout);
        componentsPanelLayout.setHorizontalGroup((GroupLayout.Group)componentsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)componentsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)componentsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)componentsPanelLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.cbJsfComponents, -2, -1, -2)).add((Component)this.jLabel3)).addContainerGap(-1, Short.MAX_VALUE)));
        componentsPanelLayout.setVerticalGroup((GroupLayout.Group)componentsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)componentsPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(1).add((GroupLayout.Group)componentsPanelLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.cbJsfComponents, -2, -1, -2)).addContainerGap(107, Short.MAX_VALUE)));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Components"), this.componentsPanel);
        this.add((Component)this.jsfTabbedPane, "card10");
        this.jsfTabbedPane.getAccessibleContext().setAccessibleName("");
    }

    private void rbServerLibraryItemStateChanged(ItemEvent evt) {
        this.updateLibrary();
        if (this.rbServerLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void jtNewLibraryNameKeyReleased(KeyEvent evt) {
        this.panel.setNewLibraryName(this.jtNewLibraryName.getText().trim());
    }

    private void rbNewLibraryItemStateChanged(ItemEvent evt) {
        this.updateLibrary();
        if (this.rbNewLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void cbLibrariesActionPerformed(ActionEvent evt) {
        this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
        this.setJsfVersion(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion());
        this.updatePreferredLanguages();
    }

    private void rbRegisteredLibraryItemStateChanged(ItemEvent evt) {
        this.updateLibrary();
        if (this.rbRegisteredLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void jbBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_SelectLibraryLocation"));
        chooser.setFileSelectionMode(1);
        chooser.setCurrentDirectory(new File(this.jtFolder.getText().trim()));
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.jtFolder.setText(projectDir.getAbsolutePath());
            this.setNewLibraryFolder();
        }
    }

    private void jtFolderKeyPressed(KeyEvent evt) {
        this.setNewLibraryFolder();
    }

    private void cbPreferredLangActionPerformed(ActionEvent evt) {
        if (this.preferredLanguages.get(this.cbPreferredLang.getSelectedIndex()).equals("Facelets")) {
            this.panel.setEnableFacelets(true);
        } else {
            this.panel.setEnableFacelets(false);
        }
    }

    private void serverLibrariesActionPerformed(ActionEvent evt) {
        ServerLibraryItem item = (ServerLibraryItem)this.serverLibraries.getSelectedItem();
        if (item != null) {
            this.panel.setServerLibrary(item.getLibrary());
        }
        this.updatePreferredLanguages();
    }

    private void cbJsfComponentsActionPerformed(ActionEvent evt) {
        this.panel.setJsfComponentDescriptor(((ComponentsLibraryItem)this.cbJsfComponents.getSelectedItem()).getJsfComponentDescriptor());
    }

    void enableComponents(boolean enable) {
        int i;
        Component[] components = this.confPanel.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(enable);
        }
        this.cbPreferredLang.setEnabled(true);
        this.jLabel1.setEnabled(true);
        components = this.libPanel.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(enable);
        }
    }

    boolean valid() {
        ExtenderController controller = this.panel.getController();
        String urlPattern = this.tURLPattern.getText();
        if (urlPattern == null || urlPattern.trim().equals("")) {
            controller.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsEmpty"));
            return false;
        }
        if (!this.isPatternValid(urlPattern)) {
            controller.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsNotValid"));
            return false;
        }
        if (this.customizer) {
            return true;
        }
        if (controller.getProperties().getProperty("NoDocBase") != null) {
            controller.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_MissingDocBase"));
            return false;
        }
        controller.getProperties().setProperty("WizardPanel_infoMessage", null);
        if (this.rbRegisteredLibrary.isSelected() && (this.jsfLibraries == null || this.jsfLibraries.size() == 0)) {
            controller.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_MissingJSF"));
            return false;
        }
        if (this.rbNewLibrary.isSelected()) {
            String folder = this.jtFolder.getText().trim();
            String message = JSFUtils.isJSFInstallFolder(new File(folder), JSFVersion.JSF_2_0);
            if ("".equals(folder)) {
                ExtenderController.Properties properties = controller.getProperties();
                controller.setErrorMessage(null);
                properties.setProperty("WizardPanel_infoMessage", (Object)message);
                return false;
            }
            if (message != null) {
                controller.setErrorMessage(message);
                return false;
            }
            String newLibraryName = this.jtNewLibraryName.getText().trim();
            if (newLibraryName.length() <= 0) {
                controller.setErrorMessage(null);
                controller.getProperties().setProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_EmptyNewLibraryName"));
                return false;
            }
            message = this.checkLibraryName(newLibraryName);
            if (message != null) {
                controller.setErrorMessage(message);
                return false;
            }
            Library lib = LibraryManager.getDefault().getLibrary(newLibraryName);
            if (lib != null) {
                controller.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_AlreadyExists"));
                return false;
            }
        }
        if (!JSFConfigurationPanelVisual.isServerRegistered(this.serverInstanceID)) {
            controller.getProperties().setProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ERR_MissingTargetServer"));
        }
        controller.setErrorMessage(null);
        return true;
    }

    private boolean isPatternValid(String pattern) {
        String p;
        for (char c : INVALID_PATTERN_CHARS) {
            if (pattern.indexOf(c) == -1) continue;
            return false;
        }
        if (pattern.startsWith("*.") && (p = pattern.substring(2)).indexOf(46) == -1 && p.indexOf(42) == -1 && p.indexOf(47) == -1 && !p.trim().equals("")) {
            return true;
        }
        return pattern.length() > 3 && pattern.endsWith("/*") && pattern.startsWith("/");
    }

    private boolean isWebLogic(String serverInstanceID) {
        if (!JSFConfigurationPanelVisual.isServerRegistered(serverInstanceID)) {
            return false;
        }
        try {
            String shortName = Deployment.getDefault().getServerInstance(serverInstanceID).getServerID();
            if (shortName != null && shortName.toLowerCase().startsWith("weblogic")) {
                return true;
            }
        }
        catch (InstanceRemovedException ex) {
            LOG.log(Level.INFO, "Server Instance was removed", ex);
        }
        return false;
    }

    void update() {
        ExtenderController.Properties properties = this.panel.getController().getProperties();
        String j2eeLevel = (String)properties.getProperty("j2eeLevel");
        Profile prof = j2eeLevel == null ? Profile.JAVA_EE_6_FULL : Profile.fromPropertiesString((String)j2eeLevel);
        this.serverInstanceID = (String)properties.getProperty("serverInstanceID");
        Boolean isMaven = (Boolean)properties.getProperty("maven");
        if (isMaven != null && isMaven.booleanValue()) {
            this.setNewLibraryOptionVisible(false);
            if (!JSFConfigurationPanelVisual.isServerRegistered(this.serverInstanceID)) {
                this.cbPackageJars.setVisible(true);
            }
        }
        this.initLibSettings(prof, this.serverInstanceID);
    }

    private void initLibSettings(Profile profile, String serverInstanceID) {
        boolean serverChanged = this.isServerInstanceChanged();
        if (serverChanged) {
            this.initServerLibraries(true);
        }
        if (this.panel == null || this.panel.getLibraryType() == null || serverChanged) {
            if (this.serverJsfLibraries.isEmpty()) {
                this.rbServerLibrary.setVisible(false);
                this.serverLibraries.setVisible(false);
                Library preferredLibrary = null;
                preferredLibrary = profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB) || profile.equals(Profile.JAVA_EE_5) ? LibraryManager.getDefault().getLibrary(JSFUtils.DEFAULT_JSF_2_0_NAME) : LibraryManager.getDefault().getLibrary(JSFUtils.DEFAULT_JSF_1_2_NAME);
                if (preferredLibrary != null) {
                    this.rbRegisteredLibrary.setSelected(true);
                    this.cbLibraries.setSelectedItem(preferredLibrary.getDisplayName());
                    this.updateLibrary();
                } else if (this.jsfLibraries.isEmpty()) {
                    this.rbNewLibrary.setSelected(true);
                }
            } else {
                if (!this.rbServerLibrary.isVisible()) {
                    this.rbServerLibrary.setVisible(true);
                    this.serverLibraries.setVisible(true);
                    this.repaint();
                }
                this.rbServerLibrary.setSelected(true);
                if (this.panel != null) {
                    this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.SERVER);
                }
                this.enableNewLibraryComponent(false);
                this.enableDefinedLibraryComponent(false);
                this.isWebLogicServer = this.isWebLogic(serverInstanceID);
            }
        } else {
            switch (this.panel.getLibraryType()) {
                case NEW: {
                    this.rbNewLibrary.setSelected(true);
                    break;
                }
                case USED: {
                    this.rbRegisteredLibrary.setSelected(true);
                    break;
                }
                case SERVER: {
                    this.rbServerLibrary.setSelected(true);
                    this.enableDefinedLibraryComponent(false);
                    this.enableNewLibraryComponent(false);
                }
            }
        }
    }

    void setJsfVersion(JSFVersion version) {
        if (version != this.currentJSFVersion) {
            this.currentJSFVersion = version;
            this.updateJsfComponentsModel(version);
        }
    }

    private boolean isServerInstanceChanged() {
        if (this.serverInstanceID == null && this.currentServerInstanceID != null || this.serverInstanceID != null && !this.serverInstanceID.equals(this.currentServerInstanceID)) {
            this.currentServerInstanceID = this.serverInstanceID;
            return true;
        }
        return false;
    }

    private void setNewLibraryOptionVisible(boolean visible) {
        this.rbNewLibrary.setVisible(visible);
        this.lDirectory.setVisible(visible);
        this.lVersion.setVisible(visible);
        this.jtFolder.setVisible(visible);
        this.jbBrowse.setVisible(visible);
        this.jtNewLibraryName.setVisible(visible);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSFConfigurationPanelVisual.class);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    public String getServletName() {
        return this.jsfServletName == null ? JSF_SERVLET_NAME : this.jsfServletName;
    }

    protected void setServletName(String name) {
        this.jsfServletName = name;
    }

    public String getURLPattern() {
        return this.tURLPattern.getText();
    }

    protected void setURLPattern(String pattern) {
        this.tURLPattern.setText(pattern);
    }

    public boolean packageJars() {
        return this.cbPackageJars.isSelected();
    }

    protected String getPreferredLanguage() {
        return (String)this.cbPreferredLang.getSelectedItem();
    }

    private void updateLibrary() {
        if (this.cbLibraries.getItemCount() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
        }
        if (this.rbServerLibrary.isSelected()) {
            ServerLibraryItem item;
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(false);
            this.enableServerLibraryComponent(true);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.SERVER);
            if (!this.serverJsfLibraries.isEmpty() && (item = (ServerLibraryItem)this.serverLibraries.getSelectedItem()) != null) {
                this.panel.setServerLibrary(item.getLibrary());
                this.setJsfVersion(item.getVersion());
            }
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbRegisteredLibrary.isSelected()) {
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(true);
            this.enableServerLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.USED);
            if (this.jsfLibraries.size() > 0) {
                this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
                this.panel.setServerLibrary(null);
                this.setJsfVersion(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion());
            }
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbNewLibrary.isSelected()) {
            this.enableNewLibraryComponent(true);
            this.enableDefinedLibraryComponent(false);
            this.enableServerLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.NEW);
            this.panel.setServerLibrary(null);
            this.setNewLibraryFolder();
        }
        this.updatePreferredLanguages();
    }

    private void updateJsfComponentsModel(JSFVersion version) {
        ArrayList<ComponentsLibraryItem> componentsList = new ArrayList<ComponentsLibraryItem>();
        componentsList.add(new ComponentsLibraryItem(null));
        List<JsfComponentDescriptor> providers = this.componentsMap.get((Object)version);
        if (providers != null) {
            for (JsfComponentDescriptor provider : providers) {
                componentsList.add(new ComponentsLibraryItem(provider));
            }
        }
        this.cbJsfComponents.setModel(new DefaultComboBoxModel<ComponentsLibraryItem>(componentsList.toArray(new ComponentsLibraryItem[componentsList.size()])));
    }

    private void updateJsfComponents() {
        this.panel.setJsfComponentDescriptor(((ComponentsLibraryItem)this.cbJsfComponents.getSelectedItem()).getJsfComponentDescriptor());
    }

    private void enableDefinedLibraryComponent(boolean enabled) {
        this.cbLibraries.setEnabled(enabled);
    }

    private void enableServerLibraryComponent(boolean enabled) {
        this.serverLibraries.setEnabled(enabled);
    }

    private void enableNewLibraryComponent(boolean enabled) {
        this.lDirectory.setEnabled(enabled);
        this.jtFolder.setEnabled(enabled);
        this.jbBrowse.setEnabled(enabled);
        this.lVersion.setEnabled(enabled);
        this.jtNewLibraryName.setEnabled(enabled);
    }

    private void setNewLibraryFolder() {
        String fileName = this.jtFolder.getText();
        if (fileName == null || "".equals(fileName)) {
            this.panel.setInstallFolder(null);
        } else {
            File folder = new File(fileName);
            this.panel.setInstallFolder(folder);
        }
    }

    private String checkLibraryName(String name) {
        String message = null;
        if (name.length() == 0) {
            message = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_InvalidLibraryName");
        } else if (!VALID_PROPERTY_NAME.matcher(name).matches()) {
            message = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_InvalidLibraryNameCharacters");
        }
        return message;
    }

    private static class ComponentsLibraryItem {
        private JsfComponentDescriptor jsfComponentsProvider;
        private String defaultName = "None";

        public ComponentsLibraryItem(JsfComponentDescriptor jsfComponentsProvider) {
            this.jsfComponentsProvider = jsfComponentsProvider;
        }

        public JsfComponentDescriptor getJsfComponentDescriptor() {
            return this.jsfComponentsProvider;
        }

        public Library getLibrary() {
            return this.jsfComponentsProvider != null ? this.jsfComponentsProvider.getLibrary() : null;
        }

        public String getName() {
            return this.jsfComponentsProvider != null ? this.jsfComponentsProvider.getName() : this.defaultName;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class ServerLibraryItem
    implements Comparable<ServerLibraryItem> {
        private final ServerLibrary library;
        private final JSFVersion version;
        private String name;

        public ServerLibraryItem(ServerLibrary library, JSFVersion version) {
            this.library = library;
            this.version = version;
        }

        public ServerLibrary getLibrary() {
            return this.library;
        }

        public JSFVersion getVersion() {
            return this.version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            ServerLibraryItem serverLibraryItem = this;
            synchronized (serverLibraryItem) {
                if (this.name != null) {
                    return this.name;
                }
            }
            StringBuilder sb = new StringBuilder();
            switch (this.version) {
                case JSF_1_0: {
                    sb.append("JSF 1.0");
                    break;
                }
                case JSF_1_1: {
                    sb.append("JSF 1.1");
                    break;
                }
                case JSF_1_2: {
                    sb.append("JSF 1.2");
                    break;
                }
                case JSF_2_0: {
                    sb.append("JSF 2.0");
                }
            }
            if (this.library != null && (this.library.getImplementationTitle() != null || this.library.getImplementationVersion() != null)) {
                sb.append(" ");
                sb.append("[");
                if (this.library.getImplementationTitle() != null) {
                    sb.append(this.library.getImplementationTitle());
                }
                if (this.library.getImplementationVersion() != null) {
                    if (this.library.getImplementationTitle() != null) {
                        sb.append(" - ");
                    }
                    sb.append(this.library.getImplementationVersion().toString());
                }
                sb.append("]");
            }
            ServerLibraryItem serverLibraryItem2 = this;
            synchronized (serverLibraryItem2) {
                this.name = sb.toString();
                return this.name;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerLibraryItem other = (ServerLibraryItem)obj;
            return !(this.toString() == null ? other.toString() != null : !this.toString().equals(other.toString()));
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.toString() != null ? this.toString().hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(ServerLibraryItem o) {
            return -this.toString().compareTo(o.toString());
        }
    }

    private static class LibraryItem {
        private Library library;
        private JSFVersion version;

        public LibraryItem(Library library, JSFVersion version) {
            this.library = library;
            this.version = version;
        }

        public Library getLibrary() {
            return this.library;
        }

        public JSFVersion getVersion() {
            return this.version;
        }

        public String toString() {
            return this.library.getDisplayName();
        }
    }
}

