/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.api.facesmodel.Converter;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigComponent;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelFactory;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

public class Occurrences {
    private static final Logger LOGGER = Logger.getLogger(Occurrences.class.getName());

    public static List<OccurrenceItem> getAllOccurrences(WebModule webModule, final String oldName, final String newName) {
        final ArrayList<OccurrenceItem> result = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (oldName != null);
        LOGGER.fine("getAllOccurences(" + webModule.getDocumentBase() + ", " + oldName + ", " + newName + ")");
        if (webModule != null) {
            MetadataModel<JsfModel> model = JsfModelFactory.getModel(webModule);
            if (model == null) {
                return result;
            }
            try {
                model.runReadAction((MetadataModelAction)new MetadataModelAction<JsfModel, Void>(){

                    public Void run(JsfModel metadata) throws Exception {
                        List<Converter> converters = metadata.getElements(Converter.class);
                        for (Converter converter : converters) {
                            if (oldName.equals(converter.getConverterClass())) {
                                result.add(new ConverterClassItem(converter, newName));
                                continue;
                            }
                            if (!oldName.equals(converter.getConverterForClass())) continue;
                            result.add(new ConverterForClassItem(converter, newName));
                        }
                        List<ManagedBean> beans = metadata.getElements(ManagedBean.class);
                        for (ManagedBean bean : beans) {
                            if (!oldName.equals(bean.getManagedBeanClass())) continue;
                            result.add(new ManagedBeanClassItem(bean, newName));
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return result;
    }

    public static List<OccurrenceItem> getPackageOccurrences(WebModule webModule, final String oldPackageName, final String newPackageName, final boolean renameSubpackages) {
        final ArrayList<OccurrenceItem> result = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (oldPackageName != null);
        if (webModule != null) {
            MetadataModel<JsfModel> model = JsfModelFactory.getModel(webModule);
            if (model == null) {
                return result;
            }
            try {
                model.runReadAction((MetadataModelAction)new MetadataModelAction<JsfModel, Void>(){

                    public Void run(JsfModel metadata) throws Exception {
                        List<Converter> converters = metadata.getElements(Converter.class);
                        for (Converter converter : converters) {
                            if (JSFRefactoringUtils.containsRenamingPackage(converter.getConverterClass(), oldPackageName, renameSubpackages)) {
                                result.add(new ConverterClassItem(converter, Occurrences.getNewFQCN(newPackageName, oldPackageName, converter.getConverterClass())));
                            }
                            if (!JSFRefactoringUtils.containsRenamingPackage(converter.getConverterForClass(), oldPackageName, renameSubpackages)) continue;
                            result.add(new ConverterForClassItem(converter, Occurrences.getNewFQCN(newPackageName, oldPackageName, converter.getConverterForClass())));
                        }
                        List<ManagedBean> beans = metadata.getElements(ManagedBean.class);
                        for (ManagedBean bean : beans) {
                            if (!JSFRefactoringUtils.containsRenamingPackage(bean.getManagedBeanClass(), oldPackageName, renameSubpackages)) continue;
                            result.add(new ManagedBeanClassItem(bean, Occurrences.getNewFQCN(newPackageName, oldPackageName, bean.getManagedBeanClass())));
                        }
                        return null;
                    }
                });
            }
            catch (MetadataModelException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return result;
    }

    public static String getNewFQCN(String newPackageName, String oldPackageName, String oldFQCN) {
        String value = oldFQCN;
        if (oldPackageName.length() == 0) {
            value = newPackageName + '.' + oldFQCN;
        } else if (oldFQCN.startsWith(oldPackageName)) {
            value = value.substring(oldPackageName.length());
            if (newPackageName.length() > 0) {
                value = newPackageName + value;
            }
            if (value.charAt(0) == '.') {
                value = value.substring(1);
            }
        }
        return value;
    }

    public static class ConverterForClassItem
    extends OccurrenceItem {
        public ConverterForClassItem(FileObject config, Converter converter, String newValue) {
            super(config, converter, newValue, converter.getConverterForClass(), converter.getConverterId());
        }

        public ConverterForClassItem(Converter converter, String newValue) {
            super(converter, newValue, converter.getConverterForClass(), converter.getConverterId());
        }

        @Override
        protected String getXMLElementName() {
            return "converter-for-class";
        }

        @Override
        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public void performChange() {
            this.changeConverterForClass(this.oldValue, this.newValue);
        }

        @Override
        public void undoChange() {
            this.changeConverterForClass(this.newValue, this.oldValue);
        }

        private void changeConverterForClass(String oldClass, String newClass) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!oldClass.equals(converter.getConverterForClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterForClass(newClass);
                converter.getModel().endTransaction();
                break;
            }
        }

        @Override
        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!this.oldValue.equals(converter.getConverterForClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        @Override
        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter((Converter)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static class ConverterClassItem
    extends OccurrenceItem {
        public ConverterClassItem(FileObject config, Converter converter, String newValue) {
            super(config, converter, newValue, converter.getConverterClass(), converter.getConverterId());
        }

        public ConverterClassItem(Converter converter, String newValue) {
            super(converter, newValue, converter.getConverterClass(), converter.getConverterId());
        }

        @Override
        protected String getXMLElementName() {
            return "converter-class";
        }

        @Override
        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public void performChange() {
            this.changeConverterClass(this.oldValue, this.newValue);
        }

        @Override
        public void undoChange() {
            this.changeConverterClass(this.newValue, this.oldValue);
        }

        private void changeConverterClass(String oldClass, String newClass) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!oldClass.equals(converter.getConverterClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterClass(newClass);
                converter.getModel().endTransaction();
                break;
            }
        }

        @Override
        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (Converter converter : facesConfig.getConverters()) {
                if (!this.oldValue.equals(converter.getConverterClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        @Override
        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter((Converter)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static class ManagedBeanClassItem
    extends OccurrenceItem {
        public ManagedBeanClassItem(FileObject config, ManagedBean bean, String newValue) {
            super(config, bean, newValue, bean.getManagedBeanClass(), bean.getManagedBeanName());
        }

        public ManagedBeanClassItem(ManagedBean bean, String newValue) {
            super(bean, newValue, bean.getManagedBeanClass(), bean.getManagedBeanName());
        }

        @Override
        protected String getXMLElementName() {
            return "managed-bean-class";
        }

        @Override
        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_WhereUsed", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_Rename", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public void performChange() {
            this.changeBeanClass(this.oldValue, this.newValue);
        }

        @Override
        public void undoChange() {
            this.changeBeanClass(this.newValue, this.oldValue);
        }

        private void changeBeanClass(String oldClass, String newClass) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                if (!oldClass.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                managedBean.setManagedBeanClass(newClass);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        @Override
        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_SafeDelete", (Object[])new Object[]{this.name, this.getElementText()});
        }

        @Override
        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            for (ManagedBean managedBean : facesConfig.getManagedBeans()) {
                if (!this.oldValue.equals(managedBean.getManagedBeanClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeManagedBean(managedBean);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        @Override
        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean((ManagedBean)this.copy);
            facesConfig.getModel().endTransaction();
        }
    }

    public static abstract class OccurrenceItem {
        protected FileObject config;
        protected JSFConfigComponent component;
        protected JSFConfigComponent copy;
        protected String oldValue;
        protected String newValue;
        protected String name;

        public OccurrenceItem(FileObject config, JSFConfigComponent component, String newValue, String oldValue, String name) {
            this.config = config;
            this.component = component;
            this.copy = (JSFConfigComponent)component.copy(component.getParent());
            this.newValue = newValue;
            this.oldValue = oldValue;
            this.name = name;
        }

        public OccurrenceItem(JSFConfigComponent component, String newValue, String oldValue, String name) {
            this(null, component, newValue, oldValue, name);
            this.config = (FileObject)component.getModel().getModelSource().getLookup().lookup(FileObject.class);
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public FileObject getFacesConfig() {
            return this.config;
        }

        public String getElementText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"#0000FF\">");
            stringBuffer.append("&lt;").append(this.getXMLElementName()).append("&gt;</font><b>");
            stringBuffer.append(this.oldValue).append("</b><font color=\"#0000FF\">&lt;/").append(this.getXMLElementName());
            stringBuffer.append("&gt;</font>");
            return stringBuffer.toString();
        }

        protected abstract String getXMLElementName();

        public String getRenamePackageMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Package_Rename", (Object[])new Object[]{this.getElementText()});
        }

        public abstract String getWhereUsedMessage();

        public abstract String getChangeMessage();

        public abstract void performChange();

        public abstract void undoChange();

        public abstract String getSafeDeleteMessage();

        public abstract void performSafeDelete();

        public abstract void undoSafeDelete();

        public PositionBounds getChangePosition() {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.config);
                if (!(dataObject instanceof JSFConfigDataObject)) {
                    return null;
                }
                BaseDocument document = JSFEditorUtilities.getBaseDocument(dataObject);
                int start = this.component.findPosition();
                String text = document.getText(start, document.getLength() - start);
                int startOffset = text.indexOf(this.getXMLElementName());
                startOffset = start + text.indexOf(this.oldValue, startOffset);
                int endOffset = startOffset + this.oldValue.length();
                CloneableEditorSupport editor = JSFEditorUtilities.findCloneableEditorSupport((DataObject)((JSFConfigDataObject)dataObject));
                if (editor != null) {
                    PositionRef bgn = editor.createPositionRef(startOffset, Position.Bias.Forward);
                    PositionRef end = editor.createPositionRef(endOffset, Position.Bias.Backward);
                    return new PositionBounds(bgn, end);
                }
            }
            catch (BadLocationException exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            catch (DataObjectNotFoundException exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return null;
        }
    }
}

