/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.logging.Logger;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.web.jsf.refactoring.JSFMoveClassPlugin;
import org.netbeans.modules.web.jsf.refactoring.JSFRenamePlugin;
import org.netbeans.modules.web.jsf.refactoring.JSFSafeDeletePlugin;
import org.netbeans.modules.web.jsf.refactoring.JSFWhereUsedPlugin;

public class JSFRefactoringFactory
implements RefactoringPluginFactory {
    private static final Logger LOGGER = Logger.getLogger(JSFRefactoringFactory.class.getName());

    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Object plugin = null;
        LOGGER.fine("Create instance called: " + refactoring);
        if (refactoring instanceof RenameRefactoring) {
            LOGGER.fine("Rename refactoring");
            plugin = new JSFRenamePlugin((RenameRefactoring)refactoring);
        } else if (refactoring instanceof WhereUsedQuery) {
            LOGGER.fine("Where used refactoring");
            plugin = new JSFWhereUsedPlugin((WhereUsedQuery)refactoring);
        } else if (refactoring instanceof MoveRefactoring) {
            LOGGER.fine("Move refactoring");
            plugin = new JSFMoveClassPlugin((MoveRefactoring)refactoring);
        } else if (refactoring instanceof SafeDeleteRefactoring) {
            LOGGER.fine("Safe delete refactoring");
            return new JSFSafeDeletePlugin((SafeDeleteRefactoring)refactoring);
        }
        return plugin;
    }
}

