/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.GoToSourceProvider;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class GoToJavaSourceProvider
extends GoToSourceProvider {
    @Override
    public boolean openSource(Project project, final String className, final String methodName, final String signature, final int line) {
        FileObject sourceFile;
        final AtomicBoolean result = new AtomicBoolean(false);
        String javaClassName = GoToJavaSourceProvider.getJavaFileName(className);
        ClasspathInfo cpi = project != null ? ProjectUtilities.getClasspathInfo(project, true) : null;
        ClassPath cp = cpi != null ? cpi.getClassPath(ClasspathInfo.PathKind.SOURCE) : null;
        FileObject fileObject = sourceFile = cp != null ? cp.findResource(javaClassName) : null;
        if (sourceFile == null) {
            cp = ClassPathSupport.createClassPath((FileObject[])GlobalPathRegistry.getDefault().getSourceRoots().toArray(new FileObject[0]));
            FileObject fileObject2 = sourceFile = cp != null ? cp.findResource(javaClassName) : null;
        }
        if (sourceFile == null) {
            return false;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)sourceFile);
        if (js != null) {
            try {
                js.runWhenScanFinished((Task)new Task<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        if (!controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).equals((Object)JavaSource.Phase.ELEMENTS_RESOLVED)) {
                            return;
                        }
                        TypeElement parentClass = SourceUtils.resolveClassByName((String)className, (CompilationController)controller);
                        if (ElementOpen.open((ClasspathInfo)controller.getClasspathInfo(), (Element)parentClass)) {
                            Document doc = controller.getDocument();
                            if (doc != null && doc instanceof StyledDocument) {
                                ExecutableElement methodElement;
                                if (GoToJavaSourceProvider.openAtLine(controller, doc, methodName, line)) {
                                    result.set(true);
                                    return;
                                }
                                if (methodName != null && (methodElement = SourceUtils.resolveMethodByName((CompilationInfo)controller, (TypeElement)parentClass, (String)methodName, (String)signature)) != null && ElementOpen.open((ClasspathInfo)controller.getClasspathInfo(), (Element)methodElement)) {
                                    result.set(true);
                                    return;
                                }
                            }
                            result.set(true);
                        }
                    }
                }, true);
            }
            catch (IOException e) {
                // empty catch block
            }
            return result.get();
        }
        return false;
    }

    private static boolean openAtLine(CompilationController controller, Document doc, String methodName, int line) {
        try {
            if (line > -1) {
                Line l;
                LineCookie lc;
                String offsetMethodName;
                DataObject od = DataObject.find((FileObject)controller.getFileObject());
                int offset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)line);
                ExecutableElement parentMethod = controller.getTreeUtilities().scopeFor(offset).getEnclosingMethod();
                if (parentMethod != null && methodName.equals(offsetMethodName = parentMethod.getSimpleName().toString()) && (lc = (LineCookie)od.getCookie(LineCookie.class)) != null && (l = lc.getLineSet().getCurrent(line - 1)) != null) {
                    l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    return true;
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(GoToJavaSourceProvider.class.getName()).log(Level.WARNING, "Error accessing dataobject", e);
        }
        return false;
    }

    private static String getJavaFileName(String className) {
        String classNameIntern = className.replace('.', '/');
        int innerIndex = classNameIntern.indexOf("$");
        if (innerIndex > -1) {
            classNameIntern = classNameIntern.substring(0, innerIndex);
        }
        return classNameIntern.concat(".java");
    }
}

