/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.modules.profiler.categories.Categorization;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;

public class DrillDownFactory
implements CCTResultsFilter.EvaluatorProvider {
    private final Set<WeakEvaluator> drillDownEvaluators = Collections.synchronizedSet(new HashSet());

    public DrillDown createDrillDown(Project project, ProfilerClient client) {
        if (project == null) {
            return null;
        }
        if (Categorization.isAvailable(project)) {
            DrillDown dd = new DrillDown(new Categorization(project), client);
            this.drillDownEvaluators.add(new WeakEvaluator(dd));
            return dd;
        }
        return null;
    }

    public Set getEvaluators() {
        return this.drillDownEvaluators;
    }

    private static class WeakEvaluator
    extends WeakReference<CCTResultsFilter.Evaluator>
    implements CCTResultsFilter.Evaluator {
        public WeakEvaluator(CCTResultsFilter.Evaluator referent, ReferenceQueue<? super CCTResultsFilter.Evaluator> q) {
            super(referent, q);
        }

        public WeakEvaluator(CCTResultsFilter.Evaluator referent) {
            super(referent);
        }

        public boolean evaluate(Mark mark) {
            CCTResultsFilter.Evaluator eval = (CCTResultsFilter.Evaluator)this.get();
            return eval != null ? eval.evaluate(mark) : true;
        }
    }
}

