/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TriggerCustomizer
extends ValidityAwarePanel
implements ActionListener {
    private static final String HEAP_USG_REL_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapUsgRelKey");
    private static final String HEAP_USG_REL_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapUsgRelUnit");
    private static final String HEAP_SIZE_ABS_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapSizeAbsKey");
    private static final String HEAP_SIZE_ABS_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_HeapSizeAbsUnit");
    private static final String SURVGEN_COUNT_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_SurvgenCountKey");
    private static final String SURVGEN_COUNT_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_SurvgenCountUnit");
    private static final String LDCLASS_COUNT_KEY = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_LdClassCountKey");
    private static final String LDCLASS_COUNT_UNIT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_LdClassCountUnit");
    private static final String TAKE_WHEN_LABEL_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_TakeWhenLabelText");
    private static final String EXCEEDS_LABEL_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_ExceedsLabelText");
    private static final String TAKE_ONCE_RADIO_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_TakeOnceRadioText");
    private static final String TAKE_ALWAYS_RADIO_TEXT = NbBundle.getMessage(TriggerCustomizer.class, (String)"TriggerCustomizer_TakeAlwaysRadioText");
    private static int defaultTextComponentHeight = -1;
    private final SpinnerModel percentsModel = new SpinnerNumberModel(1, 1, 99, 1);
    private final SpinnerModel unitsModel = new SpinnerNumberModel(1, 1, 9999, 1);
    private JComboBox triggerWhenCombo;
    private JLabel triggerExceedsLabel;
    private JLabel triggerGenerationsLabel;
    private JLabel triggerWhenLabel;
    private JRadioButton triggerAlwaysRadio;
    private JRadioButton triggerOnceRadio;
    private JSpinner triggerValueSpinner;

    public TriggerCustomizer() {
        this.initComponents();
    }

    public int getPreferredCaptionAreaWidth() {
        return -1;
    }

    public void setTriggerCondition(TriggeredGlobalProfilingPoint.TriggerCondition condition) {
        switch (condition.getMetric()) {
            case 1: {
                this.triggerWhenCombo.setSelectedItem(HEAP_USG_REL_KEY);
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 2: {
                this.triggerWhenCombo.setSelectedItem(HEAP_SIZE_ABS_KEY);
                this.triggerValueSpinner.setValue((int)(condition.getValue() / 0x100000L));
                break;
            }
            case 3: {
                this.triggerWhenCombo.setSelectedItem(SURVGEN_COUNT_KEY);
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
            case 4: {
                this.triggerWhenCombo.setSelectedItem(LDCLASS_COUNT_KEY);
                this.triggerValueSpinner.setValue((int)condition.getValue());
                break;
            }
        }
        this.triggerOnceRadio.setSelected(condition.isOnetime());
        this.triggerAlwaysRadio.setSelected(!condition.isOnetime());
    }

    public TriggeredGlobalProfilingPoint.TriggerCondition getTriggerCondition() {
        TriggeredGlobalProfilingPoint.TriggerCondition condition = new TriggeredGlobalProfilingPoint.TriggerCondition();
        Object key = this.triggerWhenCombo.getSelectedItem();
        if (key == HEAP_USG_REL_KEY) {
            condition.setMetric(1);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (key == HEAP_SIZE_ABS_KEY) {
            condition.setMetric(2);
            condition.setValue((long)((Integer)this.triggerValueSpinner.getValue()).intValue() * 0x100000L);
        } else if (key == SURVGEN_COUNT_KEY) {
            condition.setMetric(3);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        } else if (key == LDCLASS_COUNT_KEY) {
            condition.setMetric(4);
            condition.setValue(((Integer)this.triggerValueSpinner.getValue()).intValue());
        }
        condition.setOnetime(this.triggerOnceRadio.isSelected());
        return condition;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.triggerWhenCombo) {
            Object key = this.triggerWhenCombo.getSelectedItem();
            if (key == HEAP_USG_REL_KEY) {
                this.triggerGenerationsLabel.setText(HEAP_USG_REL_UNIT);
                this.triggerValueSpinner.setModel(this.percentsModel);
            } else if (key == HEAP_SIZE_ABS_KEY) {
                this.triggerGenerationsLabel.setText(HEAP_SIZE_ABS_UNIT);
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (key == SURVGEN_COUNT_KEY) {
                this.triggerGenerationsLabel.setText(SURVGEN_COUNT_UNIT);
                this.triggerValueSpinner.setModel(this.unitsModel);
            } else if (key == LDCLASS_COUNT_KEY) {
                this.triggerGenerationsLabel.setText(LDCLASS_COUNT_UNIT);
                this.triggerValueSpinner.setModel(this.unitsModel);
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        TriggerCustomizer main = new TriggerCustomizer();
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JPanel triggerSettingsContainer = new JPanel(new GridBagLayout());
        this.triggerWhenLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.triggerWhenLabel, (String)TAKE_WHEN_LABEL_TEXT);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerWhenLabel, constraints);
        this.triggerWhenCombo = new JComboBox(new Object[]{HEAP_USG_REL_KEY, HEAP_SIZE_ABS_KEY, SURVGEN_COUNT_KEY, LDCLASS_COUNT_KEY}){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Math.min(super.getPreferredSize().width, 200), super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.triggerWhenLabel.setLabelFor(this.triggerWhenCombo);
        this.triggerWhenCombo.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerWhenCombo, constraints);
        this.triggerExceedsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.triggerExceedsLabel, (String)EXCEEDS_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerExceedsLabel, constraints);
        this.triggerValueSpinner = new JExtendedSpinner(this.percentsModel){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.triggerExceedsLabel.setLabelFor(this.triggerValueSpinner);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerValueSpinner, constraints);
        this.triggerGenerationsLabel = new JLabel(HEAP_USG_REL_UNIT);
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerSettingsContainer.add((Component)this.triggerGenerationsLabel, constraints);
        JPanel triggerFillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerSettingsContainer.add((Component)triggerFillerPanel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)triggerSettingsContainer, constraints);
        ButtonGroup triggerRadiosGroup = new ButtonGroup();
        JPanel triggerRadiosContainer = new JPanel(new GridBagLayout());
        this.triggerOnceRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerOnceRadio, (String)TAKE_ONCE_RADIO_TEXT);
        triggerRadiosGroup.add(this.triggerOnceRadio);
        this.triggerOnceRadio.setSelected(true);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerRadiosContainer.add((Component)this.triggerOnceRadio, constraints);
        this.triggerAlwaysRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.triggerAlwaysRadio, (String)TAKE_ALWAYS_RADIO_TEXT);
        triggerRadiosGroup.add(this.triggerAlwaysRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerRadiosContainer.add((Component)this.triggerAlwaysRadio, constraints);
        JPanel takeRadiosSpacer = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerRadiosContainer.add((Component)takeRadiosSpacer, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)triggerRadiosContainer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    private void updateValidity() {
        boolean isValid = true;
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

