/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotReverseMemCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.actions.FindAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class MemorySnapshotPanel
extends SnapshotPanel
implements ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final String MEMORY_RESULTS_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_MemoryResultsTabName");
    private static final String STACK_TRACES_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StackTracesTabName");
    private static final String INFO_TAB_NAME = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_InfoTabName");
    private static final String MEMORY_RESULTS_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_MemoryResultsTabDescr");
    private static final String STACK_TRACES_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StackTracesTabDescr");
    private static final String INFO_TAB_DESCR = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_InfoTabDescr");
    private static final String PANEL_TITLE = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_PanelTitle");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(MemorySnapshotPanel.class, (String)"MemorySnapshotPanel_FindActionTooltip");
    private static final ImageIcon MEMORY_RESULTS_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/memoryResultsTab.png", (boolean)false);
    private static final ImageIcon INFO_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/infoTab.png", (boolean)false);
    private static final ImageIcon STACK_TRACES_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/stackTracesTab.png", (boolean)false);
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private JTabbedPane tabs = new JTabbedPane(3);
    private MemoryResultsPanel memoryPanel;
    private MemoryResultsSnapshot snapshot;
    private Project project;
    private SaveSnapshotAction saveAction;
    private SnapshotInfoPanel infoPanel;
    private SnapshotReverseMemCallGraphPanel reversePanel;

    public MemorySnapshotPanel(Lookup context, LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.snapshot = (MemoryResultsSnapshot)ls.getSnapshot();
        this.project = ls.getProject();
        this.setLayout(new BorderLayout());
        SnapshotActionsHandler memoryActionsHandler = new SnapshotActionsHandler();
        this.infoPanel = new SnapshotInfoPanel(ls);
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            this.memoryPanel = new SnapshotLivenessResultsPanel((LivenessMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler, ls.getSettings().getAllocTrackEvery());
            SnapshotLivenessResultsPanel lmemoryPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            lmemoryPanel.setSorting(sortingColumn, sortingOrder);
            lmemoryPanel.prepareResults();
        } else {
            this.memoryPanel = new SnapshotAllocResultsPanel((AllocMemoryResultsSnapshot)this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler);
            SnapshotAllocResultsPanel amemoryPanel = (SnapshotAllocResultsPanel)this.memoryPanel;
            amemoryPanel.setSorting(sortingColumn, sortingOrder);
            amemoryPanel.prepareResults();
        }
        this.infoPanel.updateInfo();
        this.tabs.addTab(MEMORY_RESULTS_TAB_NAME, MEMORY_RESULTS_TAB_ICON, (Component)this.memoryPanel, MEMORY_RESULTS_TAB_DESCR);
        if (this.snapshot.containsStacks()) {
            this.reversePanel = new SnapshotReverseMemCallGraphPanel(this.snapshot, (MemoryResUserActionsHandler)memoryActionsHandler);
            this.reversePanel.prepareResults();
            this.tabs.addTab(STACK_TRACES_TAB_NAME, STACK_TRACES_TAB_ICON, (Component)this.reversePanel, STACK_TRACES_TAB_DESCR);
            this.tabs.setEnabledAt(this.tabs.getTabCount() - 1, false);
        }
        this.tabs.addTab(INFO_TAB_NAME, INFO_TAB_ICON, this.infoPanel, INFO_TAB_DESCR);
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        JToolBar toolBar = new JToolBar(){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.saveAction = new SaveSnapshotAction(ls);
        toolBar.add(this.saveAction);
        toolBar.add(new ExportAction(this, ls));
        toolBar.add(new SaveViewAction(this));
        toolBar.addSeparator();
        ContextAwareAction a = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = toolBar.add(a.createContextAwareInstance(context));
        this.findPreviousPresenter = toolBar.add(new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            JButton ab = this.findActionPresenter;
            ab.setIcon(Utils.FIND_ACTION_ICON);
            ab.setText("");
            ab.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        toolBar.addSeparator();
        toolBar.add(new CompareSnapshotsAction(ls));
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add((Component)toolBar, "North");
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.moveToNextSubTab();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemorySnapshotPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.memoryPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.infoPanel.getCurrentViewScreenshot(onlyVisibleArea);
        }
        return null;
    }

    @Override
    public String getViewName() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-memory_results";
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-allocation_stack_traces";
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-info";
        }
        return null;
    }

    public void displayStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        this.setReverseCallGraphClass(selectedClassId, sortingColumn, sortingOrder);
        this.tabs.setSelectedComponent((Component)this.reversePanel);
    }

    @Override
    public boolean fitsVisibleArea() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return this.memoryPanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.fitsVisibleArea();
        }
        if (this.tabs.getSelectedComponent() == this.infoPanel) {
            return this.infoPanel.fitsVisibleArea();
        }
        return true;
    }

    @Override
    public boolean hasView() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return true;
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    @Override
    public void performFind() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
            if (this.reversePanel != null) {
                this.reversePanel.setFindString(findString);
            }
            if (!this.memoryPanel.findFirst()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
            this.reversePanel.setFindString(findString);
            if (!this.reversePanel.findFirst()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    @Override
    public void performFindNext() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(findString);
                }
            }
            if (!this.memoryPanel.findNext()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.reversePanel.findNext()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    @Override
    public void performFindPrevious() {
        String findString;
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (!this.memoryPanel.isFindStringDefined()) {
                findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                if (this.reversePanel != null) {
                    this.reversePanel.setFindString(findString);
                }
            }
            if (!this.memoryPanel.findPrevious()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            if (!this.reversePanel.isFindStringDefined()) {
                findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.memoryPanel.setFindString(findString);
                this.reversePanel.setFindString(findString);
            }
            if (!this.reversePanel.findPrevious()) {
                NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.memoryPanel != null) {
            this.memoryPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateToolbar();
        if (this.tabs.getSelectedComponent() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MemorySnapshotPanel.this.tabs.getSelectedComponent().requestFocus();
                }
            });
        }
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot snapshot) {
        return "snapshot-" + snapshot.getTimeTaken();
    }

    private void setReverseCallGraphClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        this.reversePanel.setClassId(selectedClassId);
        this.reversePanel.setSorting(sortingColumn, sortingOrder);
        this.reversePanel.prepareResults();
        this.tabs.setEnabledAt(this.tabs.indexOfTab(STACK_TRACES_TAB_NAME), true);
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void updateToolbar() {
        boolean findEnabled = this.tabs.getSelectedComponent() != this.infoPanel && (this.tabs.getSelectedComponent() != this.reversePanel || !this.reversePanel.isEmpty());
        this.findActionPresenter.setEnabled(findEnabled);
        this.findPreviousPresenter.setEnabled(findEnabled);
        this.findNextPresenter.setEnabled(findEnabled);
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            if (this.memoryPanel instanceof SnapshotAllocResultsPanel) {
                ((SnapshotAllocResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, MEMORY_RESULTS_TAB_NAME);
            } else if (this.memoryPanel instanceof SnapshotLivenessResultsPanel) {
                ((SnapshotLivenessResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, MEMORY_RESULTS_TAB_NAME);
            }
        } else if (this.tabs.getSelectedComponent() == this.reversePanel) {
            this.reversePanel.exportData(exportedFileType, eDD, STACK_TRACES_TAB_NAME);
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public boolean hasExportableView() {
        if (this.tabs.getSelectedComponent() == this.memoryPanel) {
            return true;
        }
        if (this.tabs.getSelectedComponent() == this.reversePanel) {
            return this.reversePanel.hasView();
        }
        return false;
    }

    private class SnapshotActionsHandler
    implements MemoryResUserActionsHandler {
        private SnapshotActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (methodName == null && methodSig == null && (VMUtils.isVMPrimitiveType((String)className) || VMUtils.isPrimitiveType((String)className))) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) && "traceVMObjectAlloc".equals(methodName)) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                NetBeansProfiler.getDefaultNB().openJavaSource(MemorySnapshotPanel.this.project, className, methodName, methodSig);
            }
        }

        public void showStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
            MemorySnapshotPanel.this.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
        }
    }
}

