/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.actions;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.swingapp.ActionPropertyEditorPanel;

public class AcceleratorKeyListener
implements KeyListener {
    private int currentKeyCode = 0;
    private KeyStroke keyStroke = null;
    private ActionPropertyEditorPanel panel;

    public AcceleratorKeyListener(ActionPropertyEditorPanel panel) {
        this.panel = panel;
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        ke.consume();
        JTextField tf = (JTextField)ke.getSource();
        switch (ke.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return;
            }
        }
        this.setModifiers(ke);
        String s = this.toString(ke);
        if (!tf.getText().equals(s)) {
            tf.setText(s);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        ke.consume();
    }

    public void setCurrentKeyStroke(KeyStroke ks) {
        this.clearFields();
        this.keyStroke = ks;
        if (this.keyStroke != null) {
            this.currentKeyCode = this.keyStroke.getKeyCode();
            this.panel.acceleratorText.setText(KeyEvent.getKeyText(this.currentKeyCode));
            this.panel.shiftCheckbox.setSelected((this.keyStroke.getModifiers() & 0x40) > 0);
            this.panel.controlCheckbox.setSelected((this.keyStroke.getModifiers() & 0x80) > 0);
            this.panel.altCheckbox.setSelected((this.keyStroke.getModifiers() & 0x200) > 0);
            this.panel.metaCheckbox.setSelected((this.keyStroke.getModifiers() & 0x100) > 0);
        }
    }

    public KeyStroke getCurrentKeyStroke() {
        return this.keyStroke;
    }

    public void clearFields() {
        this.panel.shiftCheckbox.setSelected(false);
        this.panel.controlCheckbox.setSelected(false);
        this.panel.altCheckbox.setSelected(false);
        this.panel.metaCheckbox.setSelected(false);
        this.panel.acceleratorText.setText("");
        this.keyStroke = null;
    }

    public void setEnabled(boolean enabled) {
        this.panel.shiftCheckbox.setEnabled(enabled);
        this.panel.controlCheckbox.setEnabled(enabled);
        this.panel.altCheckbox.setEnabled(enabled);
        this.panel.metaCheckbox.setEnabled(enabled);
        this.panel.acceleratorText.setEnabled(enabled);
    }

    public void updateFromModifiers() {
        int mask = 0;
        if (this.panel.shiftCheckbox.isSelected()) {
            mask |= 1;
        }
        if (this.panel.altCheckbox.isSelected()) {
            mask |= 8;
        }
        if (this.panel.controlCheckbox.isSelected()) {
            mask |= 2;
        }
        if (this.panel.metaCheckbox.isSelected()) {
            mask |= 4;
        }
        this.keyStroke = KeyStroke.getKeyStroke(this.currentKeyCode, mask);
    }

    private void setModifiers(KeyEvent ke) {
        if (ke.isShiftDown() || ke.isControlDown() || ke.isAltDown() || ke.isMetaDown()) {
            this.panel.shiftCheckbox.setSelected(ke.isShiftDown());
            this.panel.controlCheckbox.setSelected(ke.isControlDown());
            this.panel.altCheckbox.setSelected(ke.isAltDown());
            this.panel.metaCheckbox.setSelected(ke.isMetaDown());
        }
    }

    private String toString(KeyEvent ke) {
        if (!(ke.isShiftDown() || ke.isControlDown() || ke.isAltDown() || ke.isMetaDown())) {
            int modifiers = this.panel.altCheckbox.isSelected() ? 8 : 0;
            modifiers |= this.panel.controlCheckbox.isSelected() ? 2 : 0;
            modifiers |= this.panel.metaCheckbox.isSelected() ? 4 : 0;
            ke = new KeyEvent((Component)ke.getSource(), ke.getID(), ke.getWhen(), modifiers |= this.panel.shiftCheckbox.isSelected() ? 1 : 0, ke.getKeyCode(), ke.getKeyChar());
        }
        this.keyStroke = KeyStroke.getKeyStrokeForEvent(ke);
        this.currentKeyCode = ke.getKeyCode();
        return KeyEvent.getKeyText(this.currentKeyCode);
    }
}

