/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RefactoringPluginFactoryImpl
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        if (refactoring instanceof RenameRefactoring || refactoring instanceof MoveRefactoring || refactoring instanceof SingleCopyRefactoring) {
            Lookup sourceLookup = refactoring.getRefactoringSource();
            FileObject srcFile = (FileObject)sourceLookup.lookup(FileObject.class);
            NonRecursiveFolder pkg = (NonRecursiveFolder)sourceLookup.lookup(NonRecursiveFolder.class);
            if (srcFile != null && RefactoringPluginFactoryImpl.isJavaFile(srcFile) || pkg != null) {
                return new RefactoringPluginImpl(refactoring);
            }
        }
        return null;
    }

    private static boolean isJavaFile(FileObject fo) {
        return "text/x-java".equals(fo.getMIMEType());
    }

    static boolean isJavaFileOfForm(FileObject fo) {
        return RefactoringPluginFactoryImpl.isJavaFile(fo) && fo.existsExt("form");
    }

    private static class ResourcePackageUpdate
    implements Transaction {
        private RenameRefactoring refactoring;
        private RefactoringElementImplementation refElement;
        private String oldPkgName;
        private DataFolder resFolder;

        ResourcePackageUpdate(RenameRefactoring refactoring, RefactoringElementImplementation refElement, FileObject resFolder) {
            this.refactoring = refactoring;
            this.refElement = refElement;
            this.resFolder = DataFolder.findFolder((FileObject)resFolder);
            this.oldPkgName = ClassPath.getClassPath((FileObject)resFolder, (String)"classpath/source").getResourceName(resFolder.getParent(), '.', false);
        }

        public void commit() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)this.resFolder.getPrimaryFile(), (String)"classpath/source");
            FileObject srcRoot = cp.findOwnerRoot(this.resFolder.getPrimaryFile());
            String newName = this.refactoring.getNewName().replace('.', '/');
            try {
                DataFolder targetFolder = DataFolder.findFolder((FileObject)FileUtil.createFolder((FileObject)srcRoot, (String)newName));
                this.resFolder.move(targetFolder);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void rollback() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)this.resFolder.getPrimaryFile(), (String)"classpath/source");
            FileObject srcRoot = cp.findOwnerRoot(this.resFolder.getPrimaryFile());
            FileObject pkgFolder = this.resFolder.getPrimaryFile().getParent();
            try {
                DataFolder targetFolder = DataFolder.findFolder((FileObject)FileUtil.createFolder((FileObject)srcRoot, (String)this.oldPkgName.replace('.', '/')));
                this.resFolder.move(targetFolder);
                if (pkgFolder != null && pkgFolder.isValid() && pkgFolder.getChildren().length == 0) {
                    pkgFolder.delete();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class ResourceMapUpdate
    extends SimpleRefactoringElementImplementation
    implements Transaction {
        private AbstractRefactoring refactoring;
        private RefactoringElementImplementation refElement;
        private DataObject propertiesDO;
        private DataObject newPropertiesDO;
        private String oldName;
        private FileObject oldFolder;
        private FileObject srcFileBefore;
        private FileObject srcFileAfter;

        ResourceMapUpdate(AbstractRefactoring refactoring, RefactoringElementImplementation previewElement, FileObject srcFileBefore, DataObject propertiesDO) {
            this.refactoring = refactoring;
            this.refElement = previewElement;
            this.propertiesDO = propertiesDO;
            this.oldName = propertiesDO.getName();
            this.oldFolder = propertiesDO.getFolder().getPrimaryFile();
            this.srcFileBefore = srcFileBefore;
        }

        public void commit() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if (this.refactoring instanceof RenameRefactoring) {
                this.srcFileAfter = this.srcFileBefore;
                String newName = ((RenameRefactoring)this.refactoring).getNewName();
                try {
                    this.propertiesDO.rename(newName);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (this.refactoring instanceof MoveRefactoring) {
                URL targetURL = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                FileObject targetFolder = null;
                try {
                    File f = FileUtil.normalizeFile((File)new File(targetURL.toURI()));
                    targetFolder = FileUtil.toFileObject((File)f);
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (targetFolder != null && targetFolder.isFolder()) {
                    try {
                        targetFolder = FileUtil.createFolder((FileObject)targetFolder, (String)"resources");
                        this.propertiesDO.move(DataFolder.findFolder((FileObject)targetFolder));
                        this.newPropertiesDO = this.propertiesDO;
                        if (this.srcFileBefore != null) {
                            ResourceUtils.unregisterDesignResourceMap(this.srcFileBefore);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else if (this.refactoring instanceof SingleCopyRefactoring) {
                SingleCopyRefactoring copyRef = (SingleCopyRefactoring)this.refactoring;
                URL targetURL = (URL)copyRef.getTarget().lookup(URL.class);
                FileObject targetFolder = null;
                try {
                    File f = FileUtil.normalizeFile((File)new File(targetURL.toURI()));
                    targetFolder = FileUtil.toFileObject((File)f);
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (targetFolder != null && targetFolder.isFolder()) {
                    String newName = copyRef.getNewName();
                    try {
                        targetFolder = FileUtil.createFolder((FileObject)targetFolder, (String)"resources");
                        if (targetFolder.getFileObject(newName, "properties") == null) {
                            this.newPropertiesDO = this.propertiesDO.copy(DataFolder.findFolder((FileObject)targetFolder));
                            this.newPropertiesDO.rename(newName);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }

        public void rollback() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if (this.refactoring instanceof RenameRefactoring) {
                try {
                    this.propertiesDO.rename(this.oldName);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (this.refactoring instanceof MoveRefactoring) {
                try {
                    this.propertiesDO.move(DataFolder.findFolder((FileObject)this.oldFolder));
                    this.newPropertiesDO = null;
                    if (this.srcFileAfter != null) {
                        ResourceUtils.unregisterDesignResourceMap(this.srcFileAfter);
                        this.srcFileAfter = null;
                    }
                    this.srcFileBefore = this.oldFolder.getParent().getFileObject(this.oldName, "java");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (this.refactoring instanceof SingleCopyRefactoring && this.newPropertiesDO != null) {
                try {
                    this.newPropertiesDO.delete();
                    this.newPropertiesDO = null;
                    if (this.srcFileAfter != null) {
                        ResourceUtils.unregisterDesignResourceMap(this.srcFileAfter);
                        this.srcFileAfter = null;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public void performChange() {
        }

        public void undoChange() {
            if (!this.refElement.isEnabled()) {
                return;
            }
            if ((this.refactoring instanceof MoveRefactoring || this.refactoring instanceof SingleCopyRefactoring) && this.newPropertiesDO != null) {
                FileObject targetFolder = this.newPropertiesDO.getPrimaryFile().getParent().getParent();
                this.srcFileAfter = targetFolder.getFileObject(this.newPropertiesDO.getName(), "java");
            }
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourceMapRef", (Object)this.propertiesDO.getPrimaryFile().getNameExt());
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.propertiesDO.getPrimaryFile();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class PreviewElement
    extends SimpleRefactoringElementImplementation {
        private FileObject file;
        private String displayText;

        PreviewElement(FileObject file, String displayText) {
            this.file = file;
            this.displayText = displayText;
        }

        public String getText() {
            return "Resources update";
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static class RefactoringPluginImpl
    implements RefactoringPlugin {
        private AbstractRefactoring refactoring;

        RefactoringPluginImpl(AbstractRefactoring refactoring) {
            this.refactoring = refactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            FileObject resFolder;
            FileObject pkgFolder;
            Lookup sourceLookup = this.refactoring.getRefactoringSource();
            NonRecursiveFolder pkg = (NonRecursiveFolder)sourceLookup.lookup(NonRecursiveFolder.class);
            if (pkg == null) {
                for (FileObject srcFile : sourceLookup.lookupAll(FileObject.class)) {
                    String displayText;
                    File f;
                    URL targetURL;
                    PropertiesDataObject propertiesDO;
                    if (srcFile.isFolder() || !AppFrameworkSupport.isFrameworkLibAvailable(srcFile) || (propertiesDO = ResourceUtils.getPropertiesDataObject(srcFile)) == null) continue;
                    PreviewElement previewElement = null;
                    if (this.refactoring instanceof RenameRefactoring) {
                        String displayText2 = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_RenameFileRef", (Object)propertiesDO.getPrimaryFile().getNameExt());
                        previewElement = new PreviewElement(srcFile, displayText2);
                    } else if (this.refactoring instanceof MoveRefactoring) {
                        targetURL = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                        try {
                            f = FileUtil.normalizeFile((File)new File(targetURL.toURI()));
                            if (f.isDirectory()) {
                                displayText = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_MoveFileRef", (Object)propertiesDO.getPrimaryFile().getNameExt());
                                previewElement = new PreviewElement(srcFile, displayText);
                            }
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    } else if (this.refactoring instanceof SingleCopyRefactoring) {
                        targetURL = (URL)((SingleCopyRefactoring)this.refactoring).getTarget().lookup(URL.class);
                        try {
                            f = FileUtil.normalizeFile((File)new File(targetURL.toURI()));
                            if (f.isDirectory()) {
                                displayText = NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"FMT_CopyFileRef", (Object)propertiesDO.getPrimaryFile().getNameExt());
                                previewElement = new PreviewElement(srcFile, displayText);
                            }
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (previewElement == null) continue;
                    refactoringElements.add(this.refactoring, (RefactoringElementImplementation)previewElement);
                    ResourceMapUpdate update = new ResourceMapUpdate(this.refactoring, (RefactoringElementImplementation)previewElement, srcFile, (DataObject)propertiesDO);
                    refactoringElements.registerTransaction((Transaction)update);
                    refactoringElements.addFileChange(this.refactoring, (RefactoringElementImplementation)update);
                }
            } else if (this.refactoring instanceof RenameRefactoring && AppFrameworkSupport.isFrameworkLibAvailable(pkgFolder = pkg.getFolder()) && (resFolder = pkgFolder.getFileObject("resources")) != null) {
                PreviewElement previewElement = new PreviewElement(resFolder, NbBundle.getMessage(RefactoringPluginFactoryImpl.class, (String)"CTL_ResourcesPackageRef1"));
                refactoringElements.add(this.refactoring, (RefactoringElementImplementation)previewElement);
                ResourcePackageUpdate update = new ResourcePackageUpdate((RenameRefactoring)this.refactoring, (RefactoringElementImplementation)previewElement, resFolder);
                refactoringElements.registerTransaction((Transaction)update);
            }
            return null;
        }
    }
}

