/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.jdesktop.application.ResourceMap;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.awt.Mnemonics;

public class ProxyAction
implements Action,
ResourceValue,
Serializable {
    private String id;
    private String methodName;
    private String classname;
    private Map<String, Object> values = new HashMap<String, Object>();
    private boolean enabled = true;
    private boolean appWide;
    private boolean taskEnabled;
    private String enabledName;
    private String selectedName;
    private BlockingType blockingType;
    private transient DesignResourceMap resourceMap;
    private static final String[] ANNOTATION_ATTR_NAMES = new String[]{"block", "enabledProperty", "name", "selectedProperty"};

    public ProxyAction(String className, String id, String methodName) {
        this.classname = className;
        this.id = id;
        this.blockingType = BlockingType.NONE;
        this.methodName = methodName;
    }

    ProxyAction() {
        this("", "", "");
    }

    ProxyAction(ProxyAction copy) {
        this.id = copy.id;
        this.classname = copy.classname;
        this.values = copy.values;
        this.enabled = copy.enabled;
        this.appWide = copy.appWide;
        this.taskEnabled = copy.taskEnabled;
        this.enabledName = copy.enabledName;
        this.selectedName = copy.selectedName;
        this.resourceMap = copy.resourceMap;
        this.methodName = copy.methodName;
    }

    public void loadFromResourceMap() {
        String text = (String)this.getResource("text", String.class);
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)text);
        int mnem = label.getDisplayedMnemonic();
        int mnemIndex = label.getDisplayedMnemonicIndex();
        this.putValue("Name", label.getText());
        if (mnem != 0) {
            this.putValue("MnemonicKey", mnem);
        }
        if (mnemIndex >= 0) {
            this.putValue("SwingDisplayedMnemonicIndexKey", mnemIndex);
        }
        this.putValue("ShortDescription", this.getResource("shortDescription", String.class));
        this.putValue("AcceleratorKey", this.getResource("accelerator", KeyStroke.class));
        Object icon = this.getResource("icon", Icon.class);
        Object iconString = this.getResource("icon", String.class);
        Object smallIcon = this.getResource("smallIcon", Icon.class);
        Object smallIconString = this.getResource("smallIcon", String.class);
        this.putValue("SmallIcon", smallIcon != null ? smallIcon : icon);
        this.putValue("SmallIcon.IconName", smallIcon != null ? smallIconString : iconString);
        this.putValue("SwingLargeIconKey", this.getResource("largeIcon", Icon.class));
        this.putValue("SwingLargeIconKey.IconName", this.getResource("largeIcon", String.class));
        String blockPrefix = this.getId() + ".BlockingDialog.";
        this.putValue("BlockingDialog.message", this.getResource(blockPrefix, "optionPane.message", String.class));
        this.putValue("BlockingDialog.title", this.getResource(blockPrefix, "title", String.class));
        this.putValue("IconName", this.getIconName("icon"));
        this.putValue("SmallIconName", this.getIconName("smallIcon"));
        this.putValue("LargeIconName", this.getIconName("largeIcon"));
    }

    private Object getResource(String name, Class valueType) {
        return this.getResource(this.getId() + ".Action.", name, valueType);
    }

    private Object getResource(String prefix, String name, Class valueType) {
        try {
            return this.resourceMap.getObject(prefix + name, valueType);
        }
        catch (ResourceMap.LookupException ex) {
            Logger.getLogger(ProxyAction.class.getName()).log(Level.INFO, "Error loading action resource: " + prefix + name, ex);
            return null;
        }
    }

    private String getIconName(String name) {
        try {
            ResourceValueImpl resValue = null;
            if (resValue == null) {
                String key = this.id + ".Action." + name;
                resValue = this.resourceMap.getResourceValue(key, Icon.class);
            }
            if (resValue != null) {
                String cpName = resValue.getClassPathResourceName();
                return cpName != null ? cpName : resValue.getStringValue();
            }
            return null;
        }
        catch (ResourceMap.LookupException ex) {
            Logger.getLogger(ProxyAction.class.getName()).log(Level.INFO, "there was an error loading the icon name for: " + name, ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public String getId() {
        return this.id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String toString() {
        return this.id != null ? this.id : "no action set";
    }

    @Override
    public Object getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this.values.put(key, value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public boolean isAppWide() {
        return this.appWide;
    }

    public void setAppWide(boolean appWide) {
        this.appWide = appWide;
    }

    public Scope getScope() {
        if (this.isAppWide()) {
            return Scope.Application;
        }
        return Scope.Form;
    }

    public boolean isTaskEnabled() {
        return this.taskEnabled;
    }

    public void setTaskEnabled(boolean taskEnabled) {
        this.taskEnabled = taskEnabled;
    }

    public BlockingType getBlockingType() {
        return this.blockingType;
    }

    public void setBlockingType(BlockingType blockingType) {
        this.blockingType = blockingType;
    }

    public String getEnabledName() {
        return this.enabledName;
    }

    public void setEnabledName(String enabledName) {
        this.enabledName = enabledName;
    }

    public String getSelectedName() {
        return this.selectedName;
    }

    public void setSelectedName(String selectedName) {
        this.selectedName = selectedName;
    }

    DesignResourceMap getResourceMap() {
        return this.resourceMap;
    }

    void setResourceMap(DesignResourceMap resMap) {
        this.resourceMap = resMap;
    }

    boolean isAnnotationAttributeSet(String attrName) {
        if ("name".equals(attrName)) {
            return !this.id.equals(this.methodName);
        }
        Object value = this.getAnnotationAttributeValue(attrName);
        if (value instanceof BlockingType) {
            return !BlockingType.NONE.equals(value);
        }
        return value != null && !value.equals("");
    }

    boolean isAnnotationAttributeUnset(String attrName) {
        if ("name".equals(attrName)) {
            return false;
        }
        Object value = this.getAnnotationAttributeValue(attrName);
        if (value instanceof BlockingType) {
            return BlockingType.NONE.equals(value);
        }
        return value == null || value.equals("");
    }

    Object getAnnotationAttributeValue(String attrName) {
        if ("block".equals(attrName)) {
            return this.getBlockingType();
        }
        if ("enabledProperty".equals(attrName)) {
            return this.getEnabledName();
        }
        if ("name".equals(attrName)) {
            return this.id;
        }
        if ("selectedProperty".equals(attrName)) {
            return this.getSelectedName();
        }
        return null;
    }

    static String[] getAnnotationAttributeNames() {
        return ANNOTATION_ATTR_NAMES;
    }

    public String getClassPathResourceName() {
        return null;
    }

    public String getJavaInitializationCode() {
        return null;
    }

    public String getKey() {
        return null;
    }

    public Object getValue() {
        return this;
    }

    public Object getDesignValue() {
        return this;
    }

    public Object getDesignValue(Object target) {
        return null;
    }

    public String getDescription() {
        return this.id;
    }

    public Object copy(FormProperty targetFormProperty) {
        return new ProxyAction(this);
    }

    public static enum Scope {
        Application,
        Form;

    }

    public static enum BlockingType {
        NONE,
        ACTION,
        COMPONENT,
        WINDOW,
        APPLICATION;

    }
}

