/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.swingapp.ActionManager;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.IconButton;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.actions.AcceleratorKeyListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ActionPropertyEditorPanel
extends JPanel
implements HelpCtx.Provider {
    public static final String LARGE_ICON_KEY = "SwingLargeIconKey";
    private Map<ProxyAction.Scope, List<ProxyAction>> parsedActions;
    private boolean newActionCreated = false;
    private boolean actionPropertiesUpdated = false;
    private boolean viewSource = false;
    private String newMethodName = "";
    private boolean isChanging = false;
    private Map<ProxyAction.Scope, String> scopeClasses = new EnumMap<ProxyAction.Scope, String>(ProxyAction.Scope.class);
    private FileObject sourceFile;
    private String smallIconName = null;
    private String largeIconName = null;
    private ProxyAction newAction = null;
    private ProxyAction globalAction = null;
    private boolean globalMode = false;
    private ProxyAction NEW_ACTION = new ProxyAction("-newaction-", "-id-", "-methodname-");
    private FileObject selectedSourceFile;
    private AcceleratorKeyListener acceleratorListener;
    private Mode mode;
    public JTextField acceleratorText;
    private JLabel actionToEdit;
    private JComboBox actionsCombo;
    private JTextField actionsField;
    public JCheckBox altCheckbox;
    private JCheckBox backgroundTaskCheckbox;
    private JTextField blockingDialogText;
    private JTextField blockingDialogTitle;
    private JComboBox blockingType;
    private JTextField classField;
    private JButton clearAccelButton;
    public JCheckBox controlCheckbox;
    private JComboBox enabledCombo;
    private JButton iconButtonLarge;
    private JButton iconButtonSmall;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel7;
    private JTabbedPane jTabbedPane1;
    public JCheckBox metaCheckbox;
    private JTextField methodField;
    private JComboBox scopeCombo;
    private JComboBox selectedCombo;
    private JButton setIconButtonLarge;
    private JButton setIconButtonSmall;
    public JCheckBox shiftCheckbox;
    private JButton targetClassButton;
    private JTextField textField;
    private JTextField tooltipField;
    private PropertyEnv env;

    public ActionPropertyEditorPanel(FormProperty property, FileObject sourceFile) {
        this.initComponents();
        this.sourceFile = sourceFile;
        if (property == null) {
            this.globalMode = true;
        }
        this.parsedActions = new EnumMap<ProxyAction.Scope, List<ProxyAction>>(ProxyAction.Scope.class);
        Object[] vals = new Object[]{ProxyAction.BlockingType.NONE, ProxyAction.BlockingType.ACTION, ProxyAction.BlockingType.COMPONENT, ProxyAction.BlockingType.WINDOW, ProxyAction.BlockingType.APPLICATION};
        this.blockingType.setModel(new DefaultComboBoxModel<Object>(vals));
        this.blockingType.setSelectedItem((Object)ProxyAction.BlockingType.NONE);
        this.blockingType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
            }
        });
        DirtyDocumentListener dirtyListener = new DirtyDocumentListener();
        this.textField.getDocument().addDocumentListener(dirtyListener);
        this.tooltipField.getDocument().addDocumentListener(dirtyListener);
        this.acceleratorText.getDocument().addDocumentListener(dirtyListener);
        this.addPropertyChangeListener("action", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    ProxyAction act = (ProxyAction)evt.getNewValue();
                    if (!ActionPropertyEditorPanel.this.isNewActionCreated()) {
                        ActionPropertyEditorPanel.this.updateFieldsFromAction(act);
                    }
                } else {
                    ActionPropertyEditorPanel.this.clearFieldsForNull();
                }
            }
        });
        ((IconButton)this.iconButtonLarge).setIconText(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.iconButtonLarge.text"));
        ((IconButton)this.iconButtonSmall).setIconText(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.iconButtonSmall.text"));
        this.iconButtonSmall.addActionListener(new IconButtonListener(property, this.iconButtonSmall, "SmallIcon"));
        this.iconButtonLarge.addActionListener(new IconButtonListener(property, this.iconButtonLarge, LARGE_ICON_KEY));
        this.setIconButtonSmall.addActionListener(new IconButtonListener(property, this.iconButtonSmall, "SmallIcon"));
        this.setIconButtonLarge.addActionListener(new IconButtonListener(property, this.iconButtonLarge, LARGE_ICON_KEY));
        this.scopeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    ProxyAction.Scope scope = (ProxyAction.Scope)((Object)value);
                    String className = (String)ActionPropertyEditorPanel.this.scopeClasses.get((Object)scope);
                    if (className != null) {
                        ((JLabel)comp).setText(scope.toString() + ": " + className);
                    } else {
                        ((JLabel)comp).setText(scope.toString());
                    }
                }
                return comp;
            }
        });
        this.actionsCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String text = ActionPropertyEditorPanel.this.getLocalizedString("noneAction");
                if (value instanceof ProxyAction) {
                    ProxyAction act = (ProxyAction)value;
                    if (value == ActionPropertyEditorPanel.this.NEW_ACTION) {
                        text = ActionPropertyEditorPanel.this.getLocalizedString("createNewAction");
                    } else {
                        String string = text = act != null ? act.getId() : ActionPropertyEditorPanel.this.getLocalizedString("noneAction");
                        if (act != null && act.isAppWide()) {
                            text = text + ActionPropertyEditorPanel.this.getLocalizedString("globalActionAppend");
                        }
                    }
                }
                ((JLabel)comp).setText(text);
                return comp;
            }
        });
        this.setupAccelField();
        if (this.globalMode) {
            this.setMode(Mode.Global);
        } else {
            this.setMode(Mode.Form);
        }
        this.updatePropertyCombos(null);
        ActionListener modifierListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ActionPropertyEditorPanel.this.acceleratorListener.updateFromModifiers();
                ActionPropertyEditorPanel.this.updateState();
            }
        };
        this.altCheckbox.addActionListener(modifierListener);
        this.controlCheckbox.addActionListener(modifierListener);
        this.metaCheckbox.addActionListener(modifierListener);
        this.shiftCheckbox.addActionListener(modifierListener);
        this.acceleratorText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ActionPropertyEditorPanel.this.updateState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ActionPropertyEditorPanel.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ActionPropertyEditorPanel.this.updateState();
            }
        });
    }

    void updateState() {
        if (this.env != null) {
            if ("".equals(this.acceleratorText.getText()) && (this.altCheckbox.isSelected() || this.controlCheckbox.isSelected() || this.metaCheckbox.isSelected() || this.shiftCheckbox.isSelected())) {
                this.env.setState(PropertyEnv.STATE_INVALID);
            } else {
                this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
        }
    }

    private void updatePropertyCombos(ProxyAction act) {
        List<Object> strings = new ArrayList<String>();
        if (act != null) {
            FileObject classFile = ActionManager.getActionManager(this.sourceFile).getFileForClass(act.getClassname());
            strings = ActionManager.findBooleanProperties(classFile);
        } else if (this.sourceFile != null) {
            strings = ActionManager.findBooleanProperties(this.sourceFile);
        }
        strings.add(0, "");
        this.enabledCombo.setModel(new DefaultComboBoxModel<Object>(strings.toArray()));
        this.selectedCombo.setModel(new DefaultComboBoxModel<Object>(strings.toArray()));
        if (act != null) {
            if (strings.contains(act.getEnabledName())) {
                this.enabledCombo.setSelectedItem(act.getEnabledName());
            }
            if (strings.contains(act.getSelectedName())) {
                this.selectedCombo.setSelectedItem(act.getSelectedName());
            }
        }
    }

    final void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.Form) {
            this.actionToEdit.setVisible(true);
            this.actionsCombo.setVisible(true);
            this.actionsField.setVisible(false);
            this.classField.setVisible(true);
            this.classField.setEditable(false);
            this.scopeCombo.setVisible(false);
            this.targetClassButton.setVisible(false);
            this.methodField.setEditable(false);
            this.backgroundTaskCheckbox.setVisible(true);
            this.resetFields();
        }
        if (mode == Mode.NewActionForm) {
            this.newAction = new ProxyAction();
            this.actionToEdit.setVisible(true);
            this.setNewActionCreated(true);
            this.classField.setVisible(false);
            this.scopeCombo.setVisible(true);
            this.targetClassButton.setVisible(false);
        }
        if (mode == Mode.Global) {
            this.actionToEdit.setVisible(true);
            this.actionsCombo.setVisible(false);
            this.actionsField.setVisible(true);
            this.classField.setVisible(true);
            this.classField.setEditable(false);
            this.scopeCombo.setVisible(false);
            this.targetClassButton.setVisible(false);
            this.methodField.setEditable(false);
            this.backgroundTaskCheckbox.setVisible(true);
        }
        if (mode == Mode.NewActionGlobal) {
            this.newAction = new ProxyAction();
            this.actionsCombo.setVisible(false);
            this.actionsField.setVisible(false);
            this.actionToEdit.setVisible(false);
            this.setNewActionCreated(true);
            this.classField.setVisible(true);
            this.classField.setEditable(true);
            this.scopeCombo.setVisible(false);
            this.targetClassButton.setVisible(true);
            this.methodField.setEditable(true);
        }
        this.actionToEdit.setLabelFor(this.actionsField.isVisible() ? this.actionsField : this.actionsCombo);
        this.jLabel9.setLabelFor(this.classField.isVisible() ? this.classField : this.scopeCombo);
    }

    private void setAcceleratorPanelEnabled(boolean b) {
        this.acceleratorText.setEnabled(b);
        this.altCheckbox.setEnabled(b);
        this.controlCheckbox.setEnabled(b);
        this.shiftCheckbox.setEnabled(b);
        this.metaCheckbox.setEnabled(b);
    }

    private void clearAcceleratorPanel() {
        this.acceleratorText.setText("");
        this.altCheckbox.setSelected(false);
        this.controlCheckbox.setSelected(false);
        this.metaCheckbox.setSelected(false);
        this.shiftCheckbox.setSelected(false);
        this.updateState();
    }

    private void updateFieldsFromAction(ProxyAction act) {
        this.textField.setEnabled(true);
        this.tooltipField.setEnabled(true);
        this.acceleratorListener.setEnabled(true);
        this.setAcceleratorPanelEnabled(true);
        this.iconButtonLarge.setEnabled(true);
        this.setIconButtonLarge.setEnabled(true);
        this.iconButtonSmall.setEnabled(true);
        this.setIconButtonSmall.setEnabled(true);
        this.selectedCombo.setEnabled(true);
        this.enabledCombo.setEnabled(true);
        this.backgroundTaskCheckbox.setEnabled(true);
        this.updatePropertyCombos(act);
        this.setFromActionProperty(this.textField, act, "Name");
        this.setFromActionProperty(this.tooltipField, act, "ShortDescription");
        this.acceleratorListener.setCurrentKeyStroke((KeyStroke)act.getValue("AcceleratorKey"));
        StringBuilder sig = new StringBuilder();
        sig.append("@Action");
        if (act.isTaskEnabled()) {
            sig.append(" Task");
        } else {
            sig.append(" void");
        }
        sig.append(" ").append(act.getMethodName());
        sig.append("()");
        this.actionsField.setText(act.getId());
        this.classField.setText(act.getClassname());
        this.methodField.setText(sig.toString());
        this.backgroundTaskCheckbox.setSelected(act.isTaskEnabled());
        this.smallIconName = (String)act.getValue("SmallIcon.IconName");
        this.largeIconName = (String)act.getValue("SwingLargeIconKey.IconName");
        if (act.getValue("SmallIcon") != null) {
            this.iconButtonSmall.setIcon((Icon)act.getValue("SmallIcon"));
            this.iconButtonSmall.setText(null);
        } else {
            this.iconButtonSmall.setIcon(null);
            this.iconButtonSmall.setText("...");
        }
        if (act.getValue(LARGE_ICON_KEY) != null) {
            this.iconButtonLarge.setIcon((Icon)act.getValue(LARGE_ICON_KEY));
            this.iconButtonLarge.setText(null);
        } else {
            this.iconButtonLarge.setIcon(null);
            this.iconButtonLarge.setText("...");
        }
        this.blockingType.setEnabled(act.isTaskEnabled());
        this.blockingDialogText.setEnabled(act.isTaskEnabled());
        this.blockingDialogTitle.setEnabled(act.isTaskEnabled());
        if (act.isTaskEnabled()) {
            if (act.getBlockingType() != null) {
                this.blockingType.setSelectedItem((Object)act.getBlockingType());
            }
        } else {
            this.blockingType.setSelectedItem(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"BlockingTypeNone"));
        }
        this.setFromActionProperty(this.blockingDialogText, act, "BlockingDialog.message");
        this.setFromActionProperty(this.blockingDialogTitle, act, "BlockingDialog.title");
        this.selectedCombo.setSelectedItem(act.getSelectedName());
        this.enabledCombo.setSelectedItem(act.getEnabledName());
    }

    private void setFromActionProperty(JTextField textField, ProxyAction act, String key) {
        if (act.getValue(key) == null) {
            textField.setText("");
        } else {
            textField.setText("" + act.getValue(key));
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.textField = new JTextField();
        this.tooltipField = new JTextField();
        this.jLabel5 = new JLabel();
        this.iconButtonSmall = new IconButton();
        this.jLabel7 = new JLabel();
        this.jLabel4 = new JLabel();
        this.iconButtonLarge = new IconButton();
        this.jPanel7 = new JPanel();
        this.acceleratorText = new JTextField();
        this.clearAccelButton = new JButton();
        this.controlCheckbox = new JCheckBox();
        this.shiftCheckbox = new JCheckBox();
        this.altCheckbox = new JCheckBox();
        this.metaCheckbox = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.setIconButtonSmall = new JButton();
        this.setIconButtonLarge = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel8 = new JLabel();
        this.blockingType = new JComboBox();
        this.blockingDialogTitle = new JTextField();
        this.blockingDialogText = new JTextField();
        this.enabledCombo = new JComboBox();
        this.selectedCombo = new JComboBox();
        this.actionToEdit = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel17 = new JLabel();
        this.backgroundTaskCheckbox = new JCheckBox();
        this.actionsCombo = new JComboBox();
        this.methodField = new JTextField();
        this.jPanel1 = new JPanel();
        this.targetClassButton = new JButton();
        this.scopeCombo = new JComboBox();
        this.classField = new JTextField();
        this.actionsField = new JTextField();
        this.jLabel2.setLabelFor(this.textField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel2.text_1"));
        this.textField.setColumns(15);
        this.tooltipField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel5.text"));
        this.iconButtonSmall.setBackground(new Color(255, 255, 255));
        this.iconButtonSmall.setBorder(null);
        this.iconButtonSmall.setContentAreaFilled(false);
        this.iconButtonSmall.setPreferredSize(new Dimension(48, 48));
        this.jLabel7.setLabelFor(this.jPanel7);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel7.text"));
        this.jLabel4.setLabelFor(this.tooltipField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel4.text_1"));
        this.iconButtonLarge.setBackground(new Color(255, 255, 255));
        this.iconButtonLarge.setBorder(null);
        this.iconButtonLarge.setContentAreaFilled(false);
        this.iconButtonLarge.setPreferredSize(new Dimension(64, 64));
        this.jPanel7.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.acceleratorText.setColumns(5);
        Mnemonics.setLocalizedText((AbstractButton)this.clearAccelButton, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.clearAccelButton.text"));
        this.clearAccelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPropertyEditorPanel.this.clearAccelButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.controlCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox1.text"));
        this.controlCheckbox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.shiftCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox2.text"));
        this.shiftCheckbox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.altCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox3.text"));
        this.altCheckbox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.metaCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox4.text"));
        this.metaCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel13.setLabelFor(this.acceleratorText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jLabel13.text"));
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.controlCheckbox).addPreferredGap(1).add((Component)this.shiftCheckbox).addPreferredGap(0).add((Component)this.altCheckbox).addPreferredGap(0).add((Component)this.metaCheckbox)).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.acceleratorText, -2, -1, -2).addPreferredGap(0).add((Component)this.clearAccelButton))).addContainerGap(10, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel7Layout.createParallelGroup(3).add((Component)this.controlCheckbox).add((Component)this.shiftCheckbox).add((Component)this.altCheckbox).add((Component)this.metaCheckbox)).addPreferredGap(1).add((GroupLayout.Group)jPanel7Layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.acceleratorText, -2, -1, -2).add((Component)this.clearAccelButton)).addContainerGap()));
        this.acceleratorText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jLabel13.ACSD"));
        this.clearAccelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.clearAccelButton.AccessibleContext.accessibleDescription"));
        this.controlCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox1.ACSD"));
        this.shiftCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox2.ACSD"));
        this.altCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox3.ACSD"));
        this.metaCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"jCheckBox4.ACSD"));
        Mnemonics.setLocalizedText((AbstractButton)this.setIconButtonSmall, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.setIconButtonLarge, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton2.text"));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel7).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jPanel7, -1, -1, Short.MAX_VALUE).add((Component)this.tooltipField, -1, 270, Short.MAX_VALUE).add((Component)this.textField, -1, 270, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.iconButtonSmall, -2, -1, -2).add((Component)this.setIconButtonSmall)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.iconButtonLarge, -2, -1, -2).add((Component)this.setIconButtonLarge)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.textField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.tooltipField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.jPanel7, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.setIconButtonSmall).add((Component)this.jLabel5).add((Component)this.setIconButtonLarge)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.iconButtonSmall, -2, -1, -2).add((Component)this.iconButtonLarge, -2, -1, -2)).addContainerGap()));
        this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel2.ACSD"));
        this.tooltipField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel4.ACSD"));
        this.iconButtonSmall.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton1.ACSD"));
        this.iconButtonLarge.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton2.ACSD"));
        this.setIconButtonSmall.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton1.ACSD"));
        this.setIconButtonLarge.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jButton2.ACSD"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jPanel2.TabConstraints.tabTitle"), this.jPanel2);
        this.jLabel6.setLabelFor(this.blockingDialogText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel6.text"));
        this.jLabel3.setLabelFor(this.blockingDialogTitle);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel3.text_1"));
        this.jLabel1.setLabelFor(this.blockingType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel1.text_1"));
        this.jLabel11.setLabelFor(this.selectedCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel11.text"));
        this.jLabel8.setLabelFor(this.enabledCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel8.text"));
        this.blockingType.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Action", "Component", "Window", "Application"}));
        this.blockingType.setEnabled(false);
        this.blockingType.setOpaque(false);
        this.blockingDialogTitle.setEnabled(false);
        this.blockingDialogText.setEnabled(false);
        this.enabledCombo.setEditable(true);
        this.selectedCombo.setEditable(true);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel8).add((Component)this.jLabel11).add((Component)this.jLabel3).add((Component)this.jLabel6).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.blockingDialogTitle, -1, 163, Short.MAX_VALUE).add((Component)this.blockingDialogText, -1, 163, Short.MAX_VALUE).add((Component)this.enabledCombo, 0, 163, Short.MAX_VALUE).add((Component)this.selectedCombo, 0, 163, Short.MAX_VALUE).add((Component)this.blockingType, 0, 163, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.enabledCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.selectedCombo, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.blockingType, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.blockingDialogTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.blockingDialogText, -2, -1, -2)).addContainerGap(107, Short.MAX_VALUE)));
        this.blockingType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel1.ACSD"));
        this.blockingDialogTitle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel3.ACSD"));
        this.blockingDialogText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel6.ACSD"));
        this.enabledCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel8.ACSD"));
        this.selectedCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel11.ACSD"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jPanel3.TabConstraints.tabTitle"), this.jPanel3);
        Mnemonics.setLocalizedText((JLabel)this.actionToEdit, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionToEdit.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel12.text"));
        this.jLabel17.setLabelFor(this.jTabbedPane1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel17.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.backgroundTaskCheckbox, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.backgroundTaskCheckbox.text"));
        this.backgroundTaskCheckbox.setToolTipText(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.backgroundTaskCheckbox.toolTipText"));
        this.backgroundTaskCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundTaskCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPropertyEditorPanel.this.backgroundTaskCheckboxActionPerformed(evt);
            }
        });
        this.actionsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPropertyEditorPanel.this.actionsComboActionPerformed(evt);
            }
        });
        this.methodField.setColumns(24);
        Mnemonics.setLocalizedText((AbstractButton)this.targetClassButton, (String)NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.targetClassButton.text"));
        this.targetClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionPropertyEditorPanel.this.targetClassButtonActionPerformed(evt);
            }
        });
        this.classField.setColumns(10);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.classField, -1, 138, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.scopeCombo, 0, 87, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.targetClassButton)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.targetClassButton).add((Component)this.classField, -2, -1, -2).add((Component)this.scopeCombo, -2, -1, -2)));
        this.targetClassButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.targetClassButton.ACSD"));
        this.scopeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel9.ACSD"));
        this.classField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel9.ACSD"));
        this.actionsField.setColumns(10);
        this.actionsField.setEditable(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel12).add((Component)this.actionToEdit).add((Component)this.jLabel9).add((Component)this.jLabel17)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundTaskCheckbox).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.actionsCombo, -2, 200, -2).add(0, 0, 0).add((Component)this.actionsField, -1, 149, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -1, 349, Short.MAX_VALUE).add((Component)this.methodField, -1, 349, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.actionToEdit).add((Component)this.actionsCombo, -2, -1, -2).add((Component)this.actionsField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.methodField, -2, -1, -2)).addPreferredGap(0).add((Component)this.backgroundTaskCheckbox).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane1).add((Component)this.jLabel17)).addContainerGap()));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jTabbedPane1.AccessibleContext.accessibleName"));
        this.jTabbedPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jTabbedPane1.AccessibleContext.accessibleDescription"));
        this.actionsCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionsCombo.AccessibleContext.accessibleName"));
        this.actionsCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionsCombo.AccessibleContext.accessibleDescription"));
        this.methodField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.jLabel12.ACSD"));
        this.actionsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"ActionPropertyEditorPanel.actionToEdit.ACSD"));
    }

    private void clearAccelButtonActionPerformed(ActionEvent evt) {
        this.acceleratorListener.clearFields();
        this.clearAcceleratorPanel();
    }

    private void actionsComboActionPerformed(ActionEvent evt) {
        if (this.actionsCombo.getSelectedItem() == this.NEW_ACTION) {
            this.setMode(Mode.NewActionForm);
        } else if (!this.isChanging) {
            this.firePropertyChange("action", null, this.getSelectedAction());
        }
        this.updateState();
    }

    private void backgroundTaskCheckboxActionPerformed(ActionEvent evt) {
        if (this.backgroundTaskCheckbox.isVisible()) {
            this.blockingType.setEnabled(this.backgroundTaskCheckbox.isSelected());
            this.blockingDialogText.setEnabled(this.backgroundTaskCheckbox.isSelected());
            this.blockingDialogTitle.setEnabled(this.backgroundTaskCheckbox.isSelected());
        }
    }

    private void targetClassButtonActionPerformed(ActionEvent evt) {
        ClassPathFileChooser cp = new ClassPathFileChooser(this.sourceFile, new ClassPathFileChooser.Filter(){

            public boolean accept(FileObject file) {
                return true;
            }
        }, false, true);
        cp.getDialog(this.getLocalizedString("classChooserDialogTitle"), null).setVisible(true);
        if (cp.getSelectedFile() != null && cp.isConfirmed()) {
            this.selectedSourceFile = cp.getSelectedFile();
            String selectedClass = AppFrameworkSupport.getClassNameForFile(cp.getSelectedFile());
            if (selectedClass == null || AppFrameworkSupport.getFileForClass(this.sourceFile, selectedClass) == null) {
                this.classField.setText("");
            } else {
                this.classField.setText(selectedClass);
            }
        }
    }

    void setParsedActions(Map<ProxyAction.Scope, List<ProxyAction>> actionMap) {
        this.parsedActions = actionMap;
        ArrayList<ProxyAction> actions = new ArrayList<ProxyAction>();
        actions.addAll((Collection)this.parsedActions.get((Object)ProxyAction.Scope.Application));
        actions.addAll((Collection)this.parsedActions.get((Object)ProxyAction.Scope.Form));
        actions.add(this.NEW_ACTION);
        this.actionsCombo.setModel(new DefaultComboBoxModel<Object>(actions.toArray()));
        if (!this.isChanging) {
            this.firePropertyChange("action", null, this.getSelectedAction());
        }
    }

    ProxyAction getUpdatedAction() {
        ProxyAction act = this.getSelectedAction();
        act.putValue("Name", this.textField.getText());
        act.putValue("ShortDescription", this.tooltipField.getText());
        act.putValue("AcceleratorKey", this.acceleratorListener.getCurrentKeyStroke());
        if (this.backgroundTaskCheckbox.isVisible()) {
            act.setTaskEnabled(this.backgroundTaskCheckbox.isSelected());
        }
        if (act.isTaskEnabled()) {
            act.setBlockingType(this.getSelectedBlockingType());
            this.setFromTextField(this.blockingDialogText, act, "BlockingDialog.message");
            this.setFromTextField(this.blockingDialogTitle, act, "BlockingDialog.title");
        }
        act.setSelectedName((String)this.selectedCombo.getSelectedItem());
        act.setEnabledName((String)this.enabledCombo.getSelectedItem());
        act.putValue("SmallIcon.IconName", this.smallIconName);
        act.putValue("SwingLargeIconKey.IconName", this.largeIconName);
        return act;
    }

    private void setFromTextField(JTextField textField, ProxyAction act, String key) {
        String txt = textField.getText();
        if (txt != null && (txt = txt.trim()).equals("")) {
            txt = null;
        }
        act.putValue(key, txt);
    }

    private String getSelectedClassname() {
        if (this.mode == Mode.NewActionForm) {
            ProxyAction.Scope scope = (ProxyAction.Scope)((Object)this.scopeCombo.getSelectedItem());
            return this.scopeClasses.get((Object)scope);
        }
        if (this.mode == Mode.NewActionGlobal) {
            return this.classField.getText();
        }
        return null;
    }

    ProxyAction getNewAction() {
        ProxyAction act = this.newAction;
        act.setClassname(this.getSelectedClassname());
        act.setId(this.methodField.getText());
        act.setMethodName(this.methodField.getText());
        act.putValue("Name", this.textField.getText());
        act.putValue("ShortDescription", this.tooltipField.getText());
        act.setTaskEnabled(this.backgroundTaskCheckbox.isSelected());
        act.putValue("SmallIcon.IconName", this.smallIconName);
        act.putValue("SwingLargeIconKey.IconName", this.largeIconName);
        act.putValue("SmallIcon", this.iconButtonSmall.getIcon());
        act.putValue(LARGE_ICON_KEY, this.iconButtonLarge.getIcon());
        if (act.isTaskEnabled()) {
            act.setBlockingType(this.getSelectedBlockingType());
            this.setFromTextField(this.blockingDialogText, act, "BlockingDialog.message");
            this.setFromTextField(this.blockingDialogTitle, act, "BlockingDialog.title");
        }
        act.putValue("AcceleratorKey", this.acceleratorListener.getCurrentKeyStroke());
        act.setSelectedName((String)this.selectedCombo.getSelectedItem());
        act.setEnabledName((String)this.enabledCombo.getSelectedItem());
        return act;
    }

    private ProxyAction.BlockingType getSelectedBlockingType() {
        return (ProxyAction.BlockingType)((Object)this.blockingType.getSelectedItem());
    }

    ProxyAction getSelectedAction() {
        if (this.mode == Mode.NewActionGlobal) {
            return this.newAction;
        }
        if (this.globalMode) {
            return this.globalAction;
        }
        if (this.isNewActionCreated()) {
            return this.newAction;
        }
        Object action = this.actionsCombo.getSelectedItem();
        if (action instanceof ProxyAction) {
            return (ProxyAction)action;
        }
        return null;
    }

    public void updatePanel(Map<ProxyAction.Scope, List<ProxyAction>> actionMap, ProxyAction selectedAction, Map<ProxyAction.Scope, String> scopeClasses, String componentName, FileObject sourceFile) {
        ProxyAction.Scope[] scopes;
        this.isChanging = true;
        this.setParsedActions(actionMap);
        this.setSelectedAction(selectedAction);
        this.scopeClasses = scopeClasses;
        this.sourceFile = sourceFile;
        this.isChanging = false;
        if (scopeClasses.containsKey((Object)ProxyAction.Scope.Application)) {
            scopes = new ProxyAction.Scope[]{ProxyAction.Scope.Form, ProxyAction.Scope.Application};
            this.scopeCombo.setEnabled(true);
        } else {
            scopes = new ProxyAction.Scope[]{ProxyAction.Scope.Form};
            this.scopeCombo.setEnabled(false);
        }
        this.scopeCombo.setModel(new DefaultComboBoxModel<ProxyAction.Scope>(scopes));
    }

    private void setSelectedAction(ProxyAction act) {
        if (act != null) {
            if (this.globalMode) {
                this.globalAction = act;
            }
            this.setNewActionCreated(false);
            this.actionsCombo.setEnabled(true);
            for (int i = 0; i < this.actionsCombo.getModel().getSize(); ++i) {
                ProxyAction act2;
                Object o = this.actionsCombo.getModel().getElementAt(i);
                if (o == null || !(act2 = (ProxyAction)o).getId().equals(act.getId())) continue;
                this.actionsCombo.setSelectedItem(act2);
                this.actionsField.setText(act2.getId());
                break;
            }
            this.updateFieldsFromAction(act);
        } else {
            this.clearFields();
            this.clearFieldsForNull();
        }
    }

    private void clearFields() {
        this.textField.setText("");
        this.acceleratorListener.clearFields();
        this.tooltipField.setText("");
        this.newMethodName = "";
        this.iconButtonSmall.setIcon(null);
        this.iconButtonLarge.setIcon(null);
    }

    private void clearFieldsForNull() {
        this.textField.setEnabled(false);
        this.textField.setText("");
        this.tooltipField.setEnabled(false);
        this.tooltipField.setText("");
        this.acceleratorListener.setEnabled(false);
        this.setAcceleratorPanelEnabled(false);
        this.clearAcceleratorPanel();
        this.iconButtonLarge.setEnabled(false);
        this.iconButtonLarge.setIcon(null);
        this.setIconButtonLarge.setEnabled(false);
        this.iconButtonSmall.setEnabled(false);
        this.iconButtonSmall.setIcon(null);
        this.setIconButtonSmall.setEnabled(false);
        this.selectedCombo.setEnabled(false);
        this.enabledCombo.setEnabled(false);
        this.blockingDialogText.setEnabled(false);
        this.blockingDialogText.setText("");
        this.blockingDialogTitle.setEnabled(false);
        this.blockingDialogTitle.setText("");
        this.blockingType.setEnabled(false);
        this.backgroundTaskCheckbox.setEnabled(false);
        this.backgroundTaskCheckbox.setSelected(false);
    }

    private void clearFieldsForNewAction() {
        this.textField.setEnabled(true);
        this.tooltipField.setEnabled(true);
        this.acceleratorListener.setEnabled(true);
        this.setAcceleratorPanelEnabled(true);
        this.iconButtonLarge.setEnabled(true);
        this.setIconButtonLarge.setEnabled(true);
        this.iconButtonSmall.setEnabled(true);
        this.setIconButtonSmall.setEnabled(true);
        this.selectedCombo.setEnabled(true);
        this.enabledCombo.setEnabled(true);
        this.actionsCombo.setEnabled(false);
        this.textField.setText("");
        this.acceleratorListener.clearFields();
        this.tooltipField.setText("");
        this.newMethodName = "";
        this.iconButtonSmall.setIcon(null);
        this.iconButtonLarge.setIcon(null);
        this.blockingType.setEnabled(false);
        this.classField.setText("");
        this.classField.setVisible(false);
        this.methodField.setText("");
        this.methodField.setEditable(true);
        this.backgroundTaskCheckbox.setSelected(false);
        this.backgroundTaskCheckbox.setEnabled(true);
        this.backgroundTaskCheckbox.setVisible(true);
    }

    public void resetFields() {
        this.setNewActionCreated(false);
        this.viewSource = false;
        this.actionPropertiesUpdated = false;
    }

    public void setNewActionCreated(boolean newActionCreated) {
        this.newActionCreated = newActionCreated;
        if (newActionCreated) {
            this.clearFieldsForNewAction();
        } else {
            this.blockingType.setEnabled(true);
            this.actionsCombo.setEnabled(true);
        }
    }

    boolean isMethodNonEmpty() {
        this.newMethodName = this.methodField.getText();
        if (this.newMethodName == null) {
            return false;
        }
        return !this.newMethodName.trim().equals("");
    }

    boolean doesMethodContainBadChars() {
        this.newMethodName = this.methodField.getText();
        if (this.newMethodName.contains(" ")) {
            return true;
        }
        if (this.newMethodName.matches("^\\d.*")) {
            return true;
        }
        return !Utilities.isJavaIdentifier((String)this.newMethodName);
    }

    boolean isValidClassname() {
        String classname = this.getSelectedClassname();
        if (classname == null) {
            return false;
        }
        if (classname.trim().equals("")) {
            return false;
        }
        ActionManager am = ActionManager.getActionManager(this.sourceFile);
        return am.getFileForClass(classname) != null;
    }

    boolean isDuplicateMethod() {
        this.newMethodName = this.methodField.getText();
        String classname = this.getSelectedClassname();
        if (classname == null) {
            return true;
        }
        if (classname.trim().equals("")) {
            return true;
        }
        ActionManager am = ActionManager.getActionManager(this.sourceFile);
        return am.isExistingMethod(classname, this.newMethodName);
    }

    boolean canCreateNewAction() {
        this.newMethodName = this.methodField.getText();
        if (!this.isMethodNonEmpty()) {
            return false;
        }
        if (this.doesMethodContainBadChars()) {
            return false;
        }
        if (!this.isValidClassname()) {
            return false;
        }
        return !this.isDuplicateMethod();
    }

    String getNewMethodName() {
        return this.methodField.getText();
    }

    private String removeInitialSlash(String name) {
        if (name != null && name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    private void setupAccelField() {
        this.acceleratorListener = new AcceleratorKeyListener(this);
        this.acceleratorText.addKeyListener(this.acceleratorListener);
        this.acceleratorText.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.acceleratorText.setFocusTraversalKeys(1, Collections.EMPTY_SET);
    }

    public boolean isNewActionCreated() {
        return this.newActionCreated;
    }

    boolean isViewSource() {
        return this.viewSource;
    }

    boolean isActionPropertiesUpdated() {
        boolean task_changed = false;
        boolean accel_changed = false;
        if (this.getSelectedAction() != null) {
            if (this.getSelectedAction().isTaskEnabled() != this.backgroundTaskCheckbox.isSelected()) {
                task_changed = true;
            }
            if (this.acceleratorListener.getCurrentKeyStroke() == null && this.getSelectedAction().getValue() != null) {
                accel_changed = true;
            } else if (!this.acceleratorListener.getCurrentKeyStroke().equals(this.getSelectedAction().getValue("AcceleratorKey"))) {
                accel_changed = true;
            }
        }
        return this.actionPropertiesUpdated || task_changed || accel_changed;
    }

    public FileObject getSelectedSourceFile() {
        return this.selectedSourceFile;
    }

    private String getLocalizedString(String key) {
        return NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)("ActionPropertyEditorPanel." + key));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass().getName());
    }

    protected void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    private class IconButtonListener
    implements ActionListener {
        private FormProperty property;
        private JButton iconButton;
        private String iconKey;

        public IconButtonListener(FormProperty property, JButton iconButton, String iconKey) {
            this.property = property;
            this.iconButton = iconButton;
            this.iconKey = iconKey;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProxyAction action = ActionPropertyEditorPanel.this.getSelectedAction();
            IconEditor iconEditor = new IconEditor();
            iconEditor.setExternalIconsAllowed(false);
            if (ActionPropertyEditorPanel.this.sourceFile.isFolder()) {
                ActionPropertyEditorPanel.this.sourceFile = ActionManager.getActionManager(ActionPropertyEditorPanel.this.sourceFile).getApplicationClassFile();
            }
            iconEditor.setSourceFile(ActionPropertyEditorPanel.this.sourceFile);
            if ("SmallIcon".equals(this.iconKey)) {
                if (ActionPropertyEditorPanel.this.smallIconName != null) {
                    iconEditor.setAsText(ActionPropertyEditorPanel.this.removeInitialSlash(ActionPropertyEditorPanel.this.smallIconName));
                }
            } else if (ActionPropertyEditorPanel.this.largeIconName != null) {
                iconEditor.setAsText(ActionPropertyEditorPanel.this.removeInitialSlash(ActionPropertyEditorPanel.this.largeIconName));
            }
            DialogDescriptor dd = new DialogDescriptor((Object)iconEditor.getCustomEditor(), NbBundle.getMessage(ActionPropertyEditorPanel.class, (String)"CTL_SelectIcon_Title"));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                String iconName;
                IconEditor.NbImageIcon nbIcon = (IconEditor.NbImageIcon)iconEditor.getValue();
                Icon icon = nbIcon != null ? nbIcon.getIcon() : null;
                this.iconButton.setIcon(icon);
                this.iconButton.setText(icon == null ? "..." : null);
                action.putValue(this.iconKey, icon);
                String string = iconName = nbIcon != null ? nbIcon.getName() : null;
                if (iconName != null && !iconName.startsWith("/")) {
                    iconName = "/" + iconName;
                }
                if ("SmallIcon".equals(this.iconKey)) {
                    ActionPropertyEditorPanel.this.smallIconName = iconName;
                } else {
                    ActionPropertyEditorPanel.this.largeIconName = iconName;
                }
                action.putValue(this.iconKey + ".IconName", iconName);
                ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
            }
        }
    }

    private class DirtyDocumentListener
    implements DocumentListener {
        private DirtyDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ActionPropertyEditorPanel.this.actionPropertiesUpdated = true;
        }
    }

    static enum Mode {
        Form,
        NewActionForm,
        Global,
        NewActionGlobal;

    }
}

