/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.netbeans.insane.live.LiveReferences;
import org.netbeans.insane.live.Path;
import org.netbeans.insane.scanner.CountingVisitor;
import org.netbeans.insane.scanner.ScannerUtils;
import org.netbeans.insane.scanner.Visitor;
import org.netbeans.junit.AssertionFailedErrorException;
import org.netbeans.junit.AssertionFileFailedError;
import org.netbeans.junit.AssertionKnownBugError;
import org.netbeans.junit.Filter;
import org.netbeans.junit.Log;
import org.netbeans.junit.Manager;
import org.netbeans.junit.MemoryFilter;
import org.netbeans.junit.NbTest;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.junit.RandomlyFails;
import org.netbeans.junit.diff.Diff;
import org.netbeans.junit.internal.MemoryPreferencesFactory;
import org.netbeans.junit.internal.NbModuleLogHandler;

public abstract class NbTestCase
extends TestCase
implements NbTest {
    private Filter filter;
    private long time;
    private String workDirPath;
    private static Set<String> usedPaths = new HashSet<String>();
    private String lastTestMethod = null;
    private final Map<String, PrintStream> logStreamTable = new HashMap<String, PrintStream>();
    PrintStream systemOutPSWrapper = new PrintStream(System.out);
    private static final int radix = 16;

    public NbTestCase(String name) {
        super(name);
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String getExpectedFail() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getExpectedFail(this.getName());
    }

    @Override
    public boolean canRun() {
        if (NbTestSuite.ignoreRandomFailures()) {
            if (this.getClass().isAnnotationPresent(RandomlyFails.class)) {
                System.err.println("Skipping " + this.getClass().getName());
                return false;
            }
            try {
                if (this.getClass().getMethod(this.getName(), new Class[0]).isAnnotationPresent(RandomlyFails.class)) {
                    System.err.println("Skipping " + this.getClass().getName() + "." + this.getName());
                    return false;
                }
            }
            catch (NoSuchMethodException x) {
                // empty catch block
            }
        }
        if (null == this.filter) {
            return true;
        }
        boolean isIncluded = this.filter.isIncluded(this.getName());
        return isIncluded;
    }

    protected boolean runInEQ() {
        return false;
    }

    protected int timeOut() {
        return 0;
    }

    protected Level logLevel() {
        return null;
    }

    protected String logRoot() {
        return "";
    }

    public void run(TestResult result) {
        if (this.canRun()) {
            System.setProperty("netbeans.full.hack", "true");
            System.setProperty("java.util.prefs.PreferencesFactory", MemoryPreferencesFactory.class.getName());
            try {
                Preferences.userRoot().sync();
            }
            catch (BackingStoreException bex) {
                // empty catch block
            }
            Level lev = this.logLevel();
            if (lev != null) {
                Log.configure(lev, this.logRoot(), this);
            }
            super.run(result);
        }
    }

    private static void appendThread(StringBuffer sb, String indent, Thread t, Map<Thread, StackTraceElement[]> data) {
        sb.append(indent).append("Thread ").append(t.getName()).append('\n');
        indent = indent.concat("  ");
        for (StackTraceElement e : data.get(t)) {
            sb.append("\tat ").append(e.getClassName()).append('.').append(e.getMethodName()).append('(').append(e.getFileName()).append(':').append(e.getLineNumber()).append(")\n");
        }
    }

    private static void appendGroup(StringBuffer sb, String indent, ThreadGroup tg, Map<Thread, StackTraceElement[]> data) {
        sb.append(indent).append("Group ").append(tg.getName()).append('\n');
        indent = indent.concat("  ");
        int groups = tg.activeGroupCount();
        ThreadGroup[] chg = new ThreadGroup[groups];
        tg.enumerate(chg, false);
        for (ThreadGroup inner : chg) {
            if (inner == null) continue;
            NbTestCase.appendGroup(sb, indent, inner, data);
        }
        int threads = tg.activeCount();
        Thread[] cht = new Thread[threads];
        tg.enumerate(cht, false);
        for (Thread t : cht) {
            if (t == null) continue;
            NbTestCase.appendThread(sb, indent, t, data);
        }
    }

    private static String threadDump() {
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        StringBuffer sb = new StringBuffer();
        NbTestCase.appendGroup(sb, "", root, all);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        block11: {
            block10: {
                abstract class Guard
                implements Runnable {
                    private boolean finished;
                    private Throwable t;

                    Guard() {
                    }

                    public abstract void doSomething() throws Throwable;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.doSomething();
                        }
                        catch (Throwable thrwn) {
                            this.t = Log.wrapWithMessages(thrwn);
                        }
                        finally {
                            Guard guard = this;
                            synchronized (guard) {
                                this.finished = true;
                                this.notifyAll();
                            }
                        }
                    }

                    public synchronized void waitFinished() throws Throwable {
                        this.waitFinished(0);
                    }

                    public synchronized void waitFinished(int timeout) throws Throwable {
                        long time = timeout;
                        long startTime = System.currentTimeMillis();
                        while (!this.finished) {
                            try {
                                this.wait(time);
                                if (timeout <= 0 || (time = (long)timeout - (System.currentTimeMillis() - startTime)) >= 1L) continue;
                                break;
                            }
                            catch (InterruptedException ex) {
                                if (this.t != null) continue;
                                this.t = ex;
                            }
                        }
                        if (this.t != null) {
                            throw this.t;
                        }
                        if (!this.finished) {
                            throw Log.wrapWithMessages(new AssertionFailedError("The test " + NbTestCase.this.getName() + " did not finish in " + timeout + "ms\n" + NbTestCase.threadDump()));
                        }
                    }
                }
                if (this.runInEQ()) {
                    Guard setUp = new Guard(){
                        {
                        }

                        @Override
                        public void doSomething() throws Throwable {
                            NbTestCase.this.setUp();
                        }
                    };
                    EventQueue.invokeLater(setUp);
                    setUp.waitFinished(this.timeOut());
                } else {
                    this.setUp();
                }
                try {
                    Guard runTest = new Guard(){
                        {
                        }

                        @Override
                        public void doSomething() throws Throwable {
                            long now = System.nanoTime();
                            try {
                                NbTestCase.this.runTest();
                            }
                            catch (Throwable t) {
                                NbTestCase.this.noteWorkDir(NbTestCase.this.workdirNoCreate());
                                throw NbTestCase.this.noteRandomness(t);
                            }
                            finally {
                                long last = System.nanoTime() - now;
                                if (last < 1L) {
                                    last = 1L;
                                }
                                NbTestCase.this.time = last;
                            }
                        }
                    };
                    if (this.runInEQ()) {
                        EventQueue.invokeLater(runTest);
                        runTest.waitFinished(this.timeOut());
                    } else if (this.timeOut() == 0) {
                        runTest.run();
                        runTest.waitFinished();
                    } else {
                        Thread watchDog = new Thread((Runnable)runTest, "Test Watch Dog: " + this.getName());
                        watchDog.start();
                        runTest.waitFinished(this.timeOut());
                    }
                    if (!this.runInEQ()) break block10;
                }
                catch (Throwable throwable) {
                    if (this.runInEQ()) {
                        Guard tearDown = new Guard(){
                            {
                            }

                            @Override
                            public void doSomething() throws Throwable {
                                NbTestCase.this.tearDown();
                            }
                        };
                        EventQueue.invokeLater(tearDown);
                        tearDown.waitFinished(this.timeOut());
                    } else {
                        this.tearDown();
                    }
                    throw throwable;
                }
                Guard tearDown = new /* invalid duplicate definition of identical inner class */;
                EventQueue.invokeLater(tearDown);
                tearDown.waitFinished(this.timeOut());
                break block11;
            }
            this.tearDown();
        }
    }

    private void noteWorkDir(File wd) {
        if (!wd.isDirectory()) {
            return;
        }
        try {
            String buildURL = System.getenv("BUILD_URL");
            if (buildURL != null) {
                String path;
                String workspace = new File(System.getenv("WORKSPACE")).getCanonicalPath();
                if (!workspace.endsWith(File.separator)) {
                    workspace = workspace + File.separator;
                }
                if ((path = wd.getCanonicalPath()).startsWith(workspace)) {
                    NbTestCase.copytree(wd, new File(wd.getParentFile(), wd.getName() + "-FAILED"));
                    System.err.println("Working directory: " + buildURL + "artifact/" + path.substring(workspace.length()).replace(File.separatorChar, '/') + "-FAILED/");
                    return;
                }
            }
            System.err.println("Working directory: " + wd);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copytree(File from, File to) throws IOException {
        if (from.isDirectory()) {
            if (!to.mkdirs()) {
                throw new IOException("mkdir: " + to);
            }
            for (File f : from.listFiles()) {
                NbTestCase.copytree(f, new File(to, f.getName()));
            }
        } else {
            FileInputStream is = new FileInputStream(from);
            try {
                FileOutputStream os = new FileOutputStream(to);
                try {
                    int c;
                    BufferedInputStream bis = new BufferedInputStream(is);
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    while ((c = bis.read()) != -1) {
                        bos.write(c);
                    }
                    bos.flush();
                    bos.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    private Throwable noteRandomness(Throwable t) {
        Class<?> c = this.getClass();
        if (c.isAnnotationPresent(RandomlyFails.class)) {
            return Log.wrapWithAddendum(t, "(" + c.getSimpleName() + " marked @RandomlyFails so try just running test again)", false);
        }
        try {
            if (c.getMethod(this.getName(), new Class[0]).isAnnotationPresent(RandomlyFails.class)) {
                return Log.wrapWithAddendum(t, "(" + c.getSimpleName() + "." + this.getName() + " marked @RandomlyFails so try just running test again)", false);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return t;
    }

    protected final int getTestNumber() {
        try {
            Matcher m = Pattern.compile("test[a-zA-Z]*([0-9]+)").matcher(this.getName());
            NbTestCase.assertTrue((String)("Name does not contain numbers: " + this.getName()), (boolean)m.find());
            return Integer.valueOf(m.group(1));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            NbTestCase.fail((String)("Name: " + this.getName() + " does not represent number"));
            return 0;
        }
    }

    final long getExecutionTime() {
        return this.time;
    }

    public static void assertFile(String message, String test, String pass, String diff, Diff externalDiff) {
        Diff diffImpl = null == externalDiff ? Manager.getSystemDiff() : externalDiff;
        File diffFile = NbTestCase.getDiffName(pass, null == diff ? null : new File(diff));
        if (null == diffImpl) {
            NbTestCase.fail((String)"diff is not available");
        } else {
            try {
                if (null == diffFile) {
                    if (diffImpl.diff(test, pass, null)) {
                        throw new AssertionFileFailedError(message, "");
                    }
                } else if (diffImpl.diff(test, pass, diffFile.getAbsolutePath())) {
                    throw new AssertionFileFailedError(message, diffFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                NbTestCase.fail((String)("exception in assertFile : " + e.getMessage()));
            }
        }
    }

    public static void assertFile(String test, String pass, String diff, Diff externalDiff) {
        NbTestCase.assertFile(null, test, pass, diff, externalDiff);
    }

    public static void assertFile(String message, String test, String pass, String diff) {
        NbTestCase.assertFile(message, test, pass, diff, null);
    }

    public static void assertFile(String test, String pass, String diff) {
        NbTestCase.assertFile(null, test, pass, diff, null);
    }

    public static void assertFile(String test, String pass) {
        NbTestCase.assertFile(null, test, pass, null, null);
    }

    public static void assertFile(String message, File test, File pass, File diff, Diff externalDiff) {
        Diff diffImpl = null == externalDiff ? Manager.getSystemDiff() : externalDiff;
        File diffFile = NbTestCase.getDiffName(pass.getAbsolutePath(), diff);
        if (null == diffImpl) {
            NbTestCase.fail((String)"diff is not available");
        } else {
            try {
                if (diffImpl.diff(test, pass, diffFile)) {
                    throw new AssertionFileFailedError(message, null == diffFile ? "" : diffFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                NbTestCase.fail((String)("exception in assertFile : " + e.getMessage()));
            }
        }
    }

    public static void assertFile(File test, File pass, File diff, Diff externalDiff) {
        NbTestCase.assertFile(null, test, pass, diff, externalDiff);
    }

    public static void assertFile(String message, File test, File pass, File diff) {
        NbTestCase.assertFile(message, test, pass, diff, null);
    }

    public static void assertFile(File test, File pass, File diff) {
        NbTestCase.assertFile(null, test, pass, diff, null);
    }

    public static void assertFile(File test, File pass) {
        NbTestCase.assertFile("Difference between " + test + " and " + pass, test, pass, null, null);
    }

    private static File getDiffName(String pass, File diff) {
        if (null == diff) {
            return null;
        }
        if (!diff.exists() || diff.isFile()) {
            return diff;
        }
        StringBuilder d = new StringBuilder();
        d.append(diff.getAbsolutePath());
        int i1 = pass.lastIndexOf(92);
        int i2 = pass.lastIndexOf(47);
        i1 = i1 > i2 ? i1 : i2;
        i1 = -1 == i1 ? 0 : i1 + 1;
        i2 = pass.lastIndexOf(46);
        int n = i2 = -1 == i2 ? pass.length() : i2;
        if (0 < d.length()) {
            d.append("/");
        }
        d.append(pass.substring(i1, i2));
        d.append(".diff");
        return new File(d.toString());
    }

    public String getWorkDirPath() {
        String realP;
        int tooLong;
        int len3;
        String clazz;
        int len2;
        int len1;
        if (this.workDirPath != null) {
            return this.workDirPath;
        }
        String name = this.getName();
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            char[] ntfsIllegal = new char[]{'\"', '/', '\\', '?', '<', '>', '|', ':'};
            for (int i = 0; i < ntfsIllegal.length; ++i) {
                name = name.replace(ntfsIllegal[i], '~');
            }
        }
        if ((len1 = Manager.getWorkDirPath().length()) + (len2 = (clazz = this.getClass().getName()).length()) + (len3 = name.length()) > (tooLong = Integer.getInteger("nbjunit.too.long", 100).intValue())) {
            clazz = NbTestCase.abbrevDots(clazz);
            len2 = clazz.length();
        }
        if (len1 + len2 + len3 > tooLong) {
            name = NbTestCase.abbrevCapitals(name);
        }
        String p = Manager.getWorkDirPath() + File.separator + clazz + File.separator + name;
        int i = 0;
        while (true) {
            String string = realP = i == 0 ? p : p + "-" + i;
            if (usedPaths.add(realP)) break;
            ++i;
        }
        this.workDirPath = realP;
        return realP;
    }

    private static String abbrevDots(String dotted) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String item : dotted.split("\\.")) {
            sb.append(sep);
            sb.append(item.charAt(0));
            sep = ".";
        }
        return sb.toString();
    }

    private static String abbrevCapitals(String name) {
        if (name.startsWith("test")) {
            name = name.substring(4);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        return sb.toString();
    }

    private File workdirNoCreate() {
        return Manager.normalizeFile(new File(this.getWorkDirPath()));
    }

    public File getWorkDir() throws IOException {
        File workdir = this.workdirNoCreate();
        if (workdir.exists()) {
            if (!workdir.isDirectory()) {
                throw new IOException("workdir exists, but is not a directory, workdir = " + workdir);
            }
            return workdir;
        }
        boolean result = workdir.mkdirs();
        if (!result) {
            throw new IOException("workdir creation failed: " + workdir);
        }
        return workdir;
    }

    private static void deleteFile(File file) throws IOException {
        boolean result;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                NbTestCase.deleteFile(files[i]);
            }
        }
        if (!(result = file.delete())) {
            throw new IOException("Cannot delete file, file = " + file.getPath());
        }
    }

    static void deleteSubFiles(File file) throws IOException {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                NbTestCase.deleteFile(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWorkDir() throws IOException {
        Map<String, PrintStream> map = this.logStreamTable;
        synchronized (map) {
            File workdir = this.getWorkDir();
            this.closeAllStreams();
            NbTestCase.deleteSubFiles(workdir);
        }
    }

    private boolean hasTestMethodChanged() {
        if (!this.getName().equals(this.lastTestMethod)) {
            this.lastTestMethod = this.getName();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getFileLog(String logName) throws IOException {
        Map<String, PrintStream> map = this.logStreamTable;
        synchronized (map) {
            if (this.hasTestMethodChanged()) {
                this.closeAllStreams();
            } else if (this.logStreamTable.containsKey(logName)) {
                return this.logStreamTable.get(logName);
            }
            WFOS fileLog = new WFOS(new File(this.getWorkDir(), logName));
            PrintStream printStreamLog = new PrintStream(fileLog, true);
            this.logStreamTable.put(logName, printStreamLog);
            return printStreamLog;
        }
    }

    private void closeAllStreams() {
        for (PrintStream ps : this.logStreamTable.values()) {
            ps.close();
        }
        this.logStreamTable.clear();
    }

    public PrintStream getLog(String logName) {
        try {
            return this.getFileLog(logName);
        }
        catch (IOException ioe) {
            return this.systemOutPSWrapper;
        }
    }

    public PrintStream getLog() {
        return this.getLog(this.getName() + ".log");
    }

    public void log(String message) {
        this.getLog().println(message);
    }

    public void log(String log, String message) {
        this.getLog(log).println(message);
    }

    public PrintStream getRef() {
        String refFilename = this.getName() + ".ref";
        try {
            return this.getFileLog(refFilename);
        }
        catch (IOException ioe) {
            NbTestCase.fail((String)("Could not open reference file: " + refFilename));
            return this.systemOutPSWrapper;
        }
    }

    public void ref(String message) {
        this.getRef().println(message);
    }

    public File getGoldenFile(String filename) {
        String fullClassName = this.getClass().getName();
        String goldenFileName = fullClassName.replace('.', '/') + "/" + filename;
        File goldenFile = new File(this.getDataDir() + "/goldenfiles/" + goldenFileName);
        if (goldenFile.exists()) {
            return goldenFile;
        }
        String className = fullClassName;
        int lastDot = fullClassName.lastIndexOf(46);
        if (lastDot != -1) {
            className = fullClassName.substring(lastDot + 1);
        }
        goldenFileName = className + "/" + filename;
        URL url = this.getClass().getResource("data/goldenfiles/" + goldenFileName);
        NbTestCase.assertNotNull((String)("Golden file not found in any of the following locations:\n  " + goldenFile + "\n  " + "src/" + fullClassName.replace('.', '/').substring(0, fullClassName.indexOf(className)) + "data/goldenfiles/" + goldenFileName), (Object)url);
        String resString = NbTestCase.convertNBFSURL(url);
        goldenFile = new File(resString);
        return goldenFile;
    }

    public File getDataDir() {
        File dataDir;
        String xtestData = System.getProperty("xtest.data");
        if (xtestData != null) {
            return Manager.normalizeFile(new File(xtestData));
        }
        URL codebase = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        if (!codebase.getProtocol().equals("file")) {
            throw new Error("Cannot find data directory from " + codebase);
        }
        try {
            dataDir = new File(new File(codebase.toURI()).getParentFile(), "data");
        }
        catch (URISyntaxException x) {
            throw new Error(x);
        }
        return Manager.normalizeFile(dataDir);
    }

    public File getGoldenFile() {
        return this.getGoldenFile(this.getName() + ".pass");
    }

    public void compareReferenceFiles(String testFilename, String goldenFilename, String diffFilename) {
        try {
            if (!this.getRef().equals(this.systemOutPSWrapper)) {
                this.getRef().flush();
                this.getRef().close();
            }
            File goldenFile = this.getGoldenFile(goldenFilename);
            File testFile = new File(this.getWorkDir(), testFilename);
            File diffFile = new File(this.getWorkDir(), diffFilename);
            String message = "Files differ";
            if (System.getProperty("xtest.home") == null) {
                message = message + "; check " + diffFile;
            }
            NbTestCase.assertFile(message, testFile, goldenFile, diffFile);
        }
        catch (IOException ioe) {
            NbTestCase.fail((String)"Could not obtain working direcory");
        }
    }

    public void compareReferenceFiles() {
        this.compareReferenceFiles(this.getName() + ".ref", this.getName() + ".pass", this.getName() + ".diff");
    }

    @Deprecated
    public static String convertNBFSURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Given URL should not be null.");
        }
        String externalForm = url.toExternalForm();
        if (externalForm.startsWith("nbfs://")) {
            return NbTestCase.convertNewNBFSURL(url);
        }
        return NbTestCase.convertOldNBFSURL(url);
    }

    private static String convertNewNBFSURL(URL url) {
        String externalForm = url.toExternalForm();
        String path = externalForm.startsWith("nbfs://nbhost/") ? url.getPath().substring(1) : externalForm.substring("nbfs://".length());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = path.length();
        while (i < len) {
            char ch;
            if ((ch = path.charAt(i++)) == '%' && i + 1 < len) {
                char h1 = path.charAt(i++);
                char h2 = path.charAt(i++);
                ch = (char)Integer.parseInt("" + h1 + h2, 16);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String convertOldNBFSURL(URL url) {
        String path = url.getFile();
        if (url.getProtocol().equals("nbfs")) {
            String prefixFS = "FileSystem ";
            if (path.indexOf(prefixFS) > -1) {
                path = path.substring(path.indexOf(prefixFS) + prefixFS.length());
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            int len = path.length();
            block6: while (i < len) {
                char ch;
                if ((ch = path.charAt(i++)) == 'Q' && i < len) {
                    ch = path.charAt(i++);
                    switch (ch) {
                        case 'B': {
                            sb.append('/');
                            continue block6;
                        }
                        case 'C': {
                            sb.append(':');
                            continue block6;
                        }
                        case 'D': {
                            sb.append('\\');
                            continue block6;
                        }
                        case 'E': {
                            sb.append('#');
                            continue block6;
                        }
                    }
                    sb.append('Q');
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            path = sb.toString();
        }
        return path;
    }

    public static void assertGC(String text, Reference<?> ref) {
        NbTestCase.assertGC(text, ref, Collections.emptySet());
    }

    public static void assertGC(final String text, final Reference<?> ref, final Set<?> rootsHint) {
        NbModuleLogHandler.whileIgnoringOOME(new Runnable(){

            @Override
            public void run() {
                ArrayList<byte[]> alloc = new ArrayList<byte[]>();
                int size = 100000;
                for (int i = 0; i < 50; ++i) {
                    if (ref.get() == null) {
                        return;
                    }
                    try {
                        System.gc();
                    }
                    catch (OutOfMemoryError error) {
                        // empty catch block
                    }
                    try {
                        System.runFinalization();
                    }
                    catch (OutOfMemoryError error) {
                        // empty catch block
                    }
                    try {
                        alloc.add(new byte[size]);
                        size = (int)((double)size * 1.3);
                    }
                    catch (OutOfMemoryError error) {
                        size /= 2;
                    }
                    try {
                        if (i % 3 != 0) continue;
                        Thread.sleep(321L);
                        continue;
                    }
                    catch (InterruptedException t) {
                        // empty catch block
                    }
                }
                alloc = null;
                String str = null;
                try {
                    str = NbTestCase.findRefsFromRoot(ref.get(), rootsHint);
                }
                catch (Exception e) {
                    throw new AssertionFailedErrorException(e);
                }
                catch (OutOfMemoryError err) {
                    // empty catch block
                }
                Assert.fail((String)(text + ":\n" + str));
            }
        });
    }

    public static void assertSize(String message, int limit, Object root) {
        NbTestCase.assertSize(message, Arrays.asList(root), limit);
    }

    public static void assertSize(String message, Collection<?> roots, int limit) {
        NbTestCase.assertSize(message, roots, limit, new Object[0]);
    }

    public static void assertSize(String message, Collection<?> roots, int limit, Object[] skip) {
        org.netbeans.insane.scanner.Filter f = ScannerUtils.skipObjectsFilter(Arrays.asList(skip), (boolean)false);
        NbTestCase.assertSize(message, roots, limit, f);
    }

    public static int assertSize(String message, Collection<?> roots, int limit, final MemoryFilter skip) {
        org.netbeans.insane.scanner.Filter f = new org.netbeans.insane.scanner.Filter(){

            public boolean accept(Object o, Object refFrom, Field ref) {
                return !skip.reject(o);
            }
        };
        return NbTestCase.assertSize(message, roots, limit, f);
    }

    private static int assertSize(String message, Collection<?> roots, int limit, org.netbeans.insane.scanner.Filter f) {
        try {
            final CountingVisitor counter = new CountingVisitor();
            ScannerUtils.scan((org.netbeans.insane.scanner.Filter)f, (Visitor)counter, roots, (boolean)false);
            int sum = counter.getTotalSize();
            if (sum > limit) {
                StringBuilder sb = new StringBuilder(4096);
                sb.append(message);
                sb.append(": leak ").append(sum - limit).append(" bytes ");
                sb.append(" over limit of ");
                sb.append(limit).append(" bytes");
                TreeSet classes = new TreeSet(new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class<?> c1, Class<?> c2) {
                        int r = counter.getSizeForClass(c2) - counter.getSizeForClass(c1);
                        return r != 0 ? r : c1.hashCode() - c2.hashCode();
                    }
                });
                classes.addAll(counter.getClasses());
                for (Class cls : classes) {
                    if (counter.getCountForClass(cls) == 0) continue;
                    sb.append("\n  ").append(cls.getName()).append(": ").append(counter.getCountForClass(cls)).append(", ").append(counter.getSizeForClass(cls)).append("B");
                }
                NbTestCase.fail((String)sb.toString());
            }
            return sum;
        }
        catch (Exception e) {
            throw new AssertionFailedErrorException("Could not traverse reference graph", e);
        }
    }

    public static void failByBug(int bugID) {
        throw new AssertionKnownBugError(bugID);
    }

    public static void failByBug(int bugID, String message) {
        throw new AssertionKnownBugError(bugID, message);
    }

    private static String findRefsFromRoot(Object target, Set<?> rootsHint) throws Exception {
        Map m;
        Path p;
        int count = Integer.getInteger("assertgc.paths", 1);
        StringBuilder sb = new StringBuilder();
        final IdentityHashMap<Object, Object> skip = new IdentityHashMap<Object, Object>();
        org.netbeans.insane.scanner.Filter knownPath = new org.netbeans.insane.scanner.Filter(){

            public boolean accept(Object obj, Object referredFrom, Field reference) {
                return !skip.containsKey(obj);
            }
        };
        while (count-- > 0 && (p = (Path)(m = LiveReferences.fromRoots(Collections.singleton(target), rootsHint, null, (org.netbeans.insane.scanner.Filter)knownPath)).get(target)) != null) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(p);
            while (p != null) {
                Object o = p.getObject();
                if (o != target) {
                    skip.put(o, null);
                }
                p = p.nextNode();
            }
        }
        return sb.length() > 0 ? sb.toString() : "Not found!!!";
    }

    private static class WFOS
    extends FilterOutputStream {
        private File f;
        private int bytes;

        public WFOS(File f) throws FileNotFoundException {
            super(new FileOutputStream(f));
            this.f = f;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.add(len);
            this.out.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.add(b.length);
            this.out.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.add(1);
            this.out.write(b);
        }

        private synchronized void add(int i) throws IOException {
            this.bytes += i;
            if ((long)this.bytes >= 0x100000L) {
                this.out.close();
                File trim = new File(this.f.getParent(), "TRIMMED_" + this.f.getName());
                trim.delete();
                this.f.renameTo(trim);
                this.f.delete();
                this.out = new FileOutputStream(this.f);
                this.bytes = 0;
            }
        }
    }
}

