/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.AcceptSupport;
import org.openide.util.ImageUtilities;

public abstract class AddActionItem
extends AbstractAction {
    public static final String TYPEID_KEY = "typeID";
    private static Map<ComponentProducer, AddActionItem> instances = new WeakHashMap<ComponentProducer, AddActionItem>();
    private ImageIcon icon;

    public static final AddActionItem getInstance(DesignComponent component, ComponentProducer producer) {
        AddActionItem action = instances.get(producer);
        if (action != null) {
            action.resolveAction(component);
            return action;
        }
        action = AddActionItem.create(component, producer);
        instances.put(producer, action);
        return action;
    }

    protected AddActionItem(TypeID typeID) {
        this.putValue(TYPEID_KEY, typeID);
    }

    private AddActionItem(TypeID typeID, DesignComponent component, ComponentProducer producer) {
        String smallIcon = producer.getPaletteDescriptor().getSmallIcon();
        Image image = smallIcon != null ? ImageUtilities.loadImage((String)smallIcon) : null;
        this.putValue(TYPEID_KEY, typeID);
        this.putValue("Name", producer.getPaletteDescriptor().getDisplayName());
        if (image != null) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }
        this.resolveAction(component);
    }

    public abstract void resolveAction(DesignComponent var1);

    private static AddActionItem create(DesignComponent component, final ComponentProducer producer) {
        return new AddActionItem(producer.getMainComponentTypeID(), component, producer){
            private WeakReference<DesignComponent> component;
            private DesignComponent selectedComponent;

            @Override
            public synchronized void actionPerformed(ActionEvent e) {
                if (producer == null) {
                    throw new IllegalArgumentException("Null argument typeID");
                }
                final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        ComponentProducer.Result result = AcceptSupport.accept((DesignComponent)component.get(), producer, null);
                        selectedComponent = result.getMainComponent();
                    }
                });
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        document.setSelectedComponents(null, Collections.singleton(selectedComponent));
                        selectedComponent = null;
                    }
                });
            }

            @Override
            public void resolveAction(DesignComponent component) {
                this.component = new WeakReference<DesignComponent>(component);
            }
        };
    }
}

