/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.openide.util.WeakSet;

public final class ActiveDocumentSupport {
    private static final DesignEventFilter FILTER_SELECTION = new DesignEventFilter(new DesignEventFilter[0]).setSelection(true);
    private static final ActiveDocumentSupport support = new ActiveDocumentSupport();
    private final WeakSet<Listener> listeners = new WeakSet();
    private DesignDocument activeDocument = null;
    private DesignListener selectionListener = null;
    private Collection<DesignComponent> activeComponents = Collections.emptySet();

    private ActiveDocumentSupport() {
    }

    public static ActiveDocumentSupport getDefault() {
        return support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveDocumentListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveDocumentListener(Listener listener) {
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            this.listeners.remove((Object)listener);
        }
    }

    @Deprecated
    public DesignDocument getActiveDocument() {
        return this.activeDocument;
    }

    public Collection<DesignComponent> getActiveComponents() {
        return this.activeComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActiveDocumentChanged(DesignDocument deactivatedDocument, final DesignDocument activatedDocument) {
        Listener[] Listeners;
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            Listeners = (Listener[])this.listeners.toArray((Object[])new Listener[this.listeners.size()]);
        }
        for (Listener listener : Listeners) {
            if (listener == null) continue;
            listener.activeDocumentChanged(deactivatedDocument, activatedDocument);
        }
        if (deactivatedDocument != activatedDocument) {
            if (deactivatedDocument != null) {
                if (this.selectionListener == null) {
                    Debug.warning("SelectionListener does not exist but it should");
                } else {
                    deactivatedDocument.getListenerManager().removeDesignListener(this.selectionListener);
                }
            }
            if (activatedDocument != null) {
                activatedDocument.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        activatedDocument.getListenerManager().addDesignListener(ActiveDocumentSupport.this.selectionListener = new SelectionDesignListener(activatedDocument), FILTER_SELECTION);
                        ActiveDocumentSupport.this.fireActiveComponentsChanged(activatedDocument.getSelectedComponents());
                    }
                });
            } else {
                this.fireActiveComponentsChanged(Collections.<DesignComponent>emptyList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActiveComponentsChanged(Collection<DesignComponent> activeComponents) {
        Listener[] Listeners;
        this.activeComponents = activeComponents;
        WeakSet<Listener> weakSet = this.listeners;
        synchronized (weakSet) {
            Listeners = (Listener[])this.listeners.toArray((Object[])new Listener[this.listeners.size()]);
        }
        for (Listener listener : Listeners) {
            if (listener == null) continue;
            listener.activeComponentsChanged(activeComponents);
        }
    }

    public void setActiveDocument(DesignDocument designDocument) {
        if (this.activeDocument == designDocument) {
            return;
        }
        DesignDocument lastDocument = this.activeDocument;
        this.activeDocument = designDocument;
        this.fireActiveDocumentChanged(lastDocument, this.activeDocument);
    }

    private class DocumentObserver
    implements Listener {
        private DocumentObserver() {
        }

        @Override
        public void activeDocumentChanged(DesignDocument deactivatedDocument, DesignDocument activatedDocument) {
        }

        @Override
        public void activeComponentsChanged(Collection<DesignComponent> activeComponents) {
        }
    }

    public static interface Listener {
        public void activeDocumentChanged(DesignDocument var1, DesignDocument var2);

        public void activeComponentsChanged(Collection<DesignComponent> var1);
    }

    private class SelectionDesignListener
    implements DesignListener {
        private DesignDocument document;

        public SelectionDesignListener(DesignDocument document) {
            this.document = document;
        }

        @Override
        public void designChanged(DesignEvent event) {
            ActiveDocumentSupport.this.fireActiveComponentsChanged(this.document.getSelectedComponents());
        }
    }
}

