/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.loader;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.common.JarOrDirectoryFilter;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class PathPropertyForm
extends JPanel
implements ListSelectionListener,
ActionListener {
    private final DefaultListModel mdl = new DefaultListModel();
    private final String propName;
    private final Properties properties;
    private char separator = File.pathSeparatorChar;
    private String separatorString = new String(new char[]{this.separator});
    boolean initializing;
    private JButton addJarButton;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JList list;
    private JButton removeButton;
    private JButton upButton;

    public PathPropertyForm(Properties properties, String propName) {
        this.properties = properties;
        this.propName = propName;
        this.initComponents();
        Mnemonics.setLocalizedText((AbstractButton)this.addJarButton, (String)this.addJarButton.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)this.removeButton.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)this.upButton.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)this.downButton.getText());
        this.list.setSelectionMode(0);
        this.list.setModel(this.mdl);
        this.initModel();
        this.list.getSelectionModel().addListSelectionListener(this);
        if (this.mdl.getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    private void initModel() {
        this.initializing = true;
        String value = this.properties.getProperty(this.propName);
        if (value != null && !"".equals(value.trim())) {
            String[] items;
            for (String item : items = value.split(this.separatorString)) {
                this.mdl.addElement(item);
            }
        } else {
            this.mdl.clear();
        }
        this.valueChanged(null);
        this.initializing = false;
    }

    private void updateModel() {
        Object toSelect = this.list.getSelectedValue();
        this.mdl.clear();
        this.initModel();
        int max = this.mdl.size();
        int ix = -1;
        if (toSelect != null) {
            for (int i = 0; i < max; ++i) {
                Object test = this.mdl.getElementAt(i);
                if (!toSelect.equals(test)) continue;
                ix = i;
                break;
            }
        }
        if (ix == -1 && this.mdl.size() != 0) {
            this.list.setSelectedIndex(0);
        } else if (ix != -1) {
            this.list.setSelectedIndex(ix);
        }
        this.list.requestFocusInWindow();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.addJarButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.list.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.addJarButton.setText(NbBundle.getMessage(PathPropertyForm.class, (String)"PathPropertyForm.addJarButton.text"));
        this.addJarButton.addActionListener(this);
        this.removeButton.setText(NbBundle.getMessage(PathPropertyForm.class, (String)"PathPropertyForm.removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.upButton.setText(NbBundle.getMessage(PathPropertyForm.class, (String)"PathPropertyForm.upButton.text"));
        this.upButton.addActionListener(this);
        this.downButton.setText(NbBundle.getMessage(PathPropertyForm.class, (String)"PathPropertyForm.downButton.text"));
        this.downButton.addActionListener(this);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 212, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.addJarButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeButton, -1, 115, Short.MAX_VALUE).add((Component)this.upButton, -1, 115, Short.MAX_VALUE).add((Component)this.downButton, -1, 115, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 122, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addJarButton).addPreferredGap(0).add((Component)this.removeButton).add(18, 18, 18).add((Component)this.upButton).addPreferredGap(0).add((Component)this.downButton))).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addJarButton) {
            this.addJarButtonActionPerformed(evt);
        } else if (evt.getSource() == this.removeButton) {
            this.removeButtonActionPerformed(evt);
        } else if (evt.getSource() == this.upButton) {
            this.upButtonActionPerformed(evt);
        } else if (evt.getSource() == this.downButton) {
            this.downButtonActionPerformed(evt);
        }
    }

    private void addJarButtonActionPerformed(ActionEvent evt) {
        JarOrDirectoryFilter filter = new JarOrDirectoryFilter();
        String title = NbBundle.getMessage(PathPropertyForm.class, (String)"TTL_ADD_JAR_OR_FOLDER");
        String okButtonText = NbBundle.getMessage(PathPropertyForm.class, (String)"ACTION_ADD");
        File[] files = null;
        files = new FileChooserBuilder(PathPropertyForm.class).setFileFilter((FileFilter)filter).setTitle(title).setApproveText(okButtonText).showMultiOpenDialog();
        if (files != null) {
            String prop = this.properties.getProperty(this.propName);
            StringBuilder sb = prop == null ? new StringBuilder() : new StringBuilder(prop.trim());
            String path = null;
            for (File file : files) {
                path = file.getAbsolutePath();
                this.mdl.addElement(path);
                if (sb.length() > 0) {
                    sb.append(this.separator);
                }
                sb.append(path);
            }
            this.properties.setProperty(this.propName, sb.toString());
            this.updateModel();
            if (path != null) {
                this.list.setSelectedValue(path, true);
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        HashSet<Object> toRemove = new HashSet<Object>(Arrays.asList(this.list.getSelectedValues()));
        String[] items = this.properties.getProperty(this.propName).split(this.separatorString);
        StringBuilder sb = new StringBuilder();
        String toSelect = null;
        for (String item : items) {
            if (!toRemove.contains(item)) {
                if (sb.length() > 0) {
                    sb.append(this.separator);
                }
                sb.append(item);
                continue;
            }
            if (toSelect != null) continue;
            toSelect = item;
        }
        this.properties.setProperty(this.propName, sb.toString());
        this.updateModel();
        if (toSelect != null) {
            this.list.setSelectedValue(toSelect, true);
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.moveBy(-1);
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        this.moveBy(1);
    }

    void moveBy(int qty) {
        Object o = this.list.getSelectedValue();
        int ix = this.list.getSelectedIndex();
        this.mdl.removeElementAt(ix);
        int newIndex = Math.max(0, Math.min(ix + qty, this.mdl.size()));
        this.mdl.add(newIndex, o);
        this.updateFromModel();
        this.list.setSelectedValue(o, true);
    }

    private void updateFromModel() {
        StringBuilder sb = new StringBuilder();
        for (Object o : this.mdl.toArray()) {
            if (sb.length() > 0) {
                sb.append(this.separator);
            }
            sb.append(o);
        }
        this.properties.setProperty(this.propName, sb.toString());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int ix = this.list.getSelectedIndex();
        this.removeButton.setEnabled(ix >= 0);
        this.upButton.setEnabled(ix > 0);
        this.downButton.setEnabled(ix >= 0 && ix < this.mdl.size() - 1);
    }
}

