/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AbstractObjectProvider;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.web.beans.impl.model.EventInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.MemberCheckerFilter;
import org.netbeans.modules.web.beans.impl.model.PackagingFilter;
import org.netbeans.modules.web.beans.impl.model.StereotypeChecker;
import org.netbeans.modules.web.beans.impl.model.StereotypedObject;
import org.netbeans.modules.web.beans.impl.model.StereotypedObjectProvider;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.openide.util.NbBundle;

public class WebBeansModelProviderImpl
extends EventInjectionPointLogic {
    private AtomicBoolean isDirty = new AtomicBoolean(true);
    private volatile boolean isIndexListenerAdded;
    private List<ElementHandle<? extends Element>> myNamedElement;

    protected WebBeansModelProviderImpl(WebBeansModelImplementation model) {
        super(model);
    }

    @Override
    public CompilationController getCompilationController() {
        return this.getModel().getHelper().getCompilationController();
    }

    @Override
    public TypeMirror resolveType(String fqn) {
        return this.getModel().getHelper().resolveType(fqn);
    }

    @Override
    public Result getInjectable(VariableElement element, DeclaredType parentType) {
        Element parent = element.getEnclosingElement();
        if (parent instanceof TypeElement) {
            return this.findVariableInjectable(element, parentType);
        }
        if (parent instanceof ExecutableElement) {
            return this.findParameterInjectable(element, parentType);
        }
        return null;
    }

    @Override
    public boolean isInjectionPoint(VariableElement element) throws InjectionPointDefinitionError {
        Element parent = element.getEnclosingElement();
        if (parent instanceof TypeElement) {
            List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
            return this.getModel().getHelper().hasAnnotation(annotations, "javax.inject.Inject");
        }
        if (parent instanceof ExecutableElement) {
            return this.isMethodParameterInjection(element, (ExecutableElement)parent);
        }
        return false;
    }

    private boolean isMethodParameterInjection(VariableElement element, ExecutableElement parent) throws InjectionPointDefinitionError {
        List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(parent);
        if (this.isDisposeParameter(element, parent, annotations)) {
            return true;
        }
        boolean hasObserves = AnnotationObjectProvider.hasAnnotation(element, "javax.enterprise.event.Observes", this.getModel().getHelper());
        if (!hasObserves && this.isObservesParameter(element, parent, annotations)) {
            return true;
        }
        return this.getModel().getHelper().hasAnnotation(annotations, "javax.inject.Inject") || this.getModel().getHelper().hasAnnotation(annotations, "javax.enterprise.inject.Produces");
    }

    @Override
    public List<AnnotationMirror> getQualifiers(Element element) {
        LinkedList<AnnotationMirror> result = new LinkedList<AnnotationMirror>();
        List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        boolean event = this.getParameterType(element, null, "javax.enterprise.event.Event") != null;
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (!this.isQualifier(annotationElement, this.getModel().getHelper(), event)) continue;
            result.add(annotationMirror);
        }
        return result;
    }

    @Override
    public String getName(Element element) {
        String name = this.inspectSpecializes(element);
        if (name != null) {
            return name;
        }
        List<AnnotationMirror> allStereotypes = WebBeansModelProviderImpl.getAllStereotypes(element, this.getModel().getHelper());
        for (AnnotationMirror annotationMirror : allStereotypes) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            TypeElement annotation = (TypeElement)annotationType.asElement();
            if (!AnnotationObjectProvider.hasAnnotation(annotation, "javax.inject.Named", this.getModel().getHelper())) continue;
            return this.getNamedName(element, null);
        }
        return null;
    }

    @Override
    public List<Element> getNamedElements() {
        List<Element> result;
        boolean dirty = this.isDirty.getAndSet(false);
        if (!this.isIndexListenerAdded) {
            this.addIndexListener();
        }
        if (!dirty) {
            result = this.getCachedNamedElements();
            if (!this.isDirty.get()) {
                return result;
            }
        }
        result = new LinkedList<Element>();
        Collection objects = this.getModel().getNamedManager().getObjects();
        for (BindingQualifier named : objects) {
            Element element = named.getTypeElement();
            if (element.getKind() == ElementKind.ANNOTATION_TYPE) continue;
            result.add(element);
        }
        List<Element> members = AbstractObjectProvider.getNamedMembers(this.getModel().getHelper());
        for (Element element : members) {
            if (element.getKind() != ElementKind.METHOD) continue;
            Set<Element> childSpecializes = this.getChildSpecializes(element, this.getModel());
            result.addAll(childSpecializes);
        }
        result.addAll(members);
        Set<String> stereotypeNames = this.getModel().adjustStereotypesManagers();
        for (String stereotype : stereotypeNames) {
            PersistentObjectManager<StereotypedObject> manager = this.getModel().getStereotypedManager(stereotype);
            Collection beans = manager.getObjects();
            for (StereotypedObject bean : beans) {
                TypeElement element = bean.getTypeElement();
                if (element.getKind() == ElementKind.ANNOTATION_TYPE) continue;
                result.add(element);
            }
            List<Element> stereotypedMembers = StereotypedObjectProvider.getAnnotatedMembers(stereotype, this.getModel().getHelper());
            result.addAll(stereotypedMembers);
        }
        PackagingFilter filter = new PackagingFilter(this.getModel());
        filter.filter(result);
        this.setCachedResult(result);
        return result;
    }

    public static List<AnnotationMirror> getAllStereotypes(Element element, AnnotationModelHelper helper) {
        LinkedList<AnnotationMirror> result = new LinkedList<AnnotationMirror>();
        HashSet<Element> foundStereotypesElement = new HashSet<Element>();
        StereotypeChecker checker = new StereotypeChecker(helper);
        WebBeansModelProviderImpl.doGetStereotypes(element, result, foundStereotypesElement, checker, helper);
        return result;
    }

    public static boolean isStereotype(TypeElement annotationElement, StereotypeChecker checker) {
        checker.init(annotationElement);
        boolean result = checker.check();
        checker.clean();
        return result;
    }

    private void setCachedResult(List<Element> list) {
        this.myNamedElement = new ArrayList<ElementHandle<? extends Element>>(list.size());
        for (Element element : list) {
            this.myNamedElement.add((ElementHandle<? extends Element>)ElementHandle.create((Element)element));
        }
    }

    private List<Element> getCachedNamedElements() {
        ArrayList<Element> result = new ArrayList<Element>(this.myNamedElement.size());
        for (ElementHandle<? extends Element> handle : this.myNamedElement) {
            Element element = handle.resolve((CompilationInfo)this.getModel().getHelper().getCompilationController());
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    private void addIndexListener() {
        this.isIndexListenerAdded = true;
        AnnotationModelHelper helper = this.getModel().getHelper();
        helper.getClasspathInfo().getClassIndex().addClassIndexListener(new ClassIndexListener(){

            public void typesAdded(TypesEvent event) {
                this.setDirty();
            }

            public void typesRemoved(TypesEvent event) {
                this.setDirty();
            }

            public void typesChanged(TypesEvent event) {
                this.setDirty();
            }

            public void rootsAdded(RootsEvent event) {
                this.setDirty();
            }

            public void rootsRemoved(RootsEvent event) {
                this.setDirty();
            }

            private void setDirty() {
                WebBeansModelProviderImpl.this.isDirty.set(true);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String inspectSpecializes(Element element) {
        if (element instanceof TypeElement) {
            String name = this.doGetName(element, element);
            if (name != null) {
                return name;
            }
            TypeElement superElement = AnnotationObjectProvider.checkSuper((TypeElement)element, "javax.inject.Named", this.getModel().getHelper());
            if (superElement == null) return null;
            return this.doGetName(element, superElement);
        }
        if (!(element instanceof ExecutableElement)) return this.doGetName(element, element);
        String name = this.doGetName(element, element);
        if (name != null) return name;
        Element specialized = MemberCheckerFilter.getSpecialized(element, this.getModel(), "javax.inject.Named");
        if (specialized == null) return null;
        return this.doGetName(element, specialized);
    }

    private String doGetName(Element original, Element element) {
        List<? extends AnnotationMirror> annotations = this.getModel().getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (!"javax.inject.Named".contentEquals(annotationElement.getQualifiedName())) continue;
            return this.getNamedName(original, annotationMirror);
        }
        return null;
    }

    private static void doGetStereotypes(Element element, List<AnnotationMirror> result, Set<Element> foundStereotypesElement, StereotypeChecker checker, AnnotationModelHelper helper) {
        List<? extends AnnotationMirror> annotationMirrors = helper.getCompilationController().getElements().getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (foundStereotypesElement.contains(annotationElement) || !WebBeansModelProviderImpl.isStereotype(annotationElement, checker)) continue;
            foundStereotypesElement.add(annotationElement);
            result.add(annotationMirror);
            WebBeansModelProviderImpl.doGetStereotypes(annotationElement, result, foundStereotypesElement, checker, helper);
        }
    }

    private String getNamedName(Element element, AnnotationMirror namedAnnotation) {
        String name;
        if (namedAnnotation != null) {
            AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getModel().getHelper());
            parser.expectString("value", null);
            ParseResult result = parser.parse(namedAnnotation);
            String name2 = (String)result.get("value", String.class);
            if (name2 != null) {
                return name2;
            }
        }
        if (element instanceof TypeElement) {
            name = element.getSimpleName().toString();
            if (name.length() > 0) {
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            return name;
        }
        if (element instanceof VariableElement) {
            return element.getSimpleName().toString();
        }
        if (element instanceof ExecutableElement) {
            name = element.getSimpleName().toString();
            if (name.startsWith("get") && name.length() > 3) {
                return this.getPropertyName(name, 3);
            }
            if (name.startsWith("is") && name.length() > 2) {
                return this.getPropertyName(name, 2);
            }
            return name;
        }
        return null;
    }

    private String getPropertyName(String methodName, int prefixLength) {
        String propertyName = methodName.substring(prefixLength);
        String propertyNameWithoutFL = propertyName.substring(1);
        if (propertyNameWithoutFL.length() > 0 && propertyNameWithoutFL.equals(propertyNameWithoutFL.toUpperCase())) {
            return propertyName;
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyNameWithoutFL;
    }

    private boolean isObservesParameter(VariableElement element, ExecutableElement method, List<? extends AnnotationMirror> annotations) throws InjectionPointDefinitionError {
        List<? extends VariableElement> parameters = method.getParameters();
        boolean observesFound = false;
        for (VariableElement variableElement : parameters) {
            if (!AnnotationObjectProvider.hasAnnotation(variableElement, "javax.enterprise.event.Observes", this.getModel().getHelper())) continue;
            if (observesFound) {
                throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_MultipleObserves", (Object)method.getSimpleName()));
            }
            observesFound = true;
        }
        if (!observesFound) {
            return false;
        }
        String badAnnotation = this.checkInjectProducers(annotations);
        if (badAnnotation != null) {
            throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_ObserverHasInjectOrProduces", (Object)method.getSimpleName(), (Object)badAnnotation));
        }
        return observesFound;
    }

    private boolean isDisposeParameter(VariableElement element, ExecutableElement method, List<? extends AnnotationMirror> annotations) throws InjectionPointDefinitionError {
        List<? extends VariableElement> parameters = method.getParameters();
        boolean disposeFound = false;
        boolean observesFound = false;
        for (VariableElement variableElement : parameters) {
            if (AnnotationObjectProvider.hasAnnotation(variableElement, "javax.enterprise.inject.Disposes", this.getModel().getHelper())) {
                if (disposeFound) {
                    throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_MultipleDisposes", (Object)method.getSimpleName()));
                }
                disposeFound = true;
            }
            if (!AnnotationObjectProvider.hasAnnotation(variableElement, "javax.enterprise.event.Observes", this.getModel().getHelper())) continue;
            observesFound = true;
        }
        if (!disposeFound) {
            return false;
        }
        if (observesFound) {
            throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_DisposesHasObserves", (Object)method.getSimpleName()));
        }
        String badAnnotation = this.checkInjectProducers(annotations);
        if (badAnnotation != null) {
            throw new InjectionPointDefinitionError(method, NbBundle.getMessage(WebBeansModelImplementation.class, (String)"ERR_DisposesHasInjectOrProduces", (Object)method.getSimpleName(), (Object)badAnnotation));
        }
        return disposeFound;
    }

    private String checkInjectProducers(List<? extends AnnotationMirror> annotations) {
        if (this.getModel().getHelper().hasAnnotation(annotations, "javax.inject.Inject")) {
            return "javax.inject.Inject";
        }
        if (this.getModel().getHelper().hasAnnotation(annotations, "javax.enterprise.inject.Produces")) {
            return "javax.enterprise.inject.Produces";
        }
        return null;
    }
}

