/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.RestrictedTypedFilter;
import org.netbeans.modules.web.beans.impl.model.TypeBindingFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

class TypeProductionFilter
extends Filter<Element> {
    private WebBeansModelImplementation myImpl;
    private TypeMirror myType;
    private Map<Element, List<DeclaredType>> myResult;
    private Element myOriginalElement;
    private static final Set<String> WRAPPERS = new HashSet<String>();

    private TypeProductionFilter() {
    }

    static TypeProductionFilter get() {
        return new TypeProductionFilter();
    }

    void init(TypeMirror elementType, Element injectionPoint, WebBeansModelImplementation model) {
        this.myImpl = model;
        this.myType = elementType;
        this.myResult = new HashMap<Element, List<DeclaredType>>();
        this.myOriginalElement = injectionPoint;
    }

    @Override
    void filter(Set<Element> productionElements) {
        if (this.filterPrimitives(productionElements)) {
            this.fillSimpleResult(productionElements);
            return;
        }
        if (this.filterArray(productionElements)) {
            this.fillSimpleResult(productionElements);
            return;
        }
        TypeBindingFilter filter = TypeBindingFilter.get();
        filter.init(this.getElementType(), this.getOriginalElement(), this.getImplementation());
        for (Element productionElement : productionElements) {
            TypeElement enclosingElement = this.getImplementation().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(productionElement);
            List<DeclaredType> derived = this.getDerived(enclosingElement);
            for (DeclaredType declaredType : derived) {
                TypeMirror mirror = null;
                try {
                    if (productionElement.getKind() == ElementKind.FIELD) {
                        mirror = this.getImplementation().getHelper().getCompilationController().getTypes().asMemberOf(declaredType, productionElement);
                    } else if (productionElement.getKind() == ElementKind.METHOD) {
                        mirror = this.getImplementation().getHelper().getCompilationController().getTypes().asMemberOf(declaredType, productionElement);
                        mirror = ((ExecutableType)mirror).getReturnType();
                    }
                    if (!filter.isAssignable(mirror, productionElement)) continue;
                    this.addResult(productionElement, declaredType);
                }
                catch (IllegalArgumentException e) {}
            }
        }
    }

    Map<Element, List<DeclaredType>> getResult() {
        return this.myResult;
    }

    private void addResult(Element productionElement, DeclaredType type) {
        List<DeclaredType> list = this.myResult.get(productionElement);
        if (list == null) {
            list = new ArrayList<DeclaredType>(2);
            this.myResult.put(productionElement, list);
        }
        list.add(type);
    }

    private void fillSimpleResult(Set<Element> productionElements) {
        for (Element element : productionElements) {
            TypeElement enclosingElement = this.getImplementation().getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            DeclaredType type = (DeclaredType)enclosingElement.asType();
            this.myResult.put(element, Collections.singletonList(type));
        }
    }

    private List<DeclaredType> getDerived(TypeElement element) {
        if (!this.isGeneric(element)) {
            return Collections.singletonList((DeclaredType)element.asType());
        }
        Set<TypeElement> implementors = FieldInjectionPointLogic.getImplementors(this.getImplementation(), element);
        ArrayList<DeclaredType> result = new ArrayList<DeclaredType>(implementors.size());
        for (TypeElement typeElement : implementors) {
            result.add((DeclaredType)typeElement.asType());
        }
        return result;
    }

    private boolean isGeneric(TypeElement element) {
        return element.getTypeParameters().size() != 0;
    }

    private boolean filterArray(Set<? extends Element> productionElements) {
        if (this.getElementType().getKind() == TypeKind.ARRAY) {
            TypeMirror arrayComponentType = ((ArrayType)this.getElementType()).getComponentType();
            Iterator<? extends Element> iterator = productionElements.iterator();
            while (iterator.hasNext()) {
                Element productionElement = iterator.next();
                boolean hasBeanType = this.hasBeanType(arrayComponentType, productionElement);
                if (hasBeanType) continue;
                iterator.remove();
            }
            return true;
        }
        return false;
    }

    private boolean hasBeanType(TypeMirror arrayComponentType, Element productionElement) {
        Collection<TypeMirror> restrictedTypes = RestrictedTypedFilter.getRestrictedTypes(productionElement, this.getImplementation());
        if (restrictedTypes == null) {
            TypeMirror productionType = null;
            if (productionElement.getKind() == ElementKind.FIELD) {
                productionType = productionElement.asType();
            } else if (productionElement.getKind() == ElementKind.METHOD) {
                productionType = ((ExecutableElement)productionElement).getReturnType();
            }
            return this.checkArrayBeanType(productionType, arrayComponentType);
        }
        Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
        for (TypeMirror restrictedType : restrictedTypes) {
            if (!types.isSameType(restrictedType, this.getElementType())) continue;
            return true;
        }
        return false;
    }

    private boolean checkArrayBeanType(TypeMirror productionType, TypeMirror arrayComponentType) {
        if (productionType == null) {
            return false;
        }
        if (productionType.getKind() != TypeKind.ARRAY) {
            return false;
        }
        return this.getImplementation().getHelper().getCompilationController().getTypes().isSameType(arrayComponentType, ((ArrayType)productionType).getComponentType());
    }

    private boolean filterPrimitives(Set<? extends Element> productionElements) {
        String typeName;
        Element varElement;
        PrimitiveType primitive = null;
        TypeElement boxedType = null;
        if (this.getElementType().getKind().isPrimitive()) {
            primitive = this.getImplementation().getHelper().getCompilationController().getTypes().getPrimitiveType(this.getElementType().getKind());
            boxedType = this.getImplementation().getHelper().getCompilationController().getTypes().boxedClass(primitive);
        } else if (this.getElementType().getKind() == TypeKind.DECLARED && (varElement = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(this.getElementType())) instanceof TypeElement && WRAPPERS.contains(typeName = ((TypeElement)varElement).getQualifiedName().toString())) {
            primitive = this.getImplementation().getHelper().getCompilationController().getTypes().unboxedType(varElement.asType());
            boxedType = (TypeElement)varElement;
        }
        if (primitive != null) {
            Iterator<? extends Element> iterator = productionElements.iterator();
            while (iterator.hasNext()) {
                Element productionElement = iterator.next();
                Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
                TypeMirror productionType = null;
                if (productionElement.getKind() == ElementKind.FIELD) {
                    productionType = productionElement.asType();
                } else if (productionElement.getKind() == ElementKind.METHOD) {
                    productionType = ((ExecutableElement)productionElement).getReturnType();
                }
                Collection<TypeMirror> restrictedTypes = RestrictedTypedFilter.getRestrictedTypes(productionElement, this.getImplementation());
                boolean isNotRestricted = true;
                if (restrictedTypes != null) {
                    isNotRestricted = false;
                    for (TypeMirror restrictedType : restrictedTypes) {
                        if (!types.isSameType(restrictedType, primitive) && !types.isSameType(restrictedType, boxedType.asType())) continue;
                        isNotRestricted = true;
                        break;
                    }
                }
                if (!isNotRestricted) {
                    iterator.remove();
                    continue;
                }
                if (productionType == null || types.isSameType(productionType, primitive) || types.isSameType(productionType, boxedType.asType())) continue;
                iterator.remove();
            }
        }
        return primitive != null;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }

    private TypeMirror getElementType() {
        return this.myType;
    }

    private Element getOriginalElement() {
        return this.myOriginalElement;
    }

    static {
        WRAPPERS.add(Boolean.class.getCanonicalName());
        WRAPPERS.add(Byte.class.getCanonicalName());
        WRAPPERS.add(Character.class.getCanonicalName());
        WRAPPERS.add(Double.class.getCanonicalName());
        WRAPPERS.add(Float.class.getCanonicalName());
        WRAPPERS.add(Integer.class.getCanonicalName());
        WRAPPERS.add(Long.class.getCanonicalName());
        WRAPPERS.add(Short.class.getCanonicalName());
    }
}

