/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.web.beans.impl.model.Checker;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.RuntimeAnnotationChecker;

class QualifierChecker
extends RuntimeAnnotationChecker
implements Checker {
    private static final String QUALIFIER_TYPE_ANNOTATION = "javax.inject.Qualifier";
    private static final Set<String> BUILT_IN_QUALIFIERS = new HashSet<String>();
    private boolean isEvent;

    QualifierChecker() {
        this(false);
    }

    QualifierChecker(boolean event) {
        this.isEvent = event;
    }

    static QualifierChecker get() {
        return new QualifierChecker();
    }

    static QualifierChecker get(boolean event) {
        return new QualifierChecker(event);
    }

    @Override
    public boolean check() {
        if (BUILT_IN_QUALIFIERS.contains(this.getElement().getQualifiedName().toString())) {
            return true;
        }
        return super.check();
    }

    @Override
    protected String getAnnotation() {
        return QUALIFIER_TYPE_ANNOTATION;
    }

    @Override
    protected Logger getLogger() {
        return FieldInjectionPointLogic.LOGGER;
    }

    @Override
    protected boolean checkTarget(Map<String, ? extends AnnotationMirror> types) {
        boolean hasRequiredTarget = false;
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        final HashSet elementTypes = new HashSet();
        parser.expectEnumConstantArray("value", this.getHelper().resolveType(ElementType.class.getCanonicalName()), new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    String value = arrayMember.getValue().toString();
                    elementTypes.add(value);
                }
                return null;
            }
        }, null);
        parser.parse(types.get(Target.class.getCanonicalName()));
        if (this.isEvent) {
            boolean hasFieldParameterTarget;
            boolean bl = hasFieldParameterTarget = elementTypes.contains(ElementType.FIELD.toString()) && elementTypes.contains(ElementType.PARAMETER.toString());
            if (!hasFieldParameterTarget) {
                hasRequiredTarget = false;
            } else {
                boolean bl2 = hasRequiredTarget = elementTypes.contains(ElementType.METHOD.toString()) && elementTypes.contains(ElementType.TYPE.toString());
            }
            if (!hasRequiredTarget) {
                this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Qualifier but has wrong target values." + " Correct target values are {METHOD, FIELD, PARAMETER, TYPE}" + " or {FIELD, PARAMETER}");
            }
        } else {
            boolean bl = hasRequiredTarget = elementTypes.contains(ElementType.METHOD.toString()) && elementTypes.contains(ElementType.FIELD.toString()) && elementTypes.contains(ElementType.PARAMETER.toString()) && elementTypes.contains(ElementType.TYPE.toString());
            if (!hasRequiredTarget) {
                this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Qualifier but has wrong target values." + " Correct target values are {METHOD, FIELD, PARAMETER, TYPE}");
            }
        }
        return hasRequiredTarget;
    }

    static {
        BUILT_IN_QUALIFIERS.add("javax.enterprise.inject.Any");
        BUILT_IN_QUALIFIERS.add("javax.enterprise.inject.New");
        BUILT_IN_QUALIFIERS.add("javax.enterprise.inject.Default");
        BUILT_IN_QUALIFIERS.add("javax.inject.Named");
    }
}

