/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.PatternValidator;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValueDataDerivType;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

class DataDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private PatternMemo validMemo;
    private PatternMemo invalidMemo;

    DataDataDerivType(Datatype dt) {
        this.dt = dt;
    }

    PatternMemo dataDeriv(ValidatorPatternBuilder builder, Pattern p, String str, ValidationContext vc) {
        try {
            this.dt.checkValid(str, vc);
            if (this.validMemo == null) {
                this.validMemo = super.dataDeriv(builder, p, str, vc);
            }
            return this.validMemo;
        }
        catch (DatatypeException e) {
            String msg = e.getMessage();
            if (msg != null && !"".equals(msg) && vc instanceof PatternValidator) {
                PatternValidator pv = (PatternValidator)vc;
                pv.addDatatypeError(msg, e);
            }
            if (this.invalidMemo == null) {
                this.invalidMemo = super.dataDeriv(builder, p, str, vc);
            }
            return this.invalidMemo;
        }
    }

    DataDerivType copy() {
        return new DataDataDerivType(this.dt);
    }

    DataDerivType combine(DataDerivType ddt) {
        if (ddt instanceof DataDataDerivType) {
            if (((DataDataDerivType)ddt).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        if (ddt instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)ddt).getDatatype() == this.dt) {
                return ddt;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return ddt.combine(this);
    }
}

