/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.exceptions;

import com.thaiopensource.relaxng.exceptions.AbstractValidationException;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.xml.util.Name;
import java.util.Map;
import org.xml.sax.Locator;

public class BadAttributeValueException
extends AbstractValidationException {
    private final Name attributeName;
    private final String attributeValue;
    private final Map exceptions;

    private static String formatMessage(Name currentElement, Name attributeName, String attributeValue, Map exceptions) {
        if (exceptions.isEmpty()) {
            Object[] values = new Object[]{NameFormatter.format(attributeName), NameFormatter.format(currentElement), attributeValue};
            return localizer.message("bad_attribute_value", values);
        }
        StringBuffer sb = new StringBuffer();
        for (String msg : exceptions.keySet()) {
            sb.append(' ');
            sb.append(msg);
        }
        Object[] values = new Object[]{NameFormatter.format(attributeName), NameFormatter.format(currentElement), attributeValue, sb};
        return localizer.message("bad_attribute_value_explain", values);
    }

    public BadAttributeValueException(Locator locator, Name currentElement, Name parent, Name attributeName, String attributeValue, Map exceptions) {
        super(BadAttributeValueException.formatMessage(currentElement, attributeName, attributeValue, exceptions), locator, currentElement, parent);
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.exceptions = exceptions;
    }

    public Name getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public Map getExceptions() {
        return this.exceptions;
    }
}

