/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.threads.ThreadData;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.threads.ThreadDetailsComponent;

public class ThreadsDetailsPanel
extends JPanel
implements ActionListener,
DataManagerListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String TEXT_DISPLAY_ALL = messages.getString("ThreadsDetailsPanel_TextDisplayAll");
    private static final String TEXT_DISPLAY_ALL_EX = messages.getString("ThreadsDetailsPanel_TextDisplayAllEx");
    private static final String TEXT_DISPLAY_LIVE = messages.getString("ThreadsDetailsPanel_TextDisplayLive");
    private static final String TEXT_DISPLAY_LIVE_EX = messages.getString("ThreadsDetailsPanel_TextDisplayLiveEx");
    private static final String TEXT_DISPLAY_FINISHED = messages.getString("ThreadsDetailsPanel_TextDisplayFinished");
    private static final String TEXT_DISPLAY_FINISHED_EX = messages.getString("ThreadsDetailsPanel_TextDisplayFinishedEx");
    private static final String TEXT_DISPLAY_SELECTION = messages.getString("ThreadsDetailsPanel_TextDisplaySelection");
    private static final String NO_CONTENT_MSG = messages.getString("ThreadsDetailsPanel_NoContentMsg");
    private static final String EVENTQUEUE_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_EventQueueThreadDescr");
    private static final String IMAGEFETCHER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_ImageFetcherThreadDescr");
    private static final String IMAGEANIMATOR_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_ImageAnimatorThreadDescr");
    private static final String AWTWINDOWS_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_AwtWindowsThreadDescr");
    private static final String AWTMOTIF_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_AwtMotifThreadDescr");
    private static final String AWTSHUTDWN_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_AwtShutDwnThreadDescr");
    private static final String MAIN_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_MainThreadDescr");
    private static final String FINALIZER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_FinalizerThreadDescr");
    private static final String REFHANDLER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_RefHandlerThreadDescr");
    private static final String SIGDISPATCH_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_SigDispatchThreadDescr");
    private static final String J2DISPOSER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_J2DisposerThreadDescr");
    private static final String TIMERQUEUE_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_TimerQueueThreadDescr");
    private static final String USER_THREAD_DESCR = messages.getString("ThreadsDetailsPanel_UserThreadDescr");
    private static final String COMBO_ACCESS_NAME = messages.getString("ThreadsDetailsPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = messages.getString("ThreadsDetailsPanel_ComboAccessDescr");
    private static final String CONTENT_ACCESS_NAME = messages.getString("ThreadsDetailsPanel_ContentAccessName");
    private static final String CONTENT_ACCESS_DESCR = messages.getString("ThreadsDetailsPanel_ContentAccessDescr");
    private static final String SHOW_LABEL_TEXT = messages.getString("ThreadsPanel_ShowLabelText");
    private static final int DISPLAY_ALL = 0;
    private static final int DISPLAY_LIVE = 1;
    private static final int DISPLAY_FINISHED = 2;
    private static final int DISPLAY_SELECTED = 3;
    private static final int DISPLAY_ALL_EX = 4;
    private static final int DISPLAY_LIVE_EX = 5;
    private static final int DISPLAY_FINISHED_EX = 6;
    private ArrayList displayedPanels = new ArrayList(10);
    private ArrayList excludedThreads = new ArrayList(5);
    private ArrayList filteredThreads = new ArrayList(10);
    private DefaultComboBoxModel comboModel;
    private HashMap descriptions = new HashMap(20);
    private HashMap indexToDisplayedIndex = new HashMap(15);
    private HashMap unusedPanels = new HashMap(5);
    private JComboBox threadsSelectionCombo;
    private JPanel content;
    private JPanel noContentPanel;
    private JScrollPane scrollPane;
    private JToolBar buttonsToolBar;
    private ThreadsDataManager manager;
    private boolean internalChange = false;
    private boolean noContent = false;
    private boolean resetPerformed = true;
    private boolean supportsSleepingState;
    private int displayMode = 3;

    public ThreadsDetailsPanel(ThreadsDataManager manager, boolean supportsSleepingState) {
        this.manager = manager;
        this.supportsSleepingState = supportsSleepingState;
        this.noContentPanel = new JPanel();
        this.noContentPanel.setLayout(new BorderLayout());
        this.noContentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noContentIcon = new JLabel(new ImageIcon(this.getClass().getResource("/org/netbeans/lib/profiler/ui/resources/threadsView.png")));
        noContentIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        noContentIcon.setVerticalAlignment(1);
        noContentIcon.setEnabled(false);
        JTextArea noContentText = new JTextArea(NO_CONTENT_MSG);
        noContentText.setFont(noContentText.getFont().deriveFont(14));
        noContentText.setEditable(false);
        noContentText.setEnabled(false);
        noContentText.setWrapStyleWord(true);
        noContentText.setLineWrap(true);
        noContentText.setBackground(this.noContentPanel.getBackground());
        JPanel containerPanel = new JPanel(new BorderLayout());
        containerPanel.add((Component)noContentIcon, "West");
        containerPanel.add((Component)noContentText, "Center");
        this.noContentPanel.add((Component)containerPanel, "North");
        this.threadsSelectionCombo = new JComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(250, this.getPreferredSize().height);
            }
        };
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.threadsSelectionCombo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        this.updateCombo();
        JLabel showLabel = new JLabel(SHOW_LABEL_TEXT);
        showLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        showLabel.setLabelFor(this.threadsSelectionCombo);
        int mnemCharIndex = 0;
        showLabel.setDisplayedMnemonic(showLabel.getText().charAt(mnemCharIndex));
        showLabel.setDisplayedMnemonicIndex(mnemCharIndex);
        this.buttonsToolBar = new JToolBar(0){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)comp);
                }
                return super.add(comp);
            }
        };
        this.content = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                return new Dimension(Math.min(dim.width, ((ThreadsDetailsPanel)ThreadsDetailsPanel.this).scrollPane.getViewportBorderBounds().width), dim.height);
            }
        };
        this.content.getAccessibleContext().setAccessibleName(CONTENT_ACCESS_NAME);
        this.content.getAccessibleContext().setAccessibleName(CONTENT_ACCESS_DESCR);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(contentPanel, 20, 31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.buttonsToolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.buttonsToolBar.setFloatable(false);
        this.buttonsToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.content.setLayout(new GridLayout(0, 1));
        contentPanel.add((Component)this.content, "North");
        this.buttonsToolBar.add(showLabel);
        this.buttonsToolBar.add(this.threadsSelectionCombo);
        this.add((Component)this.buttonsToolBar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.threadsSelectionCombo.addActionListener(this);
        manager.addDataListener((DataManagerListener)this);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsDetailsPanel.this.isShowing()) {
                    ThreadsDetailsPanel.this.dataChanged();
                }
            }
        });
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.scrollPane);
        }
        return UIUtils.createScreenshot(this.content);
    }

    public long getDataEndTime() {
        return this.manager.getEndTime();
    }

    public long getDataStartTime() {
        return this.manager.getStartTime();
    }

    public String getThreadClassName(int index) {
        return this.manager.getThreadClassName(index);
    }

    public ThreadData getThreadData(int index) {
        return this.manager.getThreadData(index);
    }

    public String getThreadDescription(int index) {
        String description = (String)this.descriptions.get(index);
        if (description == null) {
            description = this.createDescription(this.manager.getThreadName(index));
            this.descriptions.put(index, description);
        }
        return description;
    }

    public String getThreadName(int index) {
        return this.manager.getThreadName(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.internalChange) {
            return;
        }
        if (e.getSource() == this.threadsSelectionCombo) {
            String threadSelection = (String)this.threadsSelectionCombo.getSelectedItem();
            int oldMode = this.displayMode;
            switch (this.threadsSelectionCombo.getSelectedIndex()) {
                case 0: {
                    this.displayMode = 0;
                    break;
                }
                case 1: {
                    this.displayMode = 1;
                    break;
                }
                case 2: {
                    this.displayMode = 2;
                    break;
                }
                case 3: {
                    this.displayMode = 3;
                    break;
                }
                case 4: {
                    if (threadSelection == TEXT_DISPLAY_ALL_EX) {
                        this.displayMode = 4;
                        break;
                    }
                    if (threadSelection == TEXT_DISPLAY_LIVE_EX) {
                        this.displayMode = 5;
                        break;
                    }
                    if (threadSelection != TEXT_DISPLAY_FINISHED_EX) break;
                    this.displayMode = 6;
                }
            }
            if (oldMode != this.displayMode) {
                switch (this.displayMode) {
                    case 0: {
                        this.excludedThreads.clear();
                        break;
                    }
                    case 1: {
                        this.excludedThreads.clear();
                        break;
                    }
                    case 2: {
                        this.excludedThreads.clear();
                        break;
                    }
                    case 3: {
                        this.excludedThreads.clear();
                        this.filteredThreads.clear();
                    }
                }
                this.updateCombo();
                this.dataChanged();
            }
        }
    }

    public void addSaveViewAction(AbstractAction saveViewAction) {
        JButton actionButton = this.buttonsToolBar.add(saveViewAction);
        this.buttonsToolBar.remove(actionButton);
        this.buttonsToolBar.add((Component)actionButton, 0);
        this.buttonsToolBar.add((Component)new JToolBar.Separator(), 1);
    }

    public void dataChanged() {
        if (this.resetPerformed) {
            this.supportsSleepingState = this.manager.supportsSleepingStateMonitoring();
            this.resetPerformed = false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (!ThreadsDetailsPanel.this.isShowing()) {
                    return;
                }
                ThreadsDetailsPanel.this.updateFilteredData();
                if (ThreadsDetailsPanel.this.updateDisplayedPanels()) {
                    ThreadsDetailsPanel.this.content.invalidate();
                    ThreadsDetailsPanel.this.revalidate();
                    ThreadsDetailsPanel.this.repaint();
                }
            }
        });
    }

    public void dataReset() {
        this.resetPerformed = true;
        this.filteredThreads.clear();
        this.excludedThreads.clear();
        this.descriptions.clear();
        this.content.removeAll();
        this.unusedPanels.clear();
        this.displayedPanels.clear();
        this.displayMode = 3;
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                ThreadsDetailsPanel.this.updateCombo();
                ThreadsDetailsPanel.this.content.invalidate();
                ThreadsDetailsPanel.this.revalidate();
                ThreadsDetailsPanel.this.repaint();
            }
        });
    }

    public boolean fitsVisibleArea() {
        return !this.scrollPane.getVerticalScrollBar().isVisible();
    }

    public boolean hasView() {
        return !this.noContent && this.content.getComponentCount() > 0;
    }

    public void hideThreadDetails(int index) {
        if (this.displayMode == 3) {
            this.filteredThreads.remove((Object)index);
        } else {
            if (this.displayMode == 0) {
                this.displayMode = 4;
                this.updateCombo();
            } else if (this.displayMode == 1) {
                this.displayMode = 5;
                this.updateCombo();
            } else if (this.displayMode == 2) {
                this.displayMode = 6;
                this.updateCombo();
            }
            this.excludedThreads.add(index);
            this.updateFilteredData();
        }
        if (this.updateDisplayedPanels()) {
            this.content.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public void showDetails(int[] indexes) {
        this.displayMode = 3;
        this.filteredThreads.clear();
        this.excludedThreads.clear();
        for (int i = 0; i < indexes.length; ++i) {
            this.filteredThreads.add(indexes[i]);
        }
        this.updateCombo();
        if (this.updateDisplayedPanels()) {
            this.content.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    private ThreadDetailsComponent getPanel(int threadIndex) {
        ThreadDetailsComponent tdcr = (ThreadDetailsComponent)this.unusedPanels.remove(threadIndex);
        if (tdcr == null) {
            tdcr = this.unusedPanels.size() > 0 ? (ThreadDetailsComponent)this.unusedPanels.remove(this.unusedPanels.keySet().iterator().next()) : new ThreadDetailsComponent(this, this.supportsSleepingState);
        }
        tdcr.setIndex(threadIndex);
        return tdcr;
    }

    private String createDescription(String threadName) {
        if (threadName.startsWith("AWT-EventQueue-")) {
            return EVENTQUEUE_THREAD_DESCR;
        }
        if (threadName.startsWith("Image Fetcher ")) {
            return IMAGEFETCHER_THREAD_DESCR;
        }
        if (threadName.startsWith("Image Animator ")) {
            return IMAGEANIMATOR_THREAD_DESCR;
        }
        if (threadName.equals("AWT-Windows")) {
            return AWTWINDOWS_THREAD_DESCR;
        }
        if (threadName.equals("AWT-Motif")) {
            return AWTMOTIF_THREAD_DESCR;
        }
        if (threadName.equals("AWT-Shutdown")) {
            return AWTSHUTDWN_THREAD_DESCR;
        }
        if (threadName.equals("main")) {
            return MAIN_THREAD_DESCR;
        }
        if (threadName.equals("Finalizer")) {
            return FINALIZER_THREAD_DESCR;
        }
        if (threadName.equals("Reference Handler")) {
            return REFHANDLER_THREAD_DESCR;
        }
        if (threadName.equals("Signal Dispatcher")) {
            return SIGDISPATCH_THREAD_DESCR;
        }
        if (threadName.equals("Java2D Disposer")) {
            return J2DISPOSER_THREAD_DESCR;
        }
        if (threadName.equals("TimerQueue")) {
            return TIMERQUEUE_THREAD_DESCR;
        }
        return USER_THREAD_DESCR;
    }

    private void updateCombo() {
        this.internalChange = true;
        this.comboModel = new DefaultComboBoxModel<Object>(new Object[]{TEXT_DISPLAY_ALL, TEXT_DISPLAY_LIVE, TEXT_DISPLAY_FINISHED, TEXT_DISPLAY_SELECTION});
        int displayIndex = 0;
        switch (this.displayMode) {
            case 0: {
                displayIndex = 0;
                break;
            }
            case 1: {
                displayIndex = 1;
                break;
            }
            case 2: {
                displayIndex = 2;
                break;
            }
            case 3: {
                displayIndex = 3;
                break;
            }
            case 4: {
                this.comboModel.addElement(TEXT_DISPLAY_ALL_EX);
                displayIndex = 4;
                break;
            }
            case 5: {
                this.comboModel.addElement(TEXT_DISPLAY_LIVE_EX);
                displayIndex = 4;
                break;
            }
            case 6: {
                this.comboModel.addElement(TEXT_DISPLAY_FINISHED_EX);
                displayIndex = 4;
            }
        }
        this.threadsSelectionCombo.setModel(this.comboModel);
        this.threadsSelectionCombo.setSelectedIndex(displayIndex);
        this.internalChange = false;
    }

    private boolean updateDisplayedPanels() {
        ThreadDetailsComponent tdc;
        int i;
        int displayedSize;
        boolean changed = false;
        int filteredSize = this.filteredThreads.size();
        if (filteredSize == 0) {
            if (!this.noContent) {
                this.noContent = true;
                this.remove(this.scrollPane);
                this.add((Component)this.noContentPanel, "Center");
                this.invalidate();
                this.revalidate();
                this.repaint();
            }
            return changed;
        }
        if (this.noContent) {
            this.noContent = false;
            this.remove(this.noContentPanel);
            this.add((Component)this.scrollPane, "Center");
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
        if (filteredSize > (displayedSize = this.displayedPanels.size())) {
            for (i = displayedSize; i < filteredSize; ++i) {
                tdc = this.getPanel((Integer)this.filteredThreads.get(i));
                this.displayedPanels.add(tdc);
                this.content.add(tdc);
            }
            changed = true;
        } else if (filteredSize < displayedSize) {
            for (i = filteredSize; i < displayedSize; ++i) {
                tdc = (ThreadDetailsComponent)this.displayedPanels.remove(filteredSize);
                this.unusedPanels.put(tdc.getIndex(), tdc);
                this.content.remove(tdc);
            }
            changed = true;
        }
        this.indexToDisplayedIndex.clear();
        int count = 0;
        Iterator it = this.filteredThreads.iterator();
        while (it.hasNext()) {
            int indexToDisplay = (Integer)it.next();
            ((ThreadDetailsComponent)this.displayedPanels.get(count)).setIndex(indexToDisplay);
            this.indexToDisplayedIndex.put(indexToDisplay, count);
            ++count;
        }
        return changed;
    }

    private boolean updateDisplayedPanels1() {
        this.content.removeAll();
        this.indexToDisplayedIndex.clear();
        for (int i = this.displayedPanels.size() - 1; i >= 0; --i) {
            ThreadDetailsComponent tdcr = (ThreadDetailsComponent)this.displayedPanels.remove(i);
            this.unusedPanels.put(tdcr.getIndex(), tdcr);
        }
        int count = 0;
        Iterator it = this.filteredThreads.iterator();
        while (it.hasNext()) {
            int indexToDisplay = (Integer)it.next();
            ThreadDetailsComponent tdcr = this.getPanel(indexToDisplay);
            this.content.add(tdcr);
            this.displayedPanels.add(tdcr);
            this.indexToDisplayedIndex.put(indexToDisplay, count++);
        }
        return true;
    }

    private void updateFilteredData() {
        byte state;
        ThreadData threadData;
        int i;
        if (this.displayMode == 3) {
            return;
        }
        this.filteredThreads.clear();
        if (this.displayMode == 0 || this.displayMode == 4) {
            for (i = 0; i < this.manager.getThreadsCount(); ++i) {
                this.filteredThreads.add(i);
            }
        }
        if (this.displayMode == 1 || this.displayMode == 5) {
            for (i = 0; i < this.manager.getThreadsCount(); ++i) {
                threadData = this.manager.getThreadData(i);
                if (threadData.size() <= 0 || (state = threadData.getLastState()) == 0) continue;
                this.filteredThreads.add(i);
            }
        }
        if (this.displayMode == 2 || this.displayMode == 6) {
            for (i = 0; i < this.manager.getThreadsCount(); ++i) {
                threadData = this.manager.getThreadData(i);
                if (threadData.size() > 0) {
                    state = threadData.getLastState();
                    if (state != 0) continue;
                    this.filteredThreads.add(i);
                    continue;
                }
                this.filteredThreads.add(i);
            }
        }
        if (this.displayMode == 4 || this.displayMode == 5 || this.displayMode == 6) {
            this.filteredThreads.removeAll(this.excludedThreads);
        }
    }
}

