/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class MainClassUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor("main-class-updater", 1);
    private static final Logger LOG = Logger.getLogger(MainClassUpdater.class.getName());
    private final Project project;
    private final PropertyEvaluator eval;
    private final UpdateHelper helper;
    private final ClassPath sourcePath;
    private final String mainClassPropName;
    private FileObject currentFo;
    private DataObject currentDo;
    private FileChangeListener foListener;
    private PropertyChangeListener doListener;
    private long lc = 0L;

    public MainClassUpdater(Project project, PropertyEvaluator eval, UpdateHelper helper, ClassPath sourcePath, String mainClassPropName) {
        assert (project != null);
        assert (eval != null);
        assert (helper != null);
        assert (sourcePath != null);
        assert (mainClassPropName != null);
        this.project = project;
        this.eval = eval;
        this.helper = helper;
        this.sourcePath = sourcePath;
        this.mainClassPropName = mainClassPropName;
        this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        this.addFileChangeListener();
    }

    public synchronized void unregister() {
        if (this.currentFo != null && this.foListener != null) {
            this.currentFo.removeFileChangeListener(this.foListener);
        }
        if (this.currentDo != null && this.doListener != null) {
            this.currentDo.removePropertyChangeListener(this.doListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("primaryFile".equals(evt.getPropertyName())) {
            FileObject newFile = (FileObject)evt.getNewValue();
            FileObject oldFile = (FileObject)evt.getOldValue();
            this.handleMainClassMoved(oldFile, newFile);
        } else if (this.mainClassPropName.equals(evt.getPropertyName())) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    MainClassUpdater.this.addFileChangeListener();
                }
            });
        }
    }

    public void fileRenamed(FileRenameEvent evt) {
        this.handleMainClassMoved(evt.getFile(), evt.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMainClassMoved(FileObject oldFile, final FileObject newFile) {
        FileObject _current;
        if (!this.project.getProjectDirectory().isValid()) {
            return;
        }
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            _current = this.currentFo;
        }
        if (oldFile == _current) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        String oldMainClass = (String)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                            public String run() throws Exception {
                                return MainClassUpdater.this.eval.getProperty(MainClassUpdater.this.mainClassPropName);
                            }
                        });
                        Collection main = SourceUtils.getMainClasses((FileObject)newFile);
                        String newMainClass = null;
                        if (!main.isEmpty()) {
                            ElementHandle mainHandle = (ElementHandle)main.iterator().next();
                            newMainClass = mainHandle.getQualifiedName();
                        }
                        if (newMainClass != null && !newMainClass.equals(oldMainClass) && MainClassUpdater.this.helper.requestUpdate() && MainClassUpdater.this.eval.getProperty("config") == null) {
                            final String newMainClassFinal = newMainClass;
                            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                                public Void run() throws Exception {
                                    EditableProperties props = MainClassUpdater.this.helper.getProperties("nbproject/project.properties");
                                    props.put(MainClassUpdater.this.mainClassPropName, newMainClassFinal);
                                    MainClassUpdater.this.helper.putProperties("nbproject/project.properties", props);
                                    ProjectManager.getDefault().saveProject(MainClassUpdater.this.project);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                    catch (MutexException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileChangeListener() {
        long clc;
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            if (this.currentFo != null && this.foListener != null) {
                this.currentFo.removeFileChangeListener(this.foListener);
                this.foListener = null;
                this.currentFo = null;
            }
            if (this.currentDo != null && this.doListener != null) {
                this.currentDo.removePropertyChangeListener(this.doListener);
                this.doListener = null;
                this.currentDo = null;
            }
            clc = ++this.lc;
        }
        final String mainClassName = this.eval.getProperty(this.mainClassPropName);
        if (mainClassName != null) {
            try {
                FileObject[] roots = this.sourcePath.getRoots();
                if (roots.length > 0) {
                    ClassPath compileCp;
                    ClassPath bootCp = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot");
                    if (bootCp == null) {
                        LOG.log(Level.WARNING, "No bootpath for: {0}", FileUtil.getFileDisplayName((FileObject)roots[0]));
                        bootCp = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
                    }
                    if ((compileCp = ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile")) == null) {
                        LOG.log(Level.WARNING, "No classpath for: {0}", FileUtil.getFileDisplayName((FileObject)roots[0]));
                        compileCp = ClassPathSupport.createClassPath((URL[])new URL[0]);
                    }
                    final ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)bootCp, (ClassPath)compileCp, (ClassPath)this.sourcePath);
                    JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
                    js.runWhenScanFinished((Task)new Task<CompilationController>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(CompilationController c) throws Exception {
                            TypeElement te = c.getElements().getTypeElement(mainClassName);
                            if (te != null) {
                                FileObject fo = SourceUtils.getFile((Element)te, (ClasspathInfo)cpInfo);
                                MainClassUpdater mainClassUpdater = MainClassUpdater.this;
                                synchronized (mainClassUpdater) {
                                    if (MainClassUpdater.this.lc == clc && fo != null && MainClassUpdater.this.sourcePath.contains(fo)) {
                                        MainClassUpdater.this.currentFo = fo;
                                        MainClassUpdater.this.foListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)MainClassUpdater.this, (Object)MainClassUpdater.this.currentFo);
                                        MainClassUpdater.this.currentFo.addFileChangeListener(MainClassUpdater.this.foListener);
                                        MainClassUpdater.this.currentDo = DataObject.find((FileObject)MainClassUpdater.this.currentFo);
                                        MainClassUpdater.this.doListener = WeakListeners.propertyChange((PropertyChangeListener)MainClassUpdater.this, (Object)MainClassUpdater.this.currentDo);
                                        MainClassUpdater.this.currentDo.addPropertyChangeListener(MainClassUpdater.this.doListener);
                                    }
                                }
                            }
                        }
                    }, true);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

