/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;

public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private static final Logger LOG = Logger.getLogger(ElementScanningTask.class.getName());
    private ClassMemberPanelUI ui;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private static final String TYPE_COLOR = "#707070";
    private static final String INHERITED_COLOR = "#7D694A";

    public ElementScanningTask(ClassMemberPanelUI ui) {
        this.ui = ui;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void run(CompilationInfo info) throws Exception {
        this.canceled.set(false);
        long start = System.currentTimeMillis();
        if (info.getChangedTree() != null) {
            long end = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{info.getFileObject(), end - start});
            return;
        }
        ElementNode.Description rootDescription = new ElementNode.Description(this.ui);
        rootDescription.fileObject = info.getFileObject();
        rootDescription.subs = new HashSet<ElementNode.Description>();
        CompilationUnitTree cuTree = info.getCompilationUnit();
        List elements = info.getTopLevelElements();
        HashMap<Element, Long> pos = new HashMap<Element, Long>();
        if (!this.canceled.get()) {
            Trees trees = info.getTrees();
            PositionVisitor posVis = new PositionVisitor(trees, this.canceled);
            posVis.scan((Tree)cuTree, (Map<Element, Long>)pos);
        }
        if (!this.canceled.get() && elements != null) {
            for (TypeElement element : elements) {
                ElementNode.Description topLevel = this.element2description(element, null, false, info, pos);
                if (null == topLevel) continue;
                if (!rootDescription.subs.add(topLevel)) {
                    LOG.log(Level.INFO, "Duplicate top level class: {0}", topLevel.name);
                }
                this.addMembers(element, topLevel, info, pos);
            }
        }
        if (!this.canceled.get()) {
            this.ui.refresh(rootDescription);
        }
        long end = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{info.getFileObject(), end - start});
    }

    private void addMembers(TypeElement e, ElementNode.Description parentDescription, CompilationInfo info, Map<Element, Long> pos) {
        List<? extends Element> members = info.getElements().getAllMembers(e);
        for (Element element : members) {
            if (this.canceled.get()) {
                return;
            }
            ElementNode.Description d = this.element2description(element, e, parentDescription.isInherited, info, pos);
            if (null == d) continue;
            if (!parentDescription.subs.add(d)) {
                LOG.log(Level.INFO, "Duplicate enclosed element: {0}", d.name);
            }
            if (!(element instanceof TypeElement) || d.isInherited) continue;
            this.addMembers((TypeElement)element, d, info, pos);
        }
    }

    private ElementNode.Description element2description(Element e, Element parent, boolean isParentInherited, CompilationInfo info, Map<Element, Long> pos) {
        if (info.getElementUtilities().isSynthetic(e)) {
            return null;
        }
        boolean inherited = isParentInherited || null != parent && !((Object)parent).equals(e.getEnclosingElement());
        ElementNode.Description d = new ElementNode.Description(this.ui, e.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)e), e.getKind(), inherited);
        if (e instanceof TypeElement) {
            d.subs = new HashSet<ElementNode.Description>();
            d.htmlHeader = this.createHtmlHeader((TypeElement)e, info.getElements().isDeprecated(e), d.isInherited);
        } else if (e instanceof ExecutableElement) {
            d.htmlHeader = this.createHtmlHeader((ExecutableElement)e, info.getElements().isDeprecated(e), d.isInherited);
        } else if (e instanceof VariableElement) {
            if (e.getKind() != ElementKind.FIELD && e.getKind() != ElementKind.ENUM_CONSTANT) {
                return null;
            }
            d.htmlHeader = this.createHtmlHeader((VariableElement)e, info.getElements().isDeprecated(e), d.isInherited);
        }
        d.modifiers = e.getModifiers();
        d.pos = this.getPosition(e, info, pos);
        d.cpInfo = info.getClasspathInfo();
        return d;
    }

    private long getPosition(Element e, CompilationInfo info, Map<Element, Long> pos) {
        Long res = pos.get(e);
        if (res == null) {
            return -1L;
        }
        return res;
    }

    private String createHtmlHeader(ExecutableElement e, boolean isDeprecated, boolean isInherited) {
        TypeMirror rt;
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=#7D694A>");
        }
        if (e.getKind() == ElementKind.CONSTRUCTOR) {
            sb.append(e.getEnclosingElement().getSimpleName());
        } else {
            sb.append(e.getSimpleName());
        }
        if (isDeprecated) {
            sb.append("</s>");
        }
        sb.append("(");
        List<? extends VariableElement> params = e.getParameters();
        Iterator<? extends VariableElement> it = params.iterator();
        while (it.hasNext()) {
            VariableElement param = it.next();
            sb.append("<font color=#707070>");
            boolean vararg = !it.hasNext() && e.isVarArgs();
            sb.append(this.printArg(param.asType(), vararg));
            sb.append("</font>");
            sb.append(" ");
            sb.append(param.getSimpleName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (e.getKind() != ElementKind.CONSTRUCTOR && (rt = e.getReturnType()).getKind() != TypeKind.VOID) {
            sb.append(" : ");
            sb.append("<font color=#707070>");
            sb.append(this.print(e.getReturnType()));
            sb.append("</font>");
        }
        return sb.toString();
    }

    private String createHtmlHeader(VariableElement e, boolean isDeprecated, boolean isInherited) {
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=#7D694A>");
        }
        sb.append(e.getSimpleName());
        if (isDeprecated) {
            sb.append("</s>");
        }
        if (e.getKind() != ElementKind.ENUM_CONSTANT) {
            sb.append(" : ");
            sb.append("<font color=#707070>");
            sb.append(this.print(e.asType()));
            sb.append("</font>");
        }
        return sb.toString();
    }

    private String createHtmlHeader(TypeElement e, boolean isDeprecated, boolean isInherited) {
        List<? extends TypeParameterElement> typeParams;
        StringBuilder sb = new StringBuilder();
        if (isDeprecated) {
            sb.append("<s>");
        }
        if (isInherited) {
            sb.append("<font color=#7D694A>");
        }
        sb.append(e.getSimpleName());
        if (isDeprecated) {
            sb.append("</s>");
        }
        if ((typeParams = e.getTypeParameters()) != null && !typeParams.isEmpty()) {
            sb.append("&lt;");
            Iterator<? extends TypeParameterElement> it = typeParams.iterator();
            while (it.hasNext()) {
                TypeParameterElement tp = it.next();
                sb.append(tp.getSimpleName());
                try {
                    List<? extends TypeMirror> bounds = tp.getBounds();
                    if (!bounds.isEmpty()) {
                        sb.append(this.printBounds(bounds));
                    }
                }
                catch (NullPointerException npe) {
                    System.err.println("El " + e);
                    npe.printStackTrace();
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("&gt;");
        }
        TypeMirror sc = e.getSuperclass();
        String scName = this.print(sc);
        if (sc == null || e.getKind() == ElementKind.ENUM || e.getKind() == ElementKind.ANNOTATION_TYPE || "Object".equals(scName) || "<none>".equals(scName)) {
            scName = null;
        }
        List<? extends TypeMirror> ifaces = e.getInterfaces();
        if (!(scName == null && ifaces.isEmpty() || e.getKind() == ElementKind.ANNOTATION_TYPE)) {
            sb.append(" :: ");
            if (scName != null) {
                sb.append("<font color=#707070>");
                sb.append(scName);
                sb.append("</font>");
            }
            if (!ifaces.isEmpty()) {
                if (scName != null) {
                    sb.append(" : ");
                }
                Iterator<? extends TypeMirror> it = ifaces.iterator();
                while (it.hasNext()) {
                    TypeMirror typeMirror = it.next();
                    sb.append("<font color=#707070>");
                    sb.append(this.print(typeMirror));
                    sb.append("</font>");
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        return sb.toString();
    }

    private String printBounds(List<? extends TypeMirror> bounds) {
        if (bounds.size() == 1 && "java.lang.Object".equals(((Object)bounds.get(0)).toString())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" extends ");
        Iterator<? extends TypeMirror> it = bounds.iterator();
        while (it.hasNext()) {
            TypeMirror bound = it.next();
            sb.append(this.print(bound));
            if (!it.hasNext()) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    private String printArg(TypeMirror tm, boolean varArg) {
        if (varArg) {
            if (tm.getKind() == TypeKind.ARRAY) {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(this.print(at.getComponentType()));
                sb.append("...");
                return sb.toString();
            }
            assert (false) : "Expected array: " + ((Object)tm).toString() + " ( " + (Object)((Object)tm.getKind()) + " )";
        }
        return this.print(tm);
    }

    private String print(TypeMirror tm) {
        switch (tm.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)tm;
                StringBuilder sb = new StringBuilder(dt.asElement().getSimpleName().toString());
                List<? extends TypeMirror> typeArgs = dt.getTypeArguments();
                if (!typeArgs.isEmpty()) {
                    sb.append("&lt;");
                    Iterator<? extends TypeMirror> it = typeArgs.iterator();
                    while (it.hasNext()) {
                        TypeMirror ta = it.next();
                        sb.append(this.print(ta));
                        if (!it.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("&gt;");
                }
                return sb.toString();
            }
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)tm;
                StringBuilder sb = new StringBuilder(tv.asElement().getSimpleName().toString());
                return sb.toString();
            }
            case ARRAY: {
                ArrayType at = (ArrayType)tm;
                StringBuilder sb = new StringBuilder(this.print(at.getComponentType()));
                sb.append("[]");
                return sb.toString();
            }
            case WILDCARD: {
                WildcardType wt = (WildcardType)tm;
                StringBuilder sb = new StringBuilder("?");
                if (wt.getExtendsBound() != null) {
                    sb.append(" extends ");
                    sb.append(this.print(wt.getExtendsBound()));
                }
                if (wt.getSuperBound() != null) {
                    sb.append(" super ");
                    sb.append(this.print(wt.getSuperBound()));
                }
                return sb.toString();
            }
        }
        return ((Object)tm).toString();
    }

    private static class PositionVisitor
    extends TreePathScanner<Void, Map<Element, Long>> {
        private final Trees trees;
        private final SourcePositions sourcePositions;
        private final AtomicBoolean canceled;
        private CompilationUnitTree cu;

        public PositionVisitor(Trees trees, AtomicBoolean canceled) {
            assert (trees != null);
            assert (canceled != null);
            this.trees = trees;
            this.sourcePositions = trees.getSourcePositions();
            this.canceled = canceled;
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree node, Map<Element, Long> p) {
            this.cu = node;
            return (Void)super.visitCompilationUnit(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return (Void)super.visitClass(node, p);
        }

        @Override
        public Void visitMethod(MethodTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Map<Element, Long> p) {
            Element e = this.trees.getElement(this.getCurrentPath());
            if (e != null) {
                long pos = this.sourcePositions.getStartPosition(this.cu, node);
                p.put(e, pos);
            }
            return null;
        }

        @Override
        public Void scan(Tree tree, Map<Element, Long> p) {
            if (!this.canceled.get()) {
                return (Void)super.scan(tree, p);
            }
            return null;
        }
    }
}

