/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.ElementScanningTask;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.netbeans.modules.java.navigation.ToolTipManagerEx;
import org.netbeans.modules.java.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.java.navigation.actions.SortActionSupport;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.netbeans.modules.java.navigation.base.TapPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener,
PropertyChangeListener {
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private InstanceContent selectedNodes = new InstanceContent();
    private Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
    private ClassMemberFilters filters;
    private Action[] actions;
    private static final Rectangle ZERO = new Rectangle(0, 0, 1, 1);
    private long lastShowWaitNodeTime = -1L;
    private static final Logger PERF_LOG = Logger.getLogger(ClassMemberPanelUI.class.getName() + ".perf");
    private static final RequestProcessor RP = new RequestProcessor(ClassMemberPanelUI.class.getName(), 1);

    public ClassMemberPanelUI() {
        this.initComponents();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)keyText));
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        JComponent buttons = this.filters.getComponent();
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(buttons);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.filtersPanel.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this.filters), new SortActionSupport.SortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getInstance())};
        this.add((Component)this.filtersPanel, "South");
        this.manager.setRootContext(ElementNode.getWaitNode());
        boolean expanded = NbPreferences.forModule(ClassMemberPanelUI.class).getBoolean("filtersPanelTap.expanded", true);
        this.filtersPanel.setExpanded(expanded);
        this.filtersPanel.addPropertyChangeListener(this);
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return result;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.elementView.requestFocus();
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
                ClassMemberPanelUI.this.lastShowWaitNodeTime = System.currentTimeMillis();
            }
        });
    }

    public void selectElementNode(ElementHandle<Element> eh) {
        ElementNode root = this.getRootNode();
        if (root == null) {
            return;
        }
        ElementNode node = root.getNodeForElement(eh);
        try {
            this.manager.setSelectedNodes(new Node[]{node == null ? this.getRootNode() : node});
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
    }

    public void refresh(final ElementNode.Description description) {
        final ElementNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getDescritption().fileObject.equals(description.fileObject)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    rootNode.updateRecursively(description);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(description));
                    boolean scrollOnExpand = ClassMemberPanelUI.this.getScrollOnExpand();
                    ClassMemberPanelUI.this.setScrollOnExpand(false);
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(false);
                    ClassMemberPanelUI.this.elementView.expandAll();
                    ClassMemberPanelUI.this.elementView.setAutoWaitCursor(true);
                    ClassMemberPanelUI.this.setScrollOnExpand(scrollOnExpand);
                    if (PERF_LOG.isLoggable(Level.FINE)) {
                        long tm2 = System.currentTimeMillis();
                        long tm1 = ClassMemberPanelUI.this.lastShowWaitNodeTime;
                        if (tm1 != -1L) {
                            ClassMemberPanelUI.this.lastShowWaitNodeTime = -1L;
                            PERF_LOG.log(Level.FINE, String.format("ClassMemberPanelUI refresh took: %d ms", tm2 - tm1), new Object[]{description.getFileObject().getName(), tm2 - tm1});
                        }
                    }
                }
            });
        }
    }

    public void sort() {
        ElementNode root = this.getRootNode();
        if (null != root) {
            root.refreshRecursively();
        }
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node n) {
        this.elementView.expandNode(n);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        ElementNode root = this.getRootNode();
        if (root != null) {
            return root.getDescritption().fileObject;
        }
        return null;
    }

    @Override
    public void filterStateChanged(ChangeEvent e) {
        ElementNode root = this.getRootNode();
        if (root != null) {
            root.refreshRecursively();
        }
    }

    boolean getScrollOnExpand() {
        return null == this.elementView ? true : this.elementView.getScrollOnExpand();
    }

    void setScrollOnExpand(boolean scroll) {
        if (null != this.elementView) {
            this.elementView.setScrollOnExpand(scroll);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof ElementNode) {
            return (ElementNode)n;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        return new MyBeanTreeView();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected ElementJavadoc getJavaDocFor(ElementNode node) {
        ElementNode root = this.getRootNode();
        if (root == null) {
            return null;
        }
        ElementHandle<? extends Element> eh = node.getDescritption().elementHandle;
        JavaSource js = JavaSource.forFileObject((FileObject)root.getDescritption().fileObject);
        if (js == null) {
            return null;
        }
        JavaDocCalculator calculator = new JavaDocCalculator(eh);
        CompilationInfo[] ci = new CompilationInfo[1];
        try {
            js.runUserActionTask((Task)calculator, true);
        }
        catch (IOException ioE) {
            Exceptions.printStackTrace((Throwable)ioE);
            return null;
        }
        return calculator.doc;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            for (Node n : (Node[])evt.getOldValue()) {
                this.selectedNodes.remove((Object)n);
            }
            for (Node n : (Node[])evt.getNewValue()) {
                this.selectedNodes.add((Object)n);
            }
        } else if ("TapPanel.expanded".equals(evt.getPropertyName())) {
            NbPreferences.forModule(ClassMemberPanelUI.class).putBoolean("filtersPanelTap.expanded", this.filtersPanel.isExpanded());
        }
    }

    private class MyBeanTreeView
    extends BeanTreeView
    implements ToolTipManagerEx.ToolTipProvider {
        private final ToolTipManagerEx toolTipManager = new ToolTipManagerEx(this);
        private boolean inHierarchy;
        private boolean doExpandAll;

        public MyBeanTreeView() {
            this.setUseSubstringInQuickSearch(true);
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }

        @Override
        public JComponent getComponent() {
            return this.tree;
        }

        @Override
        public String getToolTipText(Point loc) {
            ElementJavadoc doc = this.getDocumentation(loc);
            return null == doc ? null : doc.getText();
        }

        private ElementJavadoc getDocumentation(Point loc) {
            TreePath path = this.tree.getPathForLocation(loc.x, loc.y);
            if (null == path) {
                return null;
            }
            Node node = Visualizer.findNode((Object)path.getLastPathComponent());
            if (node instanceof ElementNode) {
                return ClassMemberPanelUI.this.getJavaDocFor((ElementNode)node);
            }
            return null;
        }

        @Override
        public Rectangle getToolTipSourceBounds(Point loc) {
            ElementNode root = ClassMemberPanelUI.this.getRootNode();
            if (root == null) {
                return null;
            }
            TreePath path = this.tree.getPathForLocation(loc.x, loc.y);
            return null == path ? null : this.tree.getPathBounds(path);
        }

        @Override
        public Point getToolTipLocation(Point mouseLocation, Dimension tipSize) {
            Point screenLocation = this.getLocationOnScreen();
            Rectangle sBounds = this.getGraphicsConfiguration().getBounds();
            Dimension compSize = this.getSize();
            Point res = new Point();
            Rectangle tooltipSrcRect = this.getToolTipSourceBounds(mouseLocation);
            if (tooltipSrcRect == null) {
                tooltipSrcRect = new Rectangle();
            }
            Point viewPosition = this.getViewport().getViewPosition();
            screenLocation.x -= viewPosition.x;
            screenLocation.y -= viewPosition.y;
            res.x = screenLocation.x + compSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height;
            if (res.x + tipSize.width <= sBounds.x + sBounds.width && res.y + tipSize.height <= sBounds.y + sBounds.height) {
                return res;
            }
            res.x = screenLocation.x + compSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y - tipSize.height;
            if (res.x + tipSize.width <= sBounds.x + sBounds.width && res.y >= sBounds.y) {
                return res;
            }
            res.x = screenLocation.x - tipSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y;
            if (res.x >= sBounds.x && res.y + tipSize.height <= sBounds.y + sBounds.height) {
                return res;
            }
            res.x = screenLocation.x - tipSize.width;
            res.y = screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height - tipSize.height;
            if (res.x >= sBounds.x && res.y >= sBounds.y) {
                return res;
            }
            res.x = screenLocation.x + tooltipSrcRect.x;
            res.y = sBounds.y + sBounds.height - (screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height) > screenLocation.y + tooltipSrcRect.y - sBounds.y ? screenLocation.y + tooltipSrcRect.y + tooltipSrcRect.height : screenLocation.y + tooltipSrcRect.y - tipSize.height;
            return res;
        }

        @Override
        public void invokeUserAction(final MouseEvent me) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != me) {
                        ElementJavadoc doc = MyBeanTreeView.this.getDocumentation(me.getPoint());
                        JavadocTopComponent tc = JavadocTopComponent.findInstance();
                        if (null != tc) {
                            tc.open();
                            tc.setJavadoc(doc);
                            tc.requestActive();
                        }
                    }
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.inHierarchy = true;
            if (this.doExpandAll) {
                super.expandAll();
                this.doExpandAll = false;
            }
        }

        public void removeNotify() {
            super.removeNotify();
            this.inHierarchy = false;
            this.toolTipManager.hideTipWindow();
        }

        public void expandAll() {
            super.expandAll();
            if (!this.inHierarchy) {
                this.doExpandAll = true;
            }
        }
    }

    private static class JavaDocCalculator
    implements Task<CompilationController> {
        private ElementHandle<? extends Element> handle;
        private ElementJavadoc doc;

        public JavaDocCalculator(ElementHandle<? extends Element> handle) {
            this.handle = handle;
        }

        public void run(CompilationController cc) throws Exception {
            cc.toPhase(JavaSource.Phase.UP_TO_DATE);
            Element e = this.handle.resolve((CompilationInfo)cc);
            this.doc = ElementJavadoc.create((CompilationInfo)cc, (Element)e);
        }
    }
}

