/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.actions.JAXBDeleteSchemaAction;
import org.netbeans.modules.xml.jaxb.actions.OpenJAXBCustomizerAction;
import org.netbeans.modules.xml.jaxb.cfg.schema.Binding;
import org.netbeans.modules.xml.jaxb.cfg.schema.Bindings;
import org.netbeans.modules.xml.jaxb.cfg.schema.Catalog;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSource;
import org.netbeans.modules.xml.jaxb.cfg.schema.SchemaSources;
import org.netbeans.modules.xml.jaxb.ui.JAXBBindingSupportFileNode;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.actions.DeleteAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JAXBWizardSchemaNode
extends AbstractNode {
    private String schemaName;
    private Project project;
    private Schema schema;
    private static Action[] actions = null;

    public JAXBWizardSchemaNode(Project project, Schema schema) {
        this(project, schema, new InstanceContent());
        this.schemaName = schema.getName();
        this.project = project;
        this.schema = schema;
        this.initActions();
    }

    private JAXBWizardSchemaNode(Project project, Schema schema, InstanceContent content) {
        super((Children)new JAXBWizardSchemaNodeChildren(project, schema), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)this);
    }

    public Action[] getActions(boolean b) {
        return actions;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schm) {
        this.schema = schm;
        Children c = this.getChildren();
        if (c instanceof JAXBWizardSchemaNodeChildren) {
            JAXBWizardSchemaNodeChildren jaxbC = (JAXBWizardSchemaNodeChildren)c;
            jaxbC.setSchema(this.schema);
        }
    }

    public Project getProject() {
        return this.project;
    }

    private void initActions() {
        if (actions == null) {
            actions = new Action[]{SystemAction.get(OpenJAXBCustomizerAction.class), null, SystemAction.get(DeleteAction.class)};
        }
    }

    public String getDisplayName() {
        return this.schemaName;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        super.destroy();
        JAXBDeleteSchemaAction delAction = (JAXBDeleteSchemaAction)SystemAction.get(JAXBDeleteSchemaAction.class);
        delAction.performAction(new Node[]{this});
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/jaxb/resources/package.gif");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/jaxb/resources/packageOpen.gif");
    }

    public static class JAXBWizardSchemaNodeChildren
    extends Children.Keys {
        private Project project;
        private Schema schema;

        public JAXBWizardSchemaNodeChildren(Project prj, Schema schema) {
            this.schema = schema;
            this.project = prj;
            this.addNodify();
        }

        public void addNodify() {
            this.updateKeys();
            super.addNotify();
        }

        public void removeNotify() {
        }

        private void updateKeys() {
            ArrayList<Object> childrenNodes = new ArrayList<Object>();
            SchemaSources sss = this.schema.getSchemaSources();
            SchemaSource[] ss = sss.getSchemaSource();
            Bindings bs = this.schema.getBindings();
            Catalog cat = this.schema.getCatalog();
            if (ss != null) {
                for (int i = 0; i < ss.length; ++i) {
                    childrenNodes.add(ss[i]);
                }
            }
            if (bs != null && bs.sizeBinding() > 0) {
                Binding[] binding = bs.getBinding();
                for (int i = 0; i < binding.length; ++i) {
                    childrenNodes.add(binding[i]);
                }
            }
            if (cat != null && cat.getLocation() != null) {
                childrenNodes.add(cat);
            }
            super.setKeys(childrenNodes);
        }

        public void setSchema(Schema schm) {
            this.schema = schm;
            this.updateKeys();
        }

        public void refreshChildren() {
            this.updateKeys();
        }

        protected Node[] createNodes(Object key) {
            Node[] xsdNodes = null;
            try {
                Catalog cat;
                Node delegate;
                DataObject dataObj;
                Binding bndg;
                FileObject prjRoot = this.project.getProjectDirectory();
                FileObject xsdFolder = ProjectHelper.getFOProjectSchemaDir(this.project);
                File projDir = FileUtil.toFile((FileObject)prjRoot);
                FileObject locSchemaRoot = xsdFolder.getFileObject(this.schema.getName());
                JAXBBindingSupportFileNode xsdNode = null;
                FileObject fo = null;
                if (key instanceof SchemaSource) {
                    SchemaSource ss = (SchemaSource)key;
                    File tmpFile = null;
                    String originLocType = null;
                    Boolean isURL = Boolean.FALSE;
                    originLocType = ss.getOrigLocationType();
                    if (originLocType != null && "url".equals(originLocType)) {
                        isURL = Boolean.TRUE;
                    }
                    if ((fo = FileUtil.toFileObject((File)new File(projDir, ss.getLocation()))) != null) {
                        xsdNode = new JAXBBindingSupportFileNode(this.project, fo, locSchemaRoot, isURL, ss.getOrigLocation());
                        try {
                            DataObject dataObj2 = DataObject.find((FileObject)fo);
                            Node delegate2 = dataObj2.getNodeDelegate();
                            xsdNode.setNodeDelegate(delegate2);
                        }
                        catch (DataObjectNotFoundException ex) {}
                    } else {
                        tmpFile = new File(ss.getLocation());
                        fo = xsdFolder.getFileObject(tmpFile.getName());
                        if (fo != null) {
                            xsdNode = new JAXBBindingSupportFileNode(this.project, fo, locSchemaRoot, isURL, ss.getOrigLocation());
                        }
                    }
                }
                if (key instanceof Binding && (fo = FileUtil.toFileObject((File)new File(projDir, (bndg = (Binding)key).getLocation()))) != null) {
                    xsdNode = new JAXBBindingSupportFileNode(this.project, fo, locSchemaRoot, false, bndg.getOrigLocation());
                    try {
                        dataObj = DataObject.find((FileObject)fo);
                        delegate = dataObj.getNodeDelegate();
                        xsdNode.setNodeDelegate(delegate);
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                if (key instanceof Catalog && (fo = FileUtil.toFileObject((File)new File(projDir, (cat = (Catalog)key).getLocation()))) != null) {
                    xsdNode = new JAXBBindingSupportFileNode(this.project, fo, locSchemaRoot, false, cat.getOrigLocation());
                    try {
                        dataObj = DataObject.find((FileObject)fo);
                        delegate = dataObj.getNodeDelegate();
                        xsdNode.setNodeDelegate(delegate);
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
                if (xsdNode != null) {
                    xsdNodes = new Node[]{xsdNode};
                }
            }
            catch (IntrospectionException inse) {
                Exceptions.printStackTrace((Throwable)inse);
            }
            return xsdNodes;
        }
    }
}

