/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTFortranFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTGnuCFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTGnuCppFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTStdCFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTStdCppFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public final class APTLanguageSupport {
    private static APTLanguageSupport singleton = new APTLanguageSupport();
    public static final String STD_C = "Std C Language";
    public static final String GNU_C = "Gnu C Language";
    public static final String GNU_CPP = "Gnu C++ Language";
    public static final String STD_CPP = "Std C++ Language";
    public static final String FORTRAN = "Fortran Language";
    public static final String UNKNOWN = "Unknown Language";
    private Map<String, APTLanguageFilter> langFilters = new HashMap<String, APTLanguageFilter>();

    private APTLanguageSupport() {
    }

    public static APTLanguageSupport getInstance() {
        return singleton;
    }

    public APTLanguageFilter getFilter(String lang) {
        APTLanguageFilter filter = this.langFilters.get(lang);
        if (filter == null && (filter = APTLanguageSupport.createFilter(lang)) != null) {
            this.addFilter(lang, filter);
        }
        return filter;
    }

    public void addFilter(String lang, APTLanguageFilter filter) {
        this.langFilters.put(lang, filter);
    }

    private static APTLanguageFilter createFilter(String lang) {
        APTBaseLanguageFilter filter = null;
        if (lang.equalsIgnoreCase(STD_C)) {
            filter = new APTStdCFilter();
        } else if (lang.equalsIgnoreCase(STD_CPP)) {
            filter = new APTStdCppFilter();
        } else if (lang.equalsIgnoreCase(GNU_C)) {
            filter = new APTGnuCFilter();
        } else if (lang.equalsIgnoreCase(GNU_CPP)) {
            filter = new APTGnuCppFilter();
        } else if (lang.equalsIgnoreCase(FORTRAN)) {
            filter = new APTFortranFilter();
        } else {
            APTUtils.LOG.log(Level.WARNING, "unsupported language {0}", lang);
        }
        return filter;
    }
}

