/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.File;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class ResolvedPath {
    private final CharSequence folder;
    private final FileSystem fileSystem;
    private final CharSequence path;
    private final boolean isDefaultSearchPath;
    private final int index;

    public ResolvedPath(FileSystem fileSystem, CharSequence folder, CharSequence path, boolean isDefaultSearchPath, int index) {
        this.folder = folder;
        this.fileSystem = fileSystem;
        this.path = FilePathCache.getManager().getString(path);
        this.isDefaultSearchPath = isDefaultSearchPath;
        this.index = index;
        assert (CndFileUtils.isExistingFile((FileSystem)fileSystem, (String)((Object)this.path).toString())) : "isExistingFile failed in " + fileSystem + " for " + path;
        assert (!CndFileUtils.isLocalFileSystem((FileSystem)fileSystem) || new File(((Object)this.path).toString()).isFile()) : "not a file " + this.path;
        assert (CndFileUtils.toFileObject((FileSystem)fileSystem, (CharSequence)path) != null) : "no FileObject in " + fileSystem + " for " + path + " FileUtil.toFileObject = " + FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)((Object)path).toString()))) + " second check = " + fileSystem.findResource(((Object)path).toString());
        CndUtils.assertNormalized((FileSystem)fileSystem, (CharSequence)folder);
        CndUtils.assertNormalized((FileSystem)fileSystem, (CharSequence)path);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public FileObject getFileObject() {
        return CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)this.path);
    }

    public CharSequence getPath() {
        return this.path;
    }

    public CharSequence getFolder() {
        return this.folder;
    }

    public boolean isDefaultSearchPath() {
        return this.isDefaultSearchPath;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return this.path + " in " + this.folder + " at " + this.fileSystem;
    }
}

