/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.apt.impl.support.APTDriverImpl;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.openide.filesystems.FileSystem;

public final class APTDriver {
    private static final Map<FileSystem, APTDriverImpl> drivers = new WeakHashMap<FileSystem, APTDriverImpl>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final Lock rLock = rwLock.readLock();
    private static final Lock wLock = rwLock.writeLock();

    private APTDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static APTDriverImpl getInstance(APTFileBuffer buffer) {
        APTDriverImpl impl;
        FileSystem fs = buffer.getFileSystem();
        rLock.lock();
        try {
            impl = drivers.get(fs);
        }
        finally {
            rLock.unlock();
        }
        if (impl == null) {
            wLock.lock();
            try {
                impl = drivers.get(fs);
                if (impl == null) {
                    impl = new APTDriverImpl();
                    drivers.put(fs, impl);
                }
            }
            finally {
                wLock.unlock();
            }
        }
        return impl;
    }

    public static APTFile findAPTLight(APTFileBuffer buffer) throws IOException {
        return APTDriver.getInstance(buffer).findAPT(buffer, false, "Unknown Language");
    }

    public static APTFile findAPT(APTFileBuffer buffer, String lang) throws IOException {
        return APTDriver.getInstance(buffer).findAPT(buffer, true, lang);
    }

    public static void invalidateAPT(APTFileBuffer buffer) {
        APTDriver.getInstance(buffer).invalidateAPT(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAll() {
        wLock.lock();
        try {
            for (APTDriverImpl driver : drivers.values()) {
                driver.invalidateAll();
            }
            drivers.clear();
        }
        finally {
            wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        wLock.lock();
        try {
            for (APTDriverImpl driver : drivers.values()) {
                driver.close();
            }
            drivers.clear();
        }
        finally {
            wLock.unlock();
        }
    }
}

