/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.util.NbBundle;

public final class TestSessionVO {
    private final List<TestSuiteVO> testSuites = new ArrayList<TestSuiteVO>();
    private long time = -1L;
    private int tests = -1;

    public void addTestSuite(TestSuiteVO testSuite) {
        this.testSuites.add(testSuite);
    }

    public List<TestSuiteVO> getTestSuites() {
        return this.testSuites;
    }

    public int getTests() {
        return this.tests;
    }

    public void setTests(int tests) {
        this.tests = tests;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String toString() {
        return String.format("TestSessionVO{time: %d, tests: %d, suites: %d}", this.time, this.tests, this.testSuites.size());
    }

    public static final class TestCaseVO {
        private static final String EXPECTED_SECTION_START = "--- Expected";
        private static final String EXPECTED_ROW_START = "-";
        private static final String ACTUAL_SECTION_START = "+++ Actual";
        private static final String ACTUAL_ROW_START = "+";
        private static final String DIFF_SECTION_START = "@@ @@";
        private final List<String> stacktrace = new ArrayList<String>();
        private final String name;
        private final String file;
        private final int line;
        private final long time;
        private Status status = Status.PASSED;

        public TestCaseVO(String name, String file, int line, long time) {
            assert (name != null);
            this.name = name;
            this.file = file;
            this.line = line;
            this.time = time;
        }

        static TestCaseVO skippedTestCase() {
            TestCaseVO testCase = new TestCaseVO(NbBundle.getMessage(TestSuiteVO.class, (String)"LBL_NoTestCasesFound"), null, -1, -1L);
            testCase.status = Status.SKIPPED;
            return testCase;
        }

        public String getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public String getName() {
            return this.name;
        }

        public void addStacktrace(String line) {
            this.stacktrace.add(line);
        }

        public String[] getStacktrace() {
            return this.stacktrace.toArray(new String[this.stacktrace.size()]);
        }

        public Diff getDiff() {
            StringBuilder expected = new StringBuilder(100);
            StringBuilder actual = new StringBuilder(100);
            boolean diffStarted = false;
            for (String row : this.stacktrace) {
                if (!row.contains(EXPECTED_SECTION_START) || !row.contains(ACTUAL_SECTION_START)) continue;
                for (String part : row.split("\r?\n")) {
                    if (diffStarted) {
                        if (part.startsWith(EXPECTED_ROW_START)) {
                            this.addSpace(expected);
                            expected.append(part.substring(EXPECTED_ROW_START.length()));
                            continue;
                        }
                        if (part.startsWith(ACTUAL_ROW_START)) {
                            this.addSpace(actual);
                            actual.append(part.substring(ACTUAL_ROW_START.length()));
                            continue;
                        }
                        String p = part.substring(1);
                        this.addSpace(expected);
                        expected.append(p);
                        this.addSpace(actual);
                        actual.append(p);
                        continue;
                    }
                    if (!part.equals(DIFF_SECTION_START)) continue;
                    diffStarted = true;
                }
            }
            return new Diff(expected.toString(), actual.toString());
        }

        private void addSpace(StringBuilder sb) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
        }

        public long getTime() {
            return this.time;
        }

        public void setErrorStatus() {
            assert (this.status == Status.PASSED);
            this.status = Status.ERROR;
        }

        public void setFailureStatus() {
            assert (this.status == Status.PASSED);
            this.status = Status.FAILED;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isError() {
            return this.status.equals((Object)Status.ERROR);
        }

        public boolean isFailure() {
            return this.status.equals((Object)Status.FAILED);
        }

        public String toString() {
            return String.format("TestCaseVO{name: %s, file: %s, line: %d, time: %d, status: %s, stacktrace: %s}", this.name, this.file, this.line, this.time, this.status, this.stacktrace);
        }

        public static final class Diff {
            public final String expected;
            public final String actual;

            public Diff(String expected, String actual) {
                this.expected = expected;
                this.actual = actual;
            }

            public boolean isValid() {
                return StringUtils.hasText((String)this.expected) || StringUtils.hasText((String)this.actual);
            }
        }
    }

    public static final class TestSuiteVO {
        private final List<TestCaseVO> testCases = new ArrayList<TestCaseVO>();
        private final String name;
        private final String file;
        private final long time;

        public TestSuiteVO(String name, String file, long time) {
            assert (name != null);
            assert (file != null);
            this.name = name;
            this.file = file;
            this.time = time;
        }

        void addTestCase(TestCaseVO testCase) {
            this.testCases.add(testCase);
        }

        public String getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public List<TestCaseVO> getTestCases() {
            this.checkTestCases();
            return this.testCases;
        }

        public long getTime() {
            return this.time;
        }

        private void checkTestCases() {
            if (!this.testCases.isEmpty()) {
                return;
            }
            this.testCases.add(TestCaseVO.skippedTestCase());
        }

        public String toString() {
            return String.format("TestSuiteVO{name: %s, file: %s, time: %d, cases: %d}", this.name, this.file, this.time, this.testCases.size());
        }
    }
}

