/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class CustomizerPhpUnit
extends JPanel {
    private static final long serialVersionUID = 2171421712032630826L;
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final PhpProject project;
    private JButton bootstrapBrowseButton;
    private JCheckBox bootstrapCheckBox;
    private JCheckBox bootstrapForCreateTestsCheckBox;
    private JButton bootstrapGenerateButton;
    private JLabel bootstrapLabel;
    private JTextField bootstrapTextField;
    private JButton configurationBrowseButton;
    private JCheckBox configurationCheckBox;
    private JButton configurationGenerateButton;
    private JLabel configurationLabel;
    private JTextField configurationTextField;
    private JLabel phpUnitLabel;
    private JCheckBox runTestUsingUnitCheckBox;
    private JButton suiteBrowseButton;
    private JCheckBox suiteCheckBox;
    private JLabel suiteInfoLabel;
    private JLabel suiteLabel;
    private JTextField suiteTextField;

    public CustomizerPhpUnit(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        this.category = category;
        this.uiProps = uiProps;
        this.project = uiProps.getProject();
        this.initComponents();
        this.initFile(uiProps.getPhpUnitBootstrap(), this.bootstrapCheckBox, this.bootstrapTextField);
        this.bootstrapForCreateTestsCheckBox.setSelected(uiProps.getPhpUnitBootstrapForCreateTests());
        this.initFile(uiProps.getPhpUnitConfiguration(), this.configurationCheckBox, this.configurationTextField);
        this.initFile(uiProps.getPhpUnitSuite(), this.suiteCheckBox, this.suiteTextField);
        this.runTestUsingUnitCheckBox.setSelected(uiProps.getPhpUnitRunTestFiles());
        this.enableFile(this.bootstrapCheckBox.isSelected(), this.bootstrapLabel, this.bootstrapTextField, this.bootstrapGenerateButton, this.bootstrapBrowseButton, this.bootstrapForCreateTestsCheckBox);
        this.enableFile(this.configurationCheckBox.isSelected(), this.configurationLabel, this.configurationTextField, this.configurationGenerateButton, this.configurationBrowseButton);
        this.enableFile(this.suiteCheckBox.isSelected(), this.suiteLabel, this.suiteTextField, this.suiteBrowseButton, this.suiteInfoLabel);
        this.addListeners();
        this.validateData();
    }

    void enableFile(boolean enabled, JComponent ... components) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    void validateData() {
        String bootstrap = "";
        if (this.bootstrapCheckBox.isSelected() && (bootstrap = this.getValidFile(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_Bootstrap"), this.bootstrapTextField)) == null) {
            return;
        }
        String configuration = "";
        if (this.configurationCheckBox.isSelected() && (configuration = this.getValidFile(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_XmlConfiguration"), this.configurationTextField)) == null) {
            return;
        }
        String suite = "";
        if (this.suiteCheckBox.isSelected() && (suite = this.getValidFile(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_TestSuite"), this.suiteTextField)) == null) {
            return;
        }
        this.uiProps.setPhpUnitBootstrap(bootstrap);
        this.uiProps.setPhpUnitBootstrapForCreateTests(this.bootstrapForCreateTestsCheckBox.isSelected());
        this.uiProps.setPhpUnitConfiguration(configuration);
        this.uiProps.setPhpUnitSuite(suite);
        this.uiProps.setPhpUnitRunTestFiles(this.runTestUsingUnitCheckBox.isSelected());
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void initFile(String file, JCheckBox checkBox, JTextField textField) {
        if (StringUtils.hasText((String)file)) {
            checkBox.setSelected(true);
            textField.setText(file);
        }
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.bootstrapCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.bootstrapLabel, CustomizerPhpUnit.this.bootstrapTextField, CustomizerPhpUnit.this.bootstrapGenerateButton, CustomizerPhpUnit.this.bootstrapBrowseButton, CustomizerPhpUnit.this.bootstrapForCreateTestsCheckBox);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.bootstrapTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.bootstrapForCreateTestsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.configurationCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.configurationLabel, CustomizerPhpUnit.this.configurationTextField, CustomizerPhpUnit.this.configurationGenerateButton, CustomizerPhpUnit.this.configurationBrowseButton);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.configurationTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.suiteCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.enableFile(e.getStateChange() == 1, CustomizerPhpUnit.this.suiteLabel, CustomizerPhpUnit.this.suiteTextField, CustomizerPhpUnit.this.suiteBrowseButton, CustomizerPhpUnit.this.suiteInfoLabel);
                CustomizerPhpUnit.this.validateData();
            }
        });
        this.suiteTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.runTestUsingUnitCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CustomizerPhpUnit.this.validateData();
            }
        });
    }

    private String getValidFile(String name, JTextField textField) {
        String file = textField.getText();
        String error = this.validateFile(file, name);
        if (error != null) {
            this.category.setErrorMessage(error);
            this.category.setValid(false);
            return null;
        }
        return file;
    }

    private String validateFile(String path, String name) {
        if (!StringUtils.hasText((String)path)) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NoFile", (Object)name);
        }
        File file = new File(path);
        if (!file.isFile()) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NotFile", (Object)name);
        }
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NotAbsoluteFile", (Object)name);
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(CustomizerPhpUnit.class, (String)"MSG_NotReadableFile", (Object)name);
        }
        return null;
    }

    private File getDefaultDirectory() {
        File defaultDirectory = null;
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(this.project, false);
        if (testDirectory != null) {
            defaultDirectory = FileUtil.toFile((FileObject)testDirectory);
        } else {
            FileObject sourcesDirectory = ProjectPropertiesSupport.getSourcesDirectory(this.project);
            assert (sourcesDirectory != null);
            defaultDirectory = FileUtil.toFile((FileObject)sourcesDirectory);
        }
        assert (defaultDirectory != null);
        return defaultDirectory;
    }

    private boolean checkTestDirectory() {
        FileObject testDirectory = ProjectPropertiesSupport.getTestDirectory(this.project, false);
        if (testDirectory == null && this.askQuestion(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_TestsNotSet", (Object)((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName()))) {
            testDirectory = ProjectPropertiesSupport.getTestDirectory(this.project, true);
        }
        return testDirectory != null;
    }

    private boolean askQuestion(String question) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)question, 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.YES_OPTION;
    }

    private void initComponents() {
        this.phpUnitLabel = new JLabel();
        this.bootstrapLabel = new JLabel();
        this.bootstrapTextField = new JTextField();
        this.bootstrapBrowseButton = new JButton();
        this.bootstrapGenerateButton = new JButton();
        this.bootstrapForCreateTestsCheckBox = new JCheckBox();
        this.configurationCheckBox = new JCheckBox();
        this.configurationLabel = new JLabel();
        this.configurationTextField = new JTextField();
        this.configurationBrowseButton = new JButton();
        this.bootstrapCheckBox = new JCheckBox();
        this.configurationGenerateButton = new JButton();
        this.suiteCheckBox = new JCheckBox();
        this.suiteLabel = new JLabel();
        this.suiteTextField = new JTextField();
        this.suiteBrowseButton = new JButton();
        this.suiteInfoLabel = new JLabel();
        this.runTestUsingUnitCheckBox = new JCheckBox();
        this.setFocusTraversalPolicy(null);
        this.phpUnitLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.phpUnitLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.phpUnitLabel.text"));
        this.bootstrapLabel.setLabelFor(this.bootstrapTextField);
        Mnemonics.setLocalizedText((JLabel)this.bootstrapLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.text"));
        this.bootstrapBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.bootstrapBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapGenerateButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.text"));
        this.bootstrapGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.bootstrapGenerateButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapForCreateTestsCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapForCreateTestsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.text"));
        this.configurationLabel.setLabelFor(this.configurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.configurationLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.text"));
        this.configurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.configurationBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bootstrapCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.configurationGenerateButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.text"));
        this.configurationGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.configurationGenerateButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.suiteCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.text"));
        this.suiteLabel.setLabelFor(this.suiteTextField);
        Mnemonics.setLocalizedText((JLabel)this.suiteLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.suiteBrowseButton, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.text"));
        this.suiteBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerPhpUnit.this.suiteBrowseButtonActionPerformed(evt);
            }
        });
        this.suiteInfoLabel.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.suiteInfoLabel, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.runTestUsingUnitCheckBox, (String)NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.runTestUsingUnitCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configurationCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.configurationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationTextField, -1, 170, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configurationGenerateButton)).addComponent(this.suiteCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.suiteLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.suiteInfoLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.suiteTextField, -1, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suiteBrowseButton)))).addGroup(layout.createSequentialGroup().addComponent(this.phpUnitLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapCheckBox).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapForCreateTestsCheckBox).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.bootstrapLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapTextField, -1, 229, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapGenerateButton)))).addGroup(layout.createSequentialGroup().addComponent(this.runTestUsingUnitCheckBox).addContainerGap()));
        layout.linkSize(0, this.bootstrapBrowseButton, this.bootstrapGenerateButton, this.configurationBrowseButton, this.configurationGenerateButton, this.suiteBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.phpUnitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bootstrapLabel).addComponent(this.bootstrapTextField, -2, -1, -2).addComponent(this.bootstrapGenerateButton).addComponent(this.bootstrapBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bootstrapForCreateTestsCheckBox).addGap(18, 18, 18).addComponent(this.configurationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationLabel).addComponent(this.configurationTextField, -2, -1, -2).addComponent(this.configurationGenerateButton).addComponent(this.configurationBrowseButton)).addGap(18, 18, 18).addComponent(this.suiteCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.suiteLabel).addComponent(this.suiteTextField, -2, -1, -2).addComponent(this.suiteBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suiteInfoLabel).addGap(18, 18, 18).addComponent(this.runTestUsingUnitCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.phpUnitLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.phpUnitLabel.AccessibleContext.accessibleName"));
        this.phpUnitLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.phpUnitLabel.AccessibleContext.accessibleDescription"));
        this.bootstrapLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.AccessibleContext.accessibleName"));
        this.bootstrapLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapLabel.AccessibleContext.accessibleDescription"));
        this.bootstrapTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapTextField.AccessibleContext.accessibleName"));
        this.bootstrapTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapTextField.AccessibleContext.accessibleDescription"));
        this.bootstrapBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.AccessibleContext.accessibleName"));
        this.bootstrapBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapBrowseButton.AccessibleContext.accessibleDescription"));
        this.bootstrapGenerateButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.AccessibleContext.accessibleName"));
        this.bootstrapGenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapGenerateButton.AccessibleContext.accessibleDescription"));
        this.bootstrapForCreateTestsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapForCreateTestsCheckBox.AccessibleContext.accessibleName"));
        this.bootstrapForCreateTestsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapForCreateTestsCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.AccessibleContext.accessibleName"));
        this.configurationCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.AccessibleContext.accessibleName"));
        this.configurationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationLabel.AccessibleContext.accessibleDescription"));
        this.configurationTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationTextField.AccessibleContext.accessibleName"));
        this.configurationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationTextField.AccessibleContext.accessibleDescription"));
        this.configurationBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.AccessibleContext.accessibleName"));
        this.configurationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationBrowseButton.AccessibleContext.accessibleDescription"));
        this.bootstrapCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.AccessibleContext.accessibleName"));
        this.bootstrapCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.bootstrapCheckBox.AccessibleContext.accessibleDescription"));
        this.configurationGenerateButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.AccessibleContext.accessibleName"));
        this.configurationGenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.configurationGenerateButton.AccessibleContext.accessibleDescription"));
        this.suiteCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.AccessibleContext.accessibleName"));
        this.suiteCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteCheckBox.AccessibleContext.accessibleDescription"));
        this.suiteLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.AccessibleContext.accessibleName"));
        this.suiteLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteLabel.AccessibleContext.accessibleDescription"));
        this.suiteTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteTextField.AccessibleContext.accessibleName"));
        this.suiteTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteTextField.AccessibleContext.accessibleDescription"));
        this.suiteBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.AccessibleContext.accessibleName"));
        this.suiteBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteBrowseButton.AccessibleContext.accessibleDescription"));
        this.suiteInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.AccessibleContext.accessibleName"));
        this.suiteInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.suiteInfoLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerPhpUnit.class, (String)"CustomizerPhpUnit.AccessibleContext.accessibleDescription"));
    }

    private void bootstrapBrowseButtonActionPerformed(ActionEvent evt) {
        File file = Utils.browseFileAction(this, this.getDefaultDirectory(), NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_SelectBootstrap"));
        if (file != null) {
            this.bootstrapTextField.setText(file.getAbsolutePath());
        }
    }

    private void bootstrapGenerateButtonActionPerformed(ActionEvent evt) {
        File bootstrap;
        if (this.checkTestDirectory() && (bootstrap = PhpUnit.createBootstrapFile(this.project)) != null) {
            this.bootstrapTextField.setText(bootstrap.getAbsolutePath());
        }
    }

    private void configurationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = Utils.browseFileAction(this, this.getDefaultDirectory(), NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_SelectConfiguration"));
        if (file != null) {
            this.configurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void configurationGenerateButtonActionPerformed(ActionEvent evt) {
        File configuration;
        if (this.checkTestDirectory() && (configuration = PhpUnit.createConfigurationFile(this.project)) != null) {
            this.configurationTextField.setText(configuration.getAbsolutePath());
        }
    }

    private void suiteBrowseButtonActionPerformed(ActionEvent evt) {
        File file = Utils.browseFileAction(this, this.getDefaultDirectory(), NbBundle.getMessage(CustomizerPhpUnit.class, (String)"LBL_SelectSuite"));
        if (file != null) {
            this.suiteTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            CustomizerPhpUnit.this.validateData();
        }
    }
}

