/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class SelectFilePanel
extends JPanel {
    private static final long serialVersionUID = 8464321687132132L;
    final FileObject sourceRoot;
    private final DefaultListModel model;
    private DialogDescriptor dialogDescriptor;
    private NotificationLineSupport notificationLineSupport;
    private JLabel selectFileLabel;
    private JList selectFileList;
    private JScrollPane selectFileScrollPane;

    private SelectFilePanel(FileObject sourceRoot, List<FileObject> files) {
        assert (sourceRoot != null);
        assert (files.size() > 1);
        this.sourceRoot = sourceRoot;
        this.initComponents();
        this.model = new DefaultListModel();
        for (FileObject fo : files) {
            assert (FileUtil.isParentOf((FileObject)sourceRoot, (FileObject)fo));
            this.model.addElement(fo);
        }
        this.selectFileList.setCellRenderer(new FileListCellRenderer());
        this.selectFileList.setModel(this.model);
        this.selectFileList.setSelectedIndex(0);
        this.selectFileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectFilePanel.this.validateSelection();
            }
        });
    }

    public static FileObject open(FileObject sourceRoot, List<FileObject> files) {
        SelectFilePanel panel = new SelectFilePanel(sourceRoot, files);
        panel.dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(SelectFilePanel.class, (String)"LBL_SelectFile"), true, 2, DialogDescriptor.OK_OPTION, null);
        panel.notificationLineSupport = panel.dialogDescriptor.createNotificationLineSupport();
        panel.validateSelection();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)panel.dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            return panel.getSelectedFile();
        }
        return null;
    }

    private FileObject getSelectedFile() {
        return (FileObject)this.selectFileList.getSelectedValue();
    }

    void validateSelection() {
        assert (this.notificationLineSupport != null);
        if (this.getSelectedFile() == null) {
            this.notificationLineSupport.setErrorMessage(NbBundle.getMessage(SelectFilePanel.class, (String)"MSG_NoFileSelected"));
            this.dialogDescriptor.setValid(false);
            return;
        }
        this.notificationLineSupport.clearMessages();
        this.dialogDescriptor.setValid(true);
    }

    private void initComponents() {
        this.selectFileLabel = new JLabel();
        this.selectFileScrollPane = new JScrollPane();
        this.selectFileList = new JList();
        this.selectFileLabel.setLabelFor(this.selectFileList);
        Mnemonics.setLocalizedText((JLabel)this.selectFileLabel, (String)NbBundle.getMessage(SelectFilePanel.class, (String)"SelectFilePanel.selectFileLabel.text"));
        this.selectFileList.setSelectionMode(0);
        this.selectFileScrollPane.setViewportView(this.selectFileList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectFileScrollPane, -1, 280, Short.MAX_VALUE).addComponent(this.selectFileLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.selectFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectFileScrollPane, -2, 85, -2)));
    }

    private final class FileListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private static final long serialVersionUID = 219632875612323L;

        public FileListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String relativePath = FileUtil.getRelativePath((FileObject)SelectFilePanel.this.sourceRoot, (FileObject)((FileObject)value));
            this.setText(relativePath);
            this.setToolTipText(relativePath);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

