/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.ui.actions.support.DebugScript;
import org.netbeans.modules.php.project.ui.actions.support.DefaultScriptProvider;
import org.netbeans.modules.php.project.ui.actions.support.RunFilePanel;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class RunFileActionProvider
implements ActionProvider {
    private static final Map<File, RunFileArgs> ARGS_FOR_FILE = new HashMap<File, RunFileArgs>();

    public String[] getSupportedActions() {
        return new String[]{"run.single", "debug.single"};
    }

    public boolean isActionEnabled(String command, Lookup context) {
        Project p = (Project)context.lookup(Project.class);
        if (p != null) {
            return false;
        }
        Collection files = context.lookupAll(DataObject.class);
        if (files.isEmpty()) {
            return false;
        }
        for (DataObject d : files) {
            if (FileUtils.isPhpFile((FileObject)d.getPrimaryFile())) continue;
            return false;
        }
        return !"debug.single".equals(command) || XDebugStarterFactory.getInstance() != null;
    }

    public void invokeAction(String command, Lookup context) {
        boolean debug = "debug.single".equals(command);
        for (DataObject dataObject : context.lookupAll(DataObject.class)) {
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            if (file == null) continue;
            PhpProjectUtils.saveFile(dataObject);
            this.runFile(file, debug);
        }
    }

    private void runFile(File file, boolean debug) {
        RunFileArgs runFileArgs;
        RunFileArgs existing = ARGS_FOR_FILE.get(file);
        if (existing != null && !existing.displayDialog) {
            this.doRun(file, existing, debug);
            return;
        }
        if (existing == null) {
            existing = new RunFileArgs(null, file.getParent(), null, true);
        }
        if ((runFileArgs = RunFilePanel.open(existing, file, debug)) == null) {
            return;
        }
        ARGS_FOR_FILE.put(file, runFileArgs);
        this.doRun(file, runFileArgs, debug);
    }

    private void doRun(File file, RunFileArgs args, boolean debug) {
        RunFileScriptProvider provider = new RunFileScriptProvider(file, args);
        if (debug) {
            new DebugScript(provider).run();
        } else {
            new RunScript(provider).run();
        }
    }

    static final class RunFileArgs {
        private final String runArgs;
        private final String workDir;
        private final String phpOpts;
        private final boolean displayDialog;

        public RunFileArgs(String runArgs, String workDir, String phpOpts, boolean displayDialog) {
            this.runArgs = runArgs;
            this.workDir = workDir;
            this.phpOpts = phpOpts;
            this.displayDialog = displayDialog;
        }

        public String getRunArgs() {
            return this.runArgs;
        }

        public boolean displayDialog() {
            return this.displayDialog;
        }

        public String getWorkDir() {
            return this.workDir;
        }

        public String getPhpOpts() {
            return this.phpOpts;
        }
    }

    private static final class RunFileScriptProvider
    extends DefaultScriptProvider {
        private final RunFileArgs args;

        public RunFileScriptProvider(File file, RunFileArgs args) {
            super(file);
            this.args = args;
        }

        @Override
        public ExternalProcessBuilder getProcessBuilder() {
            ExternalProcessBuilder builder = this.program.getProcessBuilder();
            for (String param : Utilities.parseParameters((String)this.args.getPhpOpts())) {
                builder = builder.addArgument(param);
            }
            builder = builder.addArgument(this.file.getAbsolutePath());
            for (String param : Utilities.parseParameters((String)this.args.getRunArgs())) {
                builder = builder.addArgument(param);
            }
            builder = builder.workingDirectory(new File(this.args.getWorkDir()));
            return builder;
        }
    }
}

