/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class UploadCommand
extends RemoteCommand
implements Displayable {
    public static final String ID = "upload";
    public static final String DISPLAY_NAME = NbBundle.getMessage(UploadCommand.class, (String)"LBL_UploadCommand");

    public UploadCommand(PhpProject project) {
        super(project);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    protected Runnable getContextRunnable(final Lookup context) {
        return new Runnable(){

            @Override
            public void run() {
                UploadCommand.this.invokeActionImpl(context);
            }
        };
    }

    void invokeActionImpl(Lookup context) {
        FileObject[] selectedFiles = CommandUtils.filesForContextOrSelectedNodes(context);
        if (selectedFiles.length == 0) {
            return;
        }
        this.uploadFiles(selectedFiles, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFiles(FileObject[] filesToUpload, FileObject[] preselectedFiles) {
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.getProject());
        if (!this.sourcesFilesOnly(sources, filesToUpload)) {
            return;
        }
        InputOutput remoteLog = UploadCommand.getRemoteLog(this.getRemoteConfiguration().getDisplayName());
        RemoteCommand.DefaultOperationMonitor uploadOperationMonitor = new RemoteCommand.DefaultOperationMonitor("LBL_Uploading");
        RemoteClient remoteClient = this.getRemoteClient(remoteLog, uploadOperationMonitor);
        String progressTitle = NbBundle.getMessage(UploadCommand.class, (String)"MSG_UploadingFiles", (Object)this.getProject().getName());
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)progressTitle, (Cancellable)remoteClient);
        TransferInfo transferInfo = null;
        try {
            progressHandle.start();
            Set<TransferFile> forUpload = remoteClient.prepareUpload(sources, filesToUpload);
            if (preselectedFiles != null && preselectedFiles.length > 0) {
                File baseLocalDir = FileUtil.toFile((FileObject)sources);
                String baseLocalAbsolutePath = baseLocalDir.getAbsolutePath();
                block14: for (FileObject fo : preselectedFiles) {
                    TransferFile transferFile = TransferFile.fromFileObject(null, fo, baseLocalAbsolutePath);
                    for (TransferFile file : forUpload) {
                        if (!transferFile.equals(file)) continue;
                        file.touch();
                        continue block14;
                    }
                }
            }
            boolean showDialog = true;
            if (forUpload.size() == 1 && forUpload.iterator().next().isFile()) {
                showDialog = false;
            }
            if (showDialog) {
                forUpload = TransferFilesChooser.forUpload(forUpload, ProjectSettings.getLastUpload(this.getProject())).showDialog();
            }
            if (forUpload.isEmpty()) {
                return;
            }
            if (forUpload.size() > 0) {
                progressHandle.finish();
                uploadOperationMonitor.progressHandle = progressHandle = ProgressHandleFactory.createHandle((String)progressTitle, (Cancellable)remoteClient);
                progressHandle.start(UploadCommand.getWorkUnits(forUpload));
                transferInfo = remoteClient.upload(sources, forUpload);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UploadCommand.class, (String)"MSG_UploadFinished", (Object)this.getProject().getName()));
                if (!remoteClient.isCancelled() && transferInfo.hasAnyTransfered()) {
                    this.rememberLastUpload(sources, filesToUpload);
                }
            }
        }
        catch (RemoteException ex) {
            UploadCommand.processRemoteException(ex);
        }
        finally {
            try {
                remoteClient.disconnect();
            }
            catch (RemoteException ex) {
                UploadCommand.processRemoteException(ex);
            }
            if (transferInfo != null) {
                UploadCommand.processTransferInfo(transferInfo, remoteLog);
            }
            progressHandle.finish();
        }
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    private void rememberLastUpload(FileObject sources, FileObject[] selectedFiles) {
        for (FileObject fo : selectedFiles) {
            if (!sources.equals(fo)) continue;
            ProjectSettings.setLastUpload(this.getProject(), TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            return;
        }
    }
}

