/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnalyzeFolder
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    public static final String FOLDER_KEY = "folder";

    public AnalyzeFolder() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(FOLDER_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeFolder.i18n("Folder_Files_Name");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("Folder_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.Folder;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeFolder.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeFolder.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "dwarf-folder";
    }

    public String getName() {
        return AnalyzeFolder.i18n("Folder_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeFolder.i18n("Folder_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
        String root = (String)this.getProperty(FOLDER_KEY).getValue();
        if (root == null || root.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NoBaseFolder")));
        }
        Set<String> set = this.getObjectFiles(root);
        if (set.isEmpty()) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutablesInFolder", (Object)root)));
        }
        int i = 0;
        for (String obj : set) {
            ++i;
            ApplicableImpl applicable = this.sizeComilationUnit(obj, null);
            if (applicable.isApplicable()) {
                return new ApplicableImpl(true, applicable.getErrors(), applicable.getCompilerName(), 50, applicable.isSunStudio(), null, null, null, null);
            }
            if (i <= 25) continue;
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutableWithDebugInformation", (Object)root)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutableWithDebugInformation", (Object)root)));
    }

    public List<Configuration> analyze(final ProjectProxy project, final Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.setCommpilerSettings(project);
        if (!this.isStoped.get()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        if (progress != null) {
                            progress.start();
                        }
                        try {
                            Set set = AnalyzeFolder.this.getObjectFiles((String)AnalyzeFolder.this.getProperty(AnalyzeFolder.FOLDER_KEY).getValue());
                            if (progress != null) {
                                progress.start(set.size());
                            }
                            this.myFileProperties = set.size() > 0 ? AnalyzeFolder.this.getSourceFileProperties(set.toArray(new String[set.size()]), progress, null, null) : new ArrayList<SourceFileProperties>();
                        }
                        finally {
                            if (progress != null) {
                                progress.done();
                            }
                        }
                    }
                    return this.myFileProperties;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (AnalyzeFolder.this.isStoped.get()) break;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        if (progress != null) {
                            progress.start(set.size());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            File file;
                            if (AnalyzeFolder.this.isStoped.get()) break;
                            if (progress != null) {
                                Progress progress2 = progress;
                                synchronized (progress2) {
                                    progress.increment(path);
                                }
                            }
                            if (!(file = new File(path)).exists()) continue;
                            unique.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        if (progress != null) {
                            progress.done();
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private Set<String> getObjectFiles(String root) {
        HashSet<String> set = new HashSet<String>();
        this.gatherSubFolders(new File(root), set);
        HashSet<String> map = new HashSet<String>();
        Iterator<String> it = set.iterator();
        while (it.hasNext() && !this.isStoped.get()) {
            File[] ff;
            File d = new File(it.next());
            if (!d.exists() || !d.isDirectory() || !d.canRead() || (ff = d.listFiles()) == null) continue;
            for (int i = 0; i < ff.length; ++i) {
                String name;
                if (!ff[i].isFile() || !(name = ff[i].getName()).endsWith(".o") && !name.endsWith(".so") && !name.endsWith(".dylib") && !name.endsWith(".a") && !this.isExecutable(ff[i])) continue;
                String path = ff[i].getAbsolutePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
                map.add(path);
            }
        }
        return map;
    }

    private boolean isExecutable(File file) {
        String name = file.getName();
        if (Utilities.isWindows()) {
            return name.endsWith(".exe") || name.endsWith(".dll");
        }
        if (Utilities.isUnix()) {
            try {
                return name.indexOf(46) < 0 && file.canExecute();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherSubFolders(File d, HashSet<String> set) {
        if (this.isStoped.get()) {
            return;
        }
        if (!d.exists() || !d.isDirectory() || !d.canRead()) return;
        if (CndPathUtilitities.isIgnoredFolder((File)d)) {
            return;
        }
        String path = d.getAbsolutePath();
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        if (set.contains(path)) return;
        set.add(path);
        File[] ff = d.listFiles();
        if (ff == null) return;
        for (int i = 0; i < ff.length; ++i) {
            if (!ff[i].isDirectory()) continue;
            try {
                String canPath = ff[i].getCanonicalPath();
                String absPath = ff[i].getAbsolutePath();
                if (!absPath.equals(canPath) && absPath.startsWith(canPath)) {
                    continue;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.gatherSubFolders(ff[i], set);
        }
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)id);
    }
}

