/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.AnalyzeFolder;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;

public class AnalyzeExecutable
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String EXECUTABLE_KEY = "executable";
    public static final String LIBRARIES_KEY = "libraries";

    public AnalyzeExecutable() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXECUTABLE_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Executable_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Executable_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFile;
            }
        });
        this.myProperties.put(LIBRARIES_KEY, new ProviderProperty(){
            private String[] myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Libraries_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Libraries_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String[]) {
                    this.myPath = (String[])value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFiles;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecutable.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecutable.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object value) {
                if (value instanceof String) {
                    this.myPath = (String)value;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "dwarf-executable";
    }

    public String getName() {
        return AnalyzeExecutable.i18n("Executable_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeExecutable.i18n("Executable_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project) {
        String set = (String)this.getProperty(EXECUTABLE_KEY).getValue();
        if (set == null || set.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"NoExecutable")));
        }
        HashSet<String> dlls = new HashSet<String>();
        ApplicableImpl applicable = this.sizeComilationUnit(set, dlls);
        if (applicable.isApplicable()) {
            return new ApplicableImpl(true, applicable.getErrors(), applicable.getCompilerName(), 70, applicable.isSunStudio(), applicable.getDependencies(), applicable.getSearchPaths(), applicable.getSourceRoot(), applicable.getMainFunction());
        }
        if (applicable.getErrors().size() > 0) {
            return ApplicableImpl.getNotApplicable((List)applicable.getErrors());
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"CannotAnalyzeExecutable", (Object)set)));
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.setCommpilerSettings(project);
        if (!this.isStoped.get()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;
                private Set<String> myDependencies;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    if (this.myDependencies == null) {
                        this.getSourcesConfiguration();
                    }
                    return new ArrayList<String>(this.myDependencies);
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        this.myDependencies = new HashSet<String>();
                        String set = (String)AnalyzeExecutable.this.getProperty(AnalyzeExecutable.EXECUTABLE_KEY).getValue();
                        if (set != null && set.length() > 0) {
                            String[] add = (String[])AnalyzeExecutable.this.getProperty(AnalyzeExecutable.LIBRARIES_KEY).getValue();
                            if (add == null || add.length == 0) {
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(new String[]{set}, null, null, this.myDependencies);
                            } else {
                                String[] all = new String[add.length + 1];
                                all[0] = set;
                                System.arraycopy(add, 0, all, 1, add.length);
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(all, null, null, this.myDependencies);
                            }
                        }
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (AnalyzeExecutable.this.isStoped.get()) break;
                            if (!(source instanceof DwarfSource)) continue;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            if (AnalyzeExecutable.this.isStoped.get()) break;
                            File file = new File(path);
                            if (!CndFileUtils.exists((File)file)) continue;
                            unique.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)id);
    }
}

